/*
 * Decompiled with CFR 0.152.
 */
package org.planit.zoning;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Polygon;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.zoning.Centroid;
import org.planit.utils.zoning.Zone;
import org.planit.zoning.CentroidImpl;

public class ZoneImpl
implements Zone {
    protected final long id;
    protected String externalId;
    protected String xmlId;
    protected Map<String, Object> inputProperties = null;
    protected final Centroid centroid;
    protected Polygon geometry = null;

    protected static long generateZoneId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Zone.class);
    }

    public ZoneImpl(IdGroupingToken tokenId) {
        this.id = ZoneImpl.generateZoneId(tokenId);
        this.centroid = new CentroidImpl(tokenId, this);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    @Override
    public Centroid getCentroid() {
        return this.centroid;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    @Override
    public void setGeometry(Polygon geometry) {
    }

    @Override
    public Polygon getGeometry() {
        return null;
    }
}

