/*
 * Decompiled with CFR 0.152.
 */
package org.planit.zoning;

import java.io.Serializable;
import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignmentComponent;
import org.planit.demands.Demands;
import org.planit.network.virtual.VirtualNetwork;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.time.TimePeriod;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.Modes;
import org.planit.utils.zoning.Connectoids;
import org.planit.utils.zoning.OdZone;
import org.planit.utils.zoning.TransferZone;
import org.planit.utils.zoning.Zone;
import org.planit.utils.zoning.Zones;
import org.planit.zoning.ConnectoidsImpl;
import org.planit.zoning.OdZonesImpl;
import org.planit.zoning.TransferZonesImpl;

public class Zoning
extends TrafficAssignmentComponent<Zoning>
implements Serializable {
    private static final long serialVersionUID = -2986366471146628179L;
    private static final Logger LOGGER = Logger.getLogger(Zoning.class.getCanonicalName());
    protected final VirtualNetwork virtualNetwork;
    public final Connectoids connectoids;
    public final Zones<OdZone> odZones;
    public final Zones<TransferZone> transferZones;

    public Zoning(IdGroupingToken groupId, IdGroupingToken networkGroupId) {
        super(groupId, Zoning.class);
        this.connectoids = new ConnectoidsImpl(networkGroupId);
        this.odZones = new OdZonesImpl(networkGroupId);
        this.transferZones = new TransferZonesImpl(networkGroupId);
        this.virtualNetwork = new VirtualNetwork(networkGroupId);
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public boolean isCompatibleWithDemands(Demands demands, Modes modes) {
        int nofZones = this.odZones.size();
        for (Mode mode : modes) {
            for (TimePeriod timePeriod : demands.timePeriods) {
                ODDemandMatrix odMatrix = demands.get(mode, timePeriod);
                if (odMatrix == null || nofZones == odMatrix.getNumberOfTravelAnalysisZones()) continue;
                return false;
            }
        }
        return true;
    }

    public Zone getZone(long id) {
        Zone zone = this.odZones.get(id);
        if (zone == null) {
            zone = this.transferZones.get(id);
        }
        return zone;
    }

    public long getNumberOfCentroids() {
        return this.odZones.getNumberOfCentroids() + this.transferZones.getNumberOfCentroids();
    }
}

