/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.djutils.event.Event;
import org.djutils.event.EventInterface;
import org.djutils.event.EventListenerInterface;
import org.djutils.event.EventListenerMap;
import org.djutils.event.EventProducerInterface;
import org.djutils.event.EventType;
import org.djutils.event.TimedEvent;
import org.djutils.event.ref.Reference;
import org.djutils.event.ref.ReferenceType;
import org.djutils.event.ref.StrongReference;
import org.djutils.event.ref.WeakReference;
import org.djutils.exceptions.Throw;
import org.djutils.logger.CategoryLogger;

public abstract class EventProducer
implements EventProducerInterface,
Serializable {
    private static final long serialVersionUID = 20140830L;
    protected EventListenerMap listeners = new EventListenerMap();
    private static final transient Map<Class<? extends EventProducer>, EventType[]> EVENTTYPE_CACHE = new LinkedHashMap<Class<? extends EventProducer>, EventType[]>();

    private boolean checkNoDuplicateEventTypes() {
        EventType[] events = EventProducer.getStaticEventTypes(this.getClass());
        for (int i = 0; i < events.length; ++i) {
            for (int j = i + 1; j < events.length; ++j) {
                if (!events[i].equals(events[j])) continue;
                return false;
            }
        }
        return true;
    }

    public EventProducer() {
        if (!this.checkNoDuplicateEventTypes()) {
            throw new RuntimeException("EventProducer failed: more events have the same class + name combination");
        }
    }

    @Override
    public abstract Serializable getSourceId();

    @Override
    public final synchronized boolean addListener(EventListenerInterface listener, EventType eventType) {
        return this.addListener(listener, eventType, 0);
    }

    @Override
    public final synchronized boolean addListener(EventListenerInterface listener, EventType eventType, ReferenceType referenceType) {
        return this.addListener(listener, eventType, 0, referenceType);
    }

    @Override
    public final synchronized boolean addListener(EventListenerInterface listener, EventType eventType, int position) {
        return this.addListener(listener, eventType, position, ReferenceType.STRONG);
    }

    @Override
    public final synchronized boolean addListener(EventListenerInterface listener, EventType eventType, int position, ReferenceType referenceType) {
        Throw.whenNull(listener, "listener cannot be null");
        Throw.whenNull(eventType, "eventType cannot be null");
        Throw.whenNull(referenceType, "referenceType cannot be null");
        if (position < -1) {
            return false;
        }
        Reference reference = null;
        reference = referenceType.isStrong() ? new StrongReference<EventListenerInterface>(listener) : new WeakReference<EventListenerInterface>(listener);
        if (this.listeners.containsKey(eventType)) {
            for (Reference<EventListenerInterface> entry : this.listeners.get(eventType)) {
                if (!listener.equals(entry.get())) continue;
                return false;
            }
            List<Reference<EventListenerInterface>> entries = this.listeners.get(eventType);
            if (position == -1) {
                entries.add(reference);
            } else {
                entries.add(position, reference);
            }
        } else {
            ArrayList<Reference<EventListenerInterface>> entries = new ArrayList<Reference<EventListenerInterface>>();
            entries.add(reference);
            this.listeners.put(eventType, entries);
        }
        return true;
    }

    protected EventInterface fireEvent(EventListenerInterface listener, EventInterface event) throws RemoteException {
        listener.notify(event);
        return event;
    }

    protected synchronized EventInterface fireEvent(EventInterface event) {
        Throw.whenNull(event, "event may not be null");
        Throw.whenNull(event.getType(), "event type may not be null");
        if (this.listeners.containsKey(event.getType())) {
            ArrayList<Reference<EventListenerInterface>> listenerList = new ArrayList<Reference<EventListenerInterface>>(this.listeners.get(event.getType()));
            for (Reference reference : listenerList) {
                EventListenerInterface listener = (EventListenerInterface)reference.get();
                try {
                    if (listener != null) {
                        this.fireEvent(listener, event);
                        continue;
                    }
                    this.removeListener(reference, event.getType());
                }
                catch (RemoteException remoteException) {
                    this.removeListener(reference, event.getType());
                }
            }
        }
        return event;
    }

    protected Serializable fireEvent(EventType eventType, Serializable value) {
        this.fireEvent(new Event(eventType, this.getSourceId(), value));
        return value;
    }

    protected void fireEvent(EventType eventType) {
        this.fireEvent(new Event(eventType, this.getSourceId(), null));
    }

    protected <C extends Comparable<C> & Serializable> Serializable fireTimedEvent(EventType eventType, Serializable value, C time) {
        Throw.whenNull(time, "time may not be null");
        this.fireEvent(new TimedEvent<C>(eventType, this.getSourceId(), value, time));
        return value;
    }

    protected byte fireEvent(EventType eventType, byte value) {
        this.fireEvent(eventType, Byte.valueOf(value));
        return value;
    }

    protected <C extends Comparable<C> & Serializable> byte fireTimedEvent(EventType eventType, byte value, C time) {
        this.fireTimedEvent(eventType, Byte.valueOf(value), time);
        return value;
    }

    protected boolean fireEvent(EventType eventType, boolean value) {
        this.fireEvent(eventType, Boolean.valueOf(value));
        return value;
    }

    protected <C extends Comparable<C> & Serializable> boolean fireTimedEvent(EventType eventType, boolean value, C time) {
        this.fireTimedEvent(eventType, Boolean.valueOf(value), time);
        return value;
    }

    protected double fireEvent(EventType eventType, double value) {
        this.fireEvent(eventType, Double.valueOf(value));
        return value;
    }

    protected <C extends Comparable<C> & Serializable> double fireTimedEvent(EventType eventType, double value, C time) {
        this.fireTimedEvent(eventType, Double.valueOf(value), time);
        return value;
    }

    protected int fireEvent(EventType eventType, int value) {
        this.fireEvent(eventType, Integer.valueOf(value));
        return value;
    }

    protected <C extends Comparable<C> & Serializable> int fireTimedEvent(EventType eventType, int value, C time) {
        this.fireTimedEvent(eventType, Integer.valueOf(value), time);
        return value;
    }

    protected long fireEvent(EventType eventType, long value) {
        this.fireEvent(eventType, Long.valueOf(value));
        return value;
    }

    protected <C extends Comparable<C> & Serializable> long fireTimedEvent(EventType eventType, long value, C time) {
        this.fireTimedEvent(eventType, Long.valueOf(value), time);
        return value;
    }

    protected short fireEvent(EventType eventType, short value) {
        this.fireEvent(eventType, Short.valueOf(value));
        return value;
    }

    protected <C extends Comparable<C> & Serializable> short fireTimedEvent(EventType eventType, short value, C time) {
        this.fireTimedEvent(eventType, Short.valueOf(value), time);
        return value;
    }

    private static EventType[] getStaticEventTypes(Class<? extends EventProducer> checkClass) {
        Throw.whenNull(checkClass, "checkClass may not be null");
        if (EVENTTYPE_CACHE.containsKey(checkClass)) {
            return EVENTTYPE_CACHE.get(checkClass);
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<? extends EventProducer> clazz = checkClass; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields = clazz.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                fieldList.add(declaredFields[i]);
            }
        }
        ArrayList<EventType> eventTypeList = new ArrayList<EventType>();
        for (Field field : fieldList) {
            if (!field.getType().equals(EventType.class) || Modifier.isPrivate(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                eventTypeList.add((EventType)field.get(null));
            }
            catch (Exception exception) {
                CategoryLogger.always().error(exception);
            }
        }
        EVENTTYPE_CACHE.put(checkClass, eventTypeList.toArray(new EventType[eventTypeList.size()]));
        return EVENTTYPE_CACHE.get(checkClass);
    }

    protected synchronized int removeAllListeners() {
        int result = this.listeners.size();
        this.listeners = null;
        this.listeners = new EventListenerMap();
        return result;
    }

    protected synchronized int removeAllListeners(Class<?> ofClass) {
        Throw.whenNull(ofClass, "ofClass may not be null");
        int result = 0;
        LinkedHashMap<EventType, Reference<EventListenerInterface>> removeMap = new LinkedHashMap<EventType, Reference<EventListenerInterface>>();
        for (EventType type : this.listeners.keySet()) {
            for (Reference<EventListenerInterface> listener : this.listeners.get(type)) {
                if (!listener.get().getClass().isAssignableFrom(ofClass)) continue;
                removeMap.put(type, listener);
                ++result;
            }
        }
        for (EventType type : removeMap.keySet()) {
            this.removeListener((EventListenerInterface)((Reference)removeMap.get(type)).get(), type);
        }
        return result;
    }

    @Override
    public final synchronized boolean removeListener(EventListenerInterface listener, EventType eventType) {
        Throw.whenNull(listener, "listener may not be null");
        Throw.whenNull(eventType, "eventType may not be null");
        if (!this.listeners.containsKey(eventType)) {
            return false;
        }
        boolean result = false;
        Iterator<Reference<EventListenerInterface>> i = this.listeners.get(eventType).iterator();
        while (i.hasNext()) {
            Reference<EventListenerInterface> reference = i.next();
            EventListenerInterface entry = reference.get();
            if (entry == null) {
                i.remove();
            } else if (listener.equals(entry)) {
                i.remove();
                result = true;
            }
            if (this.listeners.get(eventType).size() != 0) continue;
            this.listeners.remove(eventType);
        }
        return result;
    }

    private synchronized boolean removeListener(Reference<EventListenerInterface> reference, EventType eventType) {
        Throw.whenNull(reference, "reference may not be null");
        Throw.whenNull(eventType, "eventType may not be null");
        boolean success = false;
        Iterator<Reference<EventListenerInterface>> i = this.listeners.get(eventType).iterator();
        while (i.hasNext()) {
            if (!i.next().equals(reference)) continue;
            i.remove();
            success = true;
        }
        if (this.listeners.get(eventType).size() == 0) {
            this.listeners.remove(eventType);
        }
        return success;
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public synchronized int numberOfListeners(EventType eventType) {
        if (this.listeners.containsKey(eventType)) {
            return this.listeners.get(eventType).size();
        }
        return 0;
    }

    @Override
    public synchronized Set<EventType> getEventTypesWithListeners() {
        return this.listeners.keySet();
    }
}

