/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityMediator;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public abstract class AbstractEpsgMediator
extends AbstractAuthorityMediator {
    public static final int PRIORITY = 40;
    private static final Logger LOGGER = Logging.getLogger(AbstractEpsgMediator.class);
    protected DataSource datasource;

    public AbstractEpsgMediator() {
    }

    public AbstractEpsgMediator(Hints hints) throws FactoryException {
        this(hints, AbstractEpsgMediator.lookupDataSource(hints));
    }

    static DataSource lookupDataSource(Hints hints) throws FactoryException {
        Object hint = hints.get(Hints.EPSG_DATA_SOURCE);
        if (hint instanceof DataSource) {
            return (DataSource)hint;
        }
        if (hint instanceof String) {
            String name = (String)hint;
            try {
                InitialContext context = GeoTools.getInitialContext(hints);
                return (DataSource)context.lookup(name);
            }
            catch (Exception e) {
                throw new FactoryException("EPSG_DATA_SOURCE '" + name + "' not found:" + e, e);
            }
        }
        throw new FactoryException("EPSG_DATA_SOURCE must be provided");
    }

    public AbstractEpsgMediator(Hints hints, DataSource datasource) {
        super(40, hints);
        if (datasource != null) {
            this.datasource = datasource;
        } else {
            try {
                this.datasource = AbstractEpsgMediator.lookupDataSource(hints);
            }
            catch (FactoryException lookupFailed) {
                throw (NullPointerException)new NullPointerException("DataSource not provided:" + lookupFailed).initCause(lookupFailed);
            }
        }
        hints.put(Hints.EPSG_DATA_SOURCE, this.datasource);
    }

    protected Connection getConnection() throws SQLException {
        try {
            return this.datasource.getConnection();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Connection failed", e);
            throw e;
        }
    }

    @Override
    public Citation getAuthority() {
        return Citations.EPSG;
    }

    @Override
    public void dispose() throws FactoryException {
        super.dispose();
        this.datasource = null;
    }

    @Override
    public boolean isConnected() {
        return this.datasource != null && super.isConnected();
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        IdentifiedObject identifiedObject = this.createObject(code);
        ReferenceIdentifier identifier = identifiedObject.getName();
        if (identifier instanceof GenericName) {
            return ((GenericName)((Object)identifier)).toInternationalString();
        }
        return new SimpleInternationalString(identifier.getCode());
    }
}

