/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.Spliterators;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.Raw1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;

public abstract class ReferenceTypeArray<N extends Number>
extends PlainArray<N>
implements Mutate1D.Sortable {
    public final N[] data;

    protected static <N extends Number> void exchange(N[] data, int firstA, int firstB, int step, int aCount) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < aCount; ++i) {
            N tmpVal = data[tmpIndexA];
            data[tmpIndexA] = data[tmpIndexB];
            data[tmpIndexB] = tmpVal;
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    protected static <N extends Number> void fill(N[] data, int first, int limit, int step, N value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    protected static <N extends Number> void fill(N[] data, int first, int limit, int step, NullaryFunction<N> supplier) {
        for (int i = first; i < limit; i += step) {
            data[i] = supplier.invoke();
        }
    }

    protected static <N extends Number> void invoke(N[] data, int first, int limit, int step, Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(left.get(i), right.get(i));
        }
    }

    protected static <N extends Number> void invoke(N[] data, int first, int limit, int step, Access1D<N> left, BinaryFunction<N> function, N right) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(left.get(i), right);
        }
    }

    protected static <N extends Number> void invoke(N[] data, int first, int limit, int step, Access1D<N> value, ParameterFunction<N> function, int aParam) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(value.get(i), aParam);
        }
    }

    protected static <N extends Number> void invoke(N[] data, int first, int limit, int step, Access1D<N> value, UnaryFunction<N> function) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(value.get(i));
        }
    }

    protected static <N extends Number> void invoke(N[] data, int first, int limit, int step, N left, BinaryFunction<N> function, Access1D<N> right) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(left, right.get(i));
        }
    }

    protected static <N extends Number> void invoke(N[] data, int first, int limit, int step, VoidFunction<N> aVisitor) {
        for (int i = first; i < limit; i += step) {
            aVisitor.invoke(data[i]);
        }
    }

    ReferenceTypeArray(DenseArray.Factory<N> factory, int length) {
        super(factory, length);
        this.data = factory.scalar().newArrayInstance(length);
        this.fill(0, length, 1, this.factory().scalar().zero().get());
    }

    ReferenceTypeArray(DenseArray.Factory<N> factory, N[] data) {
        super(factory, data.length);
        this.data = data;
    }

    public boolean equals(Object anObj) {
        if (anObj instanceof ReferenceTypeArray) {
            return Arrays.equals(this.data, ((ReferenceTypeArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        int limit = (int)Math.min(this.count(), values.count());
        for (int i = 0; i < limit; ++i) {
            this.data[i] = this.factory().scalar().cast((Number)values.get(i));
        }
    }

    @Override
    public void fillMatching(Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), left.count(), right.count());
        for (int i = 0; i < tmpLimit; ++i) {
            this.data[i] = function.invoke(left.get(i), right.get(i));
        }
    }

    @Override
    public void fillMatching(UnaryFunction<N> function, Access1D<N> arguments) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), arguments.count());
        for (int i = 0; i < tmpLimit; ++i) {
            this.data[i] = function.invoke(arguments.get(i));
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void reset() {
        Arrays.fill(this.data, this.valueOf(PrimitiveMath.ZERO));
    }

    public final Spliterator<N> spliterator() {
        return Spliterators.spliterator(this.data, 0, this.data.length, 1040);
    }

    protected final N[] copyOfData() {
        return (Number[])Raw1D.copyOf(this.data);
    }

    @Override
    protected final double doubleValue(int index) {
        return ((Number)this.data[index]).doubleValue();
    }

    @Override
    protected final void exchange(int firstA, int firstB, int step, int count) {
        ReferenceTypeArray.exchange(this.data, (int)firstA, (int)firstB, (int)step, (int)count);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)1, left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<N> left, BinaryFunction<N> function, N right) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)1, left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, int step, N value) {
        ReferenceTypeArray.fill(this.data, (int)first, (int)limit, (int)step, value);
    }

    @Override
    protected final void fill(int first, int limit, int step, NullaryFunction<N> supplier) {
        ReferenceTypeArray.fill(this.data, (int)first, (int)limit, (int)step, supplier);
    }

    @Override
    protected final void fill(int first, int limit, N left, BinaryFunction<N> function, Access1D<N> right) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)1, left, function, right);
    }

    @Override
    protected final void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.data[index] = this.valueOf((Number)values.get(valueIndex));
    }

    @Override
    protected final void fillOne(int index, N value) {
        this.data[index] = value;
    }

    @Override
    protected final void fillOne(int index, NullaryFunction<N> supplier) {
        this.data[index] = supplier.get();
    }

    @Override
    protected final N get(int index) {
        return this.data[index];
    }

    @Override
    protected final void modify(int first, int limit, int step, Access1D<N> left, BinaryFunction<N> function) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, left, function, (Access1D)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<N> function, Access1D<N> right) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, (Access1D)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<N> function, N right) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, (Access1D)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, N left, BinaryFunction<N> function) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, left, function, (Access1D)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, ParameterFunction<N> function, int parameter) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, (Access1D)this, function, (int)parameter);
    }

    @Override
    protected final void modify(int first, int limit, int step, UnaryFunction<N> function) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, (Access1D)this, function);
    }

    @Override
    protected final void modifyOne(int index, UnaryFunction<N> modifier) {
        this.data[index] = modifier.invoke(this.data[index]);
    }

    @Override
    protected final int searchAscending(N value) {
        return Arrays.binarySearch(this.data, value);
    }

    @Override
    protected final void set(int index, double value) {
        this.data[index] = this.valueOf(value);
    }

    @Override
    protected final void set(int index, Number value) {
        this.data[index] = this.valueOf(value);
    }

    @Override
    protected final int size() {
        return this.data.length;
    }

    @Override
    protected final void visit(int first, int limit, int step, VoidFunction<N> visitor) {
        ReferenceTypeArray.invoke(this.data, (int)first, (int)limit, (int)step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<N> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    final boolean isPrimitive() {
        return false;
    }

    @Override
    final void modify(long extIndex, int intIndex, Access1D<N> left, BinaryFunction<N> function) {
        this.data[intIndex] = function.invoke(left.get(extIndex), this.data[intIndex]);
    }

    @Override
    final void modify(long extIndex, int intIndex, BinaryFunction<N> function, Access1D<N> right) {
        this.data[intIndex] = function.invoke(this.data[intIndex], right.get(extIndex));
    }

    @Override
    final void modify(long extIndex, int intIndex, UnaryFunction<N> function) {
        this.data[intIndex] = function.invoke(this.data[intIndex]);
    }

    final N valueOf(double value) {
        return this.factory().scalar().cast(value);
    }

    final N valueOf(Number number) {
        return this.factory().scalar().cast(number);
    }
}

