/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.ProgrammingError;
import org.ojalgo.concurrent.DaemonPoolExecutor;

public abstract class DivideAndConquer {
    public final void invoke(int first, int limit, int threshold) {
        int availableWorkers = OjAlgoUtils.ENVIRONMENT.threads - DaemonPoolExecutor.INSTANCE.getActiveCount() / 2;
        this.divide(first, limit, threshold, availableWorkers);
    }

    protected abstract void conquer(int var1, int var2);

    final void divide(int first, int limit, int threshold, int workers) {
        int count = limit - first;
        if (count > threshold && workers > 1) {
            int split = first + count / 2;
            int nextWorkers = workers / 2;
            Future<?> firstPart = DaemonPoolExecutor.INSTANCE.submit(() -> this.divide(first, split, threshold, nextWorkers));
            Future<?> secondPart = DaemonPoolExecutor.INSTANCE.submit(() -> this.divide(split, limit, threshold, nextWorkers));
            try {
                firstPart.get();
                secondPart.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
                throw new ProgrammingError(exception);
            }
        } else {
            this.conquer(first, limit);
        }
    }
}

