/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ojalgo.ProgrammingError;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public class ColumnView<N extends Number>
implements Access1D<N>,
Iterable<ColumnView<N>>,
Iterator<ColumnView<N>>,
Spliterator<ColumnView<N>>,
Comparable<ColumnView<N>> {
    static final int CHARACTERISTICS = 21845;
    private long myColumn = -1L;
    private final Access2D<N> myDelegate2D;
    private final long myLastColumn;

    private ColumnView(Access2D<N> access, long column, long lastColumn) {
        this.myDelegate2D = access;
        this.myLastColumn = lastColumn;
        this.myColumn = column;
    }

    protected ColumnView(Access2D<N> access) {
        this(access, -1L, access.countColumns() - 1L);
    }

    @Override
    public int characteristics() {
        return 21845;
    }

    public long column() {
        return this.myColumn;
    }

    @Override
    public int compareTo(ColumnView<N> other) {
        return Long.compare(this.myColumn, other.column());
    }

    @Override
    public long count() {
        return this.myDelegate2D.countRows();
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate2D.doubleValue(index, this.myColumn);
    }

    @Override
    public long estimateSize() {
        return this.myLastColumn - this.myColumn;
    }

    @Override
    public void forEachRemaining(Consumer<? super ColumnView<N>> action) {
        Iterator.super.forEachRemaining(action);
    }

    @Override
    public N get(long index) {
        return this.myDelegate2D.get(index, this.myColumn);
    }

    @Override
    public boolean hasNext() {
        return this.myColumn < this.myLastColumn;
    }

    public boolean hasPrevious() {
        return this.myColumn > 0L;
    }

    @Override
    public ColumnView<N> iterator() {
        return new ColumnView<N>(this.myDelegate2D);
    }

    @Override
    public ColumnView<N> next() {
        ++this.myColumn;
        return this;
    }

    public ColumnView<N> previous() {
        --this.myColumn;
        return this;
    }

    @Override
    public final void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    public Stream<ColumnView<N>> stream(boolean parallel) {
        return StreamSupport.stream(this, parallel);
    }

    @Override
    public boolean tryAdvance(Consumer<? super ColumnView<N>> action) {
        if (this.hasNext()) {
            action.accept((ColumnView<N>)this.next());
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<ColumnView<N>> trySplit() {
        long remaining = this.myLastColumn - this.myColumn;
        if (remaining > 1L) {
            long split = this.myColumn + remaining / 2L;
            ColumnView<N> retVal = new ColumnView<N>(this.myDelegate2D, this.myColumn, split);
            this.myColumn = split;
            return retVal;
        }
        return null;
    }

    protected void setColumn(long column) {
        this.myColumn = column;
    }
}

