/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.shortestpath;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.planit.algorithms.shortestpath.OneToAllShortestPathAlgorithm;
import org.planit.algorithms.shortestpath.ShortestPathResult;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.misc.Pair;

public class DijkstraShortestPathAlgorithm
implements OneToAllShortestPathAlgorithm {
    protected Vertex currentOrigin = null;
    protected final double[] edgeSegmentCosts;
    protected final int numberOfEdgeSegments;
    protected final int numberOfVertices;
    protected static final Comparator<Pair<DirectedVertex, Double>> pairSecondComparator = Comparator.comparing(Pair::second, (f1, f2) -> f1.compareTo((Double)f2));

    public DijkstraShortestPathAlgorithm(double[] edgeSegmentCosts, int numberOfEdgeSegments, int numberOfVertices) {
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numberOfVertices = numberOfVertices;
        this.numberOfEdgeSegments = numberOfEdgeSegments;
    }

    @Override
    public ShortestPathResult executeOneToAll(DirectedVertex currentOrigin) throws PlanItException {
        boolean[] vertexVisited = new boolean[this.numberOfVertices];
        this.currentOrigin = currentOrigin;
        double[] vertexMeasuredCost = new double[this.numberOfVertices];
        Arrays.fill(vertexMeasuredCost, Double.POSITIVE_INFINITY);
        vertexMeasuredCost[(int)currentOrigin.getId()] = 0.0;
        Object[] incomingEdgeSegment = new EdgeSegment[this.numberOfVertices];
        Arrays.fill(incomingEdgeSegment, null);
        PriorityQueue<Pair<DirectedVertex, Double>> openVertices = new PriorityQueue<Pair<DirectedVertex, Double>>(this.numberOfVertices, pairSecondComparator);
        openVertices.add(Pair.create(currentOrigin, 0.0));
        while (!openVertices.isEmpty()) {
            Pair<DirectedVertex, Double> cheapestNextVertex = openVertices.poll();
            DirectedVertex currentVertex = cheapestNextVertex.first();
            int currentVertexId = (int)currentVertex.getId();
            double currentCost = cheapestNextVertex.second();
            if (vertexVisited[currentVertexId]) continue;
            vertexVisited[currentVertexId] = true;
            for (EdgeSegment adjacentEdgeSegment : currentVertex.getExitEdgeSegments()) {
                double computedCostToReachAdjacentVertex;
                double adjacentVertexCost;
                DirectedVertex adjacentVertex;
                int adjacentVertexId;
                double currentEdgeSegmentCost = this.edgeSegmentCosts[(int)adjacentEdgeSegment.getId()];
                if (!(currentEdgeSegmentCost < Double.POSITIVE_INFINITY) || vertexVisited[adjacentVertexId = (int)(adjacentVertex = adjacentEdgeSegment.getDownstreamVertex()).getId()] || !((adjacentVertexCost = vertexMeasuredCost[adjacentVertexId]) > (computedCostToReachAdjacentVertex = currentCost + currentEdgeSegmentCost))) continue;
                vertexMeasuredCost[adjacentVertexId] = computedCostToReachAdjacentVertex;
                incomingEdgeSegment[adjacentVertexId] = adjacentEdgeSegment;
                openVertices.add(Pair.create(adjacentVertex, computedCostToReachAdjacentVertex));
            }
        }
        return new ShortestPathResult(vertexMeasuredCost, (EdgeSegment[])incomingEdgeSegment);
    }
}

