/*
 * Decompiled with CFR 0.152.
 */
package org.planit.cost.physical.initial;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;

public class InitialLinkSegmentCost
extends InitialPhysicalCost {
    private static final Logger LOGGER = Logger.getLogger(InitialLinkSegmentCost.class.getCanonicalName());
    private static final long serialVersionUID = 2164407379859550420L;
    protected Map<Long, Map<Long, Double>> costPerModeAndLinkSegment = new HashMap<Long, Map<Long, Double>>();

    public InitialLinkSegmentCost(IdGroupingToken groupId) {
        super(groupId);
    }

    public boolean isSegmentCostsSetForMode(Mode mode) {
        return this.costPerModeAndLinkSegment.containsKey(mode.getId());
    }

    @Override
    public double getSegmentCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        Map<Long, Double> costPerLinkSegment = this.costPerModeAndLinkSegment.get(mode.getId());
        Double initialCost = costPerLinkSegment.get(linkSegment.getId());
        if (initialCost == null) {
            if (!linkSegment.isModeAllowed(mode)) {
                initialCost = Double.POSITIVE_INFINITY;
            } else {
                initialCost = linkSegment.computeFreeFlowTravelTime(mode);
                LOGGER.warning(String.format("initial cost missing for link segment %s (id:%d), reverting to free flow travel time %.2f(h)", linkSegment.getExternalId(), linkSegment.getId(), initialCost));
            }
        }
        return initialCost;
    }

    @Override
    public void setSegmentCost(Mode mode, MacroscopicLinkSegment linkSegment, double cost) {
        if (!this.costPerModeAndLinkSegment.containsKey(mode.getId())) {
            this.costPerModeAndLinkSegment.put(mode.getId(), new HashMap());
        }
        this.costPerModeAndLinkSegment.get(mode.getId()).put(linkSegment.getId(), cost);
    }

    public void setSegmentCost(Mode mode, long linkSegmentId, double cost) {
        if (!this.costPerModeAndLinkSegment.containsKey(mode.getId())) {
            this.costPerModeAndLinkSegment.put(mode.getId(), new HashMap());
        }
        this.costPerModeAndLinkSegment.get(mode.getId()).put(this.id, cost);
    }

    @Override
    public long getId() {
        return this.id;
    }
}

