/*
 * Decompiled with CFR 0.152.
 */
package org.planit.demands;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignmentComponent;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.time.TimePeriod;
import org.planit.userclass.TravelerType;
import org.planit.userclass.UserClass;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;

public class Demands
extends TrafficAssignmentComponent<Demands>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Demands.class.getCanonicalName());
    private static final long serialVersionUID = 144798248371260732L;
    protected final TreeMap<Long, TreeMap<Mode, ODDemandMatrix>> odDemands;
    public final TimePeriods timePeriods = new TimePeriods();
    public final UserClasses userClasses = new UserClasses();
    public final TravelerTypes travelerTypes = new TravelerTypes();

    public Demands(IdGroupingToken groupId) {
        super(groupId, Demands.class);
        this.odDemands = new TreeMap();
    }

    public ODDemandMatrix registerODDemand(TimePeriod timePeriod, Mode mode, ODDemandMatrix odDemandMatrix) {
        if (!this.odDemands.containsKey(timePeriod.getId())) {
            this.odDemands.put(timePeriod.getId(), new TreeMap());
        }
        return this.odDemands.get(timePeriod.getId()).put(mode, odDemandMatrix);
    }

    public ODDemandMatrix get(Mode mode, TimePeriod timePeriod) {
        if (this.odDemands.containsKey(timePeriod.getId()) && this.odDemands.get(timePeriod.getId()).containsKey(mode)) {
            return this.odDemands.get(timePeriod.getId()).get(mode);
        }
        return null;
    }

    public Set<Mode> getRegisteredModesForTimePeriod(TimePeriod timePeriod) {
        if (this.odDemands.containsKey(timePeriod.getId())) {
            return this.odDemands.get(timePeriod.getId()).keySet();
        }
        return null;
    }

    public class TimePeriods
    implements Iterable<TimePeriod> {
        private final Map<Long, TimePeriod> timePeriodMap = new HashMap<Long, TimePeriod>();

        protected void registerTimePeriod(TimePeriod timePeriod) {
            this.timePeriodMap.put(timePeriod.getId(), timePeriod);
        }

        public TimePeriod createAndRegisterNewTimePeriod(String description, long startTimeSeconds, long durationSeconds) throws PlanItException {
            TimePeriod newTimePeriod = new TimePeriod(Demands.this.tokenId, description, startTimeSeconds, durationSeconds);
            this.registerTimePeriod(newTimePeriod);
            return newTimePeriod;
        }

        public TimePeriod getTimePeriodById(long id) {
            return this.timePeriodMap.get(id);
        }

        public int getNumberOfTimePeriods() {
            return this.timePeriodMap.size();
        }

        public TimePeriod getFirst() {
            return this.getTimePeriodById(0L);
        }

        public SortedSet<TimePeriod> asSortedSetByStartTime() {
            TreeSet<TimePeriod> timePeriodSet = new TreeSet<TimePeriod>(TimePeriod.comparatorByStartTime());
            timePeriodSet.addAll(this.timePeriodMap.values());
            return timePeriodSet;
        }

        @Override
        public Iterator<TimePeriod> iterator() {
            return this.timePeriodMap.values().iterator();
        }

        public TimePeriod getTimePeriodByXmlId(String xmlId) {
            for (TimePeriod timePeriod : Demands.this.timePeriods) {
                if (!xmlId.equals(timePeriod.getXmlId())) continue;
                return timePeriod;
            }
            return null;
        }
    }

    public class UserClasses
    implements Iterable<UserClass> {
        private final Map<Long, UserClass> userClassMap = new HashMap<Long, UserClass>();

        protected void registerUserClass(UserClass userClass) {
            this.userClassMap.put(userClass.getId(), userClass);
        }

        public UserClass createAndRegisterNewUserClass(String name, Mode mode, TravelerType travellerType) {
            UserClass newUserClass = new UserClass(Demands.this.tokenId, name, mode, travellerType);
            this.registerUserClass(newUserClass);
            return newUserClass;
        }

        public int size() {
            return this.userClassMap.size();
        }

        public UserClass get(long id) {
            return this.userClassMap.get(id);
        }

        public UserClass getFirst() {
            return this.get(0L);
        }

        @Override
        public Iterator<UserClass> iterator() {
            return this.userClassMap.values().iterator();
        }

        public UserClass getUserClassByXmlId(String xmlId) {
            for (UserClass userClass : Demands.this.userClasses) {
                if (!xmlId.equals(userClass.getXmlId())) continue;
                return userClass;
            }
            return null;
        }
    }

    public class TravelerTypes
    implements Iterable<TravelerType> {
        private final Map<Long, TravelerType> travelerTypeMap = new HashMap<Long, TravelerType>();

        protected void registerTravelerType(TravelerType travelerType) {
            this.travelerTypeMap.put(travelerType.getId(), travelerType);
        }

        public TravelerType createAndRegisterNewTravelerType(String name) {
            TravelerType newTravelerType = new TravelerType(Demands.this.tokenId, name);
            this.registerTravelerType(newTravelerType);
            return newTravelerType;
        }

        public TravelerType getTravelerTypeById(long id) {
            return this.travelerTypeMap.get(id);
        }

        public TravelerType getFirst() {
            return this.getTravelerTypeById(0L);
        }

        @Override
        public Iterator<TravelerType> iterator() {
            return this.travelerTypeMap.values().iterator();
        }

        public TravelerType getTravelerTypeByXmlId(String xmlId) {
            for (TravelerType travelerType : Demands.this.travelerTypes) {
                if (!xmlId.equals(travelerType.getExternalId())) continue;
                return travelerType;
            }
            return null;
        }

        public int getNumberOfTravelerTypes() {
            return this.travelerTypeMap.size();
        }
    }
}

