/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.planit.graph.DirectedGraphBuilder;
import org.planit.graph.EdgeSegmentsImpl;
import org.planit.graph.GraphImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedGraph;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.EdgeSegments;
import org.planit.utils.id.IdGroupingToken;

public class DirectedGraphImpl<V extends DirectedVertex, E extends DirectedEdge, ES extends EdgeSegment>
extends GraphImpl<V, E>
implements DirectedGraph<V, E, ES> {
    private static final Logger LOGGER = Logger.getLogger(DirectedGraphImpl.class.getCanonicalName());
    protected final EdgeSegments<ES> edgeSegments;

    public DirectedGraphImpl(IdGroupingToken groupToken, DirectedGraphBuilder<V, E, ES> graphBuilder) {
        super(groupToken, graphBuilder);
        this.edgeSegments = new EdgeSegmentsImpl<ES>(graphBuilder);
    }

    @Override
    public EdgeSegments<ES> getEdgeSegments() {
        return this.edgeSegments;
    }

    @Override
    public void removeSubGraph(Set<? extends V> subNetworkToRemove, boolean recreateIds) {
        for (DirectedVertex directedVertex : subNetworkToRemove) {
            HashSet<EdgeSegment> entryEdgeSegments = new HashSet<EdgeSegment>(directedVertex.getEntryEdgeSegments());
            HashSet<EdgeSegment> exitEdgeSegments = new HashSet<EdgeSegment>(directedVertex.getExitEdgeSegments());
            entryEdgeSegments.forEach(edgeSegment -> this.getEdgeSegments().remove((EdgeSegment)edgeSegment));
            exitEdgeSegments.forEach(edgeSegment -> this.getEdgeSegments().remove((EdgeSegment)edgeSegment));
            entryEdgeSegments.forEach(edgeSegment -> edgeSegment.remove(directedVertex));
            exitEdgeSegments.forEach(edgeSegment -> edgeSegment.remove(directedVertex));
            entryEdgeSegments.forEach(edgeSegment -> edgeSegment.removeParentEdge());
            exitEdgeSegments.forEach(edgeSegment -> edgeSegment.removeParentEdge());
            entryEdgeSegments.forEach(edgeSegment -> directedVertex.removeEdgeSegment((EdgeSegment)edgeSegment));
            exitEdgeSegments.forEach(edgeSegment -> directedVertex.removeEdgeSegment((EdgeSegment)edgeSegment));
        }
        super.removeSubGraph(subNetworkToRemove, recreateIds);
    }

    @Override
    public void recreateIds() {
        super.recreateIds();
        if (this.graphBuilder instanceof DirectedGraphBuilder) {
            ((DirectedGraphBuilder)this.graphBuilder).recreateIds(this.getEdgeSegments());
        } else {
            LOGGER.severe("expected the EdgeSegments implementation to be compatible with directed graph builder, this is not the case: unable to correctly remove subnetwork and update ids");
        }
    }

    @Override
    public Map<Long, Set<E>> breakEdgesAt(List<? extends E> edgesToBreak, V vertexToBreakAt) throws PlanItException {
        Map<Long, Set<E>> brokenEdgesByOriginalEdgeId = super.breakEdgesAt(edgesToBreak, vertexToBreakAt);
        HashSet<EdgeSegment> identifiedEdgeSegmentOnEdge = new HashSet<EdgeSegment>();
        for (Map.Entry<Long, Set<E>> entry : brokenEdgesByOriginalEdgeId.entrySet()) {
            for (DirectedEdge brokenEdge : entry.getValue()) {
                if (brokenEdge.hasEdgeSegmentAb()) {
                    EdgeSegment edgeSegmentAb = brokenEdge.getEdgeSegmentAb();
                    if (identifiedEdgeSegmentOnEdge.contains(edgeSegmentAb)) {
                        edgeSegmentAb = this.edgeSegments.registerUniqueCopyOf(edgeSegmentAb, brokenEdge);
                    } else {
                        identifiedEdgeSegmentOnEdge.add(edgeSegmentAb);
                    }
                    brokenEdge.replace(brokenEdge.getEdgeSegmentAb(), edgeSegmentAb);
                    edgeSegmentAb.setParentEdge(brokenEdge);
                    edgeSegmentAb.setUpstreamVertex((DirectedVertex)brokenEdge.getVertexA());
                    edgeSegmentAb.setDownstreamVertex((DirectedVertex)brokenEdge.getVertexB());
                    edgeSegmentAb.getUpstreamVertex().replace(brokenEdge.getEdgeSegmentAb(), edgeSegmentAb, true);
                    edgeSegmentAb.getDownstreamVertex().replace(brokenEdge.getEdgeSegmentAb(), edgeSegmentAb, true);
                }
                if (!brokenEdge.hasEdgeSegmentBa()) continue;
                EdgeSegment edgeSegmentBa = brokenEdge.getEdgeSegmentBa();
                if (identifiedEdgeSegmentOnEdge.contains(edgeSegmentBa)) {
                    edgeSegmentBa = this.edgeSegments.registerUniqueCopyOf(edgeSegmentBa, brokenEdge);
                } else {
                    identifiedEdgeSegmentOnEdge.add(edgeSegmentBa);
                }
                brokenEdge.replace(brokenEdge.getEdgeSegmentBa(), edgeSegmentBa);
                edgeSegmentBa.setParentEdge(brokenEdge);
                edgeSegmentBa.setUpstreamVertex((DirectedVertex)brokenEdge.getVertexB());
                edgeSegmentBa.setDownstreamVertex((DirectedVertex)brokenEdge.getVertexA());
                edgeSegmentBa.getUpstreamVertex().replace(brokenEdge.getEdgeSegmentBa(), edgeSegmentBa, true);
                edgeSegmentBa.getDownstreamVertex().replace(brokenEdge.getEdgeSegmentBa(), edgeSegmentBa, true);
            }
        }
        return brokenEdgesByOriginalEdgeId;
    }
}

