/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.locationtech.jts.geom.LineString;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class EdgeImpl
implements Edge,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger(EdgeImpl.class.getCanonicalName());
    private static final long serialVersionUID = -3061186642253968991L;
    private long id;
    private Vertex vertexA = null;
    private Vertex vertexB = null;
    protected String externalId;
    protected String xmlId;
    protected LineString lineGeometry;
    protected Map<String, Object> inputProperties = null;
    protected String name = "";
    protected double lengthInKm;

    protected static long generateEdgeId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Edge.class);
    }

    protected void setId(long id) {
        this.id = id;
    }

    protected void setVertexB(Vertex vertexB) {
        this.vertexB = vertexB;
    }

    protected void setVertexA(Vertex vertexA) {
        this.vertexA = vertexA;
    }

    protected EdgeImpl(IdGroupingToken groupId, Vertex vertexA, Vertex vertexB, double lengthKm) throws PlanItException {
        this.setId(EdgeImpl.generateEdgeId(groupId));
        this.setVertexA(vertexA);
        this.setVertexB(vertexB);
        this.setLengthKm(lengthKm);
        this.setGeometry(null);
    }

    protected EdgeImpl(EdgeImpl edgeImpl) {
        this.setId(edgeImpl.getId());
        this.setXmlId(edgeImpl.getXmlId());
        this.setExternalId(edgeImpl.getExternalId());
        if (edgeImpl.hasGeometry()) {
            this.setGeometry((LineString)edgeImpl.getGeometry().clone());
        }
        this.setVertexA(edgeImpl.getVertexA());
        this.setVertexB(edgeImpl.getVertexB());
        this.setLengthKm(edgeImpl.getLengthKm());
        this.setName(this.getName() != null ? edgeImpl.getName() : "");
        this.inputProperties = null;
    }

    public int hashCode() {
        return this.idHashCode();
    }

    public boolean equals(Object obj) {
        return this.idEquals(obj);
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    @Override
    public boolean hasExternalId() {
        return this.externalId != null;
    }

    @Override
    public LineString getGeometry() {
        return this.lineGeometry;
    }

    @Override
    public void setGeometry(LineString lineString) {
        this.lineGeometry = lineString;
    }

    @Override
    public boolean removeVertex(Vertex vertex) {
        if (vertex != null) {
            if (this.getVertexA() != null && this.getVertexA().getId() == vertex.getId()) {
                return this.removeVertexA();
            }
            if (this.getVertexB() != null && this.getVertexB().getId() == vertex.getId()) {
                return this.removeVertexB();
            }
        }
        return false;
    }

    public boolean removeVertexB() {
        this.setVertexB(null);
        return true;
    }

    public boolean removeVertexA() {
        this.setVertexA(null);
        return true;
    }

    @Override
    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    @Override
    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    @Override
    public double getLengthKm() {
        return this.lengthInKm;
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        this.lengthInKm = lengthInKm;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Vertex getVertexA() {
        return this.vertexA;
    }

    @Override
    public Vertex getVertexB() {
        return this.vertexB;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean replace(Vertex vertexToReplace, Vertex vertexToReplaceWith) throws PlanItException {
        boolean vertexReplaced = false;
        if (vertexToReplaceWith != null) {
            if (this.getVertexA() != null && vertexToReplace.getId() == this.getVertexA().getId()) {
                this.removeVertex(vertexToReplace);
                this.setVertexA(vertexToReplaceWith);
                vertexReplaced = true;
            } else if (this.getVertexB() != null && vertexToReplace.getId() == this.getVertexB().getId()) {
                this.removeVertex(vertexToReplace);
                this.setVertexB(vertexToReplaceWith);
                vertexReplaced = true;
            }
        }
        return vertexReplaced;
    }

    @Override
    public EdgeImpl clone() {
        return new EdgeImpl(this);
    }

    @Override
    public boolean validate() {
        if (this.getVertexA() == null) {
            LOGGER.warning(String.format("vertex A missing on edge (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexB() == null) {
            LOGGER.warning(String.format("vertex B missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexA().getEdges(this.getVertexB()) == null || !this.getVertexA().getEdges(this.getVertexB()).contains(this)) {
            LOGGER.warning(String.format("edge (id:%d externalId:%s) not registered on vertex A", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexB().getEdges(this.getVertexA()) == null || !this.getVertexB().getEdges(this.getVertexA()).contains(this)) {
            LOGGER.warning(String.format("edge (id:%d externalId:%s) not registered on vertex B", this.getId(), this.getExternalId()));
            return false;
        }
        return true;
    }
}

