/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.logging.Logger;
import org.planit.graph.DirectedVertexImpl;
import org.planit.graph.EdgeImpl;
import org.planit.graph.EdgesImpl;
import org.planit.graph.GraphBuilder;
import org.planit.graph.VertexImpl;
import org.planit.graph.VerticesImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class GraphBuilderImpl
implements GraphBuilder<Vertex, Edge> {
    private static final Logger LOGGER = Logger.getLogger(GraphBuilderImpl.class.getCanonicalName());
    protected IdGroupingToken groupIdToken;

    public GraphBuilderImpl(IdGroupingToken groupIdToken) {
        this.groupIdToken = groupIdToken;
    }

    @Override
    public Vertex createVertex() {
        return new DirectedVertexImpl(this.getIdGroupingToken());
    }

    @Override
    public Edge createEdge(Vertex vertexA, Vertex vertexB, double length) throws PlanItException {
        return new EdgeImpl(this.getIdGroupingToken(), vertexA, vertexB, length);
    }

    @Override
    public void setIdGroupingToken(IdGroupingToken groupIdToken) {
        this.groupIdToken = groupIdToken;
    }

    @Override
    public IdGroupingToken getIdGroupingToken() {
        return this.groupIdToken;
    }

    @Override
    public void recreateIds(Edges<? extends Edge> edges) {
        if (edges instanceof EdgesImpl) {
            IdGenerator.reset(this.getIdGroupingToken(), Edge.class);
            for (Edge edge : edges) {
                if (edge instanceof EdgeImpl) {
                    ((EdgeImpl)edge).setId(EdgeImpl.generateEdgeId(this.getIdGroupingToken()));
                    continue;
                }
                LOGGER.severe(String.format("attempting to reset id on edge (%s) that is not compatible with the edge implementation generated by this builder, ignored", edge.getClass().getCanonicalName()));
            }
            ((EdgesImpl)edges).updateIdMapping();
        } else {
            LOGGER.severe("expected the Edges implementation to be compatible with graph builder, this is not the case: unable to correctly remove subnetwork and update ids");
        }
    }

    @Override
    public void recreateIds(Vertices<? extends Vertex> vertices) {
        if (vertices instanceof VerticesImpl) {
            IdGenerator.reset(this.getIdGroupingToken(), Vertex.class);
            for (Vertex vertex : vertices) {
                if (vertex instanceof VertexImpl) {
                    ((VertexImpl)vertex).setId(VertexImpl.generateVertexId(this.getIdGroupingToken()));
                    continue;
                }
                LOGGER.severe(String.format("attempting to reset id on vertex (%s) that is not compatible with the edge implementation generated by this builder, ignored", vertex.getClass().getCanonicalName()));
            }
            ((VerticesImpl)vertices).updateIdMapping();
        } else {
            LOGGER.severe("expected the Vertices implementation to be compatible with graph builder, this is not the case: unable to correctly remove subnetwork and update ids");
        }
    }

    @Override
    public Edge createUniqueCopyOf(Edge edgeToCopy) {
        if (edgeToCopy instanceof EdgeImpl) {
            EdgeImpl copy = (EdgeImpl)edgeToCopy.clone();
            copy.setId(EdgeImpl.generateEdgeId(this.getIdGroupingToken()));
            return copy;
        }
        LOGGER.severe("passed in edge is not an instance created by this builder, incompatible for creating a copy");
        return null;
    }
}

