/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.planit.graph.EdgesImpl;
import org.planit.graph.GraphBuilder;
import org.planit.graph.GraphModifier;
import org.planit.graph.VerticesImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Graph;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class GraphImpl<V extends Vertex, E extends Edge>
implements Graph<V, E>,
GraphModifier<V, E> {
    private static final Logger LOGGER = Logger.getLogger(GraphImpl.class.getCanonicalName());
    private final long id;
    protected final GraphBuilder<V, E> graphBuilder;
    protected final Edges<E> edges;
    protected final Vertices<V> vertices;

    protected Set<V> processSubNetworkVertex(V referenceVertex) throws PlanItException {
        PlanItException.throwIfNull(referenceVertex, "provided reference vertex is null when identifying its subnetwork, thisis not allowed");
        HashSet<Object> subNetworkVertices = new HashSet<Object>();
        subNetworkVertices.add(referenceVertex);
        HashSet<Object> verticesToExplore = new HashSet<Object>();
        verticesToExplore.add(referenceVertex);
        Iterator vertexIter = verticesToExplore.iterator();
        while (vertexIter.hasNext()) {
            Vertex currVertex = (Vertex)vertexIter.next();
            vertexIter.remove();
            Collection<? extends Edge> edgesOfCurrVertex = currVertex.getEdges();
            for (Edge edge : edgesOfCurrVertex) {
                if (edge.getVertexA() != null && edge.getVertexA().getId() != currVertex.getId() && !subNetworkVertices.contains(edge.getVertexA())) {
                    subNetworkVertices.add(edge.getVertexA());
                    verticesToExplore.add(edge.getVertexA());
                    continue;
                }
                if (edge.getVertexB() == null || edge.getVertexB().getId() == currVertex.getId() || subNetworkVertices.contains(edge.getVertexB())) continue;
                subNetworkVertices.add(edge.getVertexB());
                verticesToExplore.add(edge.getVertexB());
            }
            vertexIter = verticesToExplore.iterator();
        }
        return subNetworkVertices;
    }

    public GraphImpl(IdGroupingToken groupId, GraphBuilder<V, E> graphBuilder) {
        this.id = IdGenerator.generateId(groupId, GraphImpl.class);
        this.graphBuilder = graphBuilder;
        this.edges = new EdgesImpl<V, E>(graphBuilder);
        this.vertices = new VerticesImpl<V>(graphBuilder);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Vertices<V> getVertices() {
        return this.vertices;
    }

    @Override
    public Edges<E> getEdges() {
        return this.edges;
    }

    public IdGroupingToken getGraphIdGroupingToken() {
        return this.graphBuilder.getIdGroupingToken();
    }

    @Override
    public void removeDanglingSubGraphs(Integer belowsize, Integer abovesize, boolean alwaysKeepLargest) throws PlanItException {
        boolean recreateIdsImmediately = false;
        HashMap<Integer, LongAdder> removedDanglingNetworksBySize = new HashMap<Integer, LongAdder>();
        HashSet remainingVertices = new HashSet(this.getVertices().size());
        this.getVertices().forEach(vertex -> remainingVertices.add(vertex));
        HashMap<Vertex, Integer> identifiedSubNetworkSizes = new HashMap<Vertex, Integer>();
        while (remainingVertices.iterator().hasNext()) {
            Vertex referenceVertex = (Vertex)remainingVertices.iterator().next();
            Set<Vertex> subNetworkVerticesToPopulate = this.processSubNetworkVertex(referenceVertex);
            identifiedSubNetworkSizes.put(referenceVertex, subNetworkVerticesToPopulate.size());
            remainingVertices.removeAll(subNetworkVerticesToPopulate);
        }
        if (!identifiedSubNetworkSizes.isEmpty()) {
            int maxSubNetworkSize = (Integer)Collections.max(identifiedSubNetworkSizes.values());
            LOGGER.fine(String.format("remaining vertices %d, edges %d", this.getVertices().size(), this.getEdges().size()));
            for (Map.Entry entry : identifiedSubNetworkSizes.entrySet()) {
                int subNetworkSize = (Integer)entry.getValue();
                if (subNetworkSize >= maxSubNetworkSize && alwaysKeepLargest || subNetworkSize >= belowsize && subNetworkSize <= abovesize) continue;
                this.removeSubGraphOf((Vertex)entry.getKey(), recreateIdsImmediately);
                removedDanglingNetworksBySize.putIfAbsent(subNetworkSize, new LongAdder());
                ((LongAdder)removedDanglingNetworksBySize.get(subNetworkSize)).increment();
                LOGGER.fine(String.format("removing %d vertices from graph", subNetworkSize));
                LOGGER.fine(String.format("remaining vertices %d, edges %d", this.getVertices().size(), this.getEdges().size()));
            }
            LongAdder totalCount = new LongAdder();
            removedDanglingNetworksBySize.forEach((size, count) -> {
                LOGGER.fine(String.format("sub graph size %d - %d removed", size, count.longValue()));
                totalCount.add(count.longValue());
            });
            LOGGER.fine(String.format("removed %d dangling sub graphs", totalCount.longValue()));
        } else {
            LOGGER.warning("no networks identified, unable to remove dangling subnetworks");
        }
        if (!recreateIdsImmediately) {
            this.recreateIds();
        }
    }

    @Override
    public void removeSubGraph(Set<? extends V> subGraphToRemove, boolean recreateIds) {
        for (Vertex vertex : subGraphToRemove) {
            HashSet<? extends Edge> vertexEdges = new HashSet<Edge>(vertex.getEdges());
            vertexEdges.forEach(edge -> vertex.removeEdge((Edge)edge));
            vertexEdges.forEach(edge -> edge.removeVertex(vertex));
            this.getVertices().remove(vertex);
            vertexEdges.forEach(edge -> this.getEdges().remove((Edge)edge));
        }
        if (recreateIds) {
            this.recreateIds();
        }
    }

    @Override
    public void removeSubGraphOf(V referenceVertex, boolean recreateIds) throws PlanItException {
        Set<V> subNetworkNodesToRemove = this.processSubNetworkVertex(referenceVertex);
        this.removeSubGraph(subNetworkNodesToRemove, recreateIds);
    }

    @Override
    public Map<Long, Set<E>> breakEdgesAt(List<? extends E> edgesToBreak, V vertexToBreakAt) throws PlanItException {
        HashMap<Long, Set<E>> affectedEdges = new HashMap<Long, Set<E>>();
        for (Edge edgeToBreak : edgesToBreak) {
            affectedEdges.putIfAbsent(edgeToBreak.getId(), new HashSet());
            Set affectedEdgesOfEdgeToBreak = (Set)affectedEdges.get(edgeToBreak.getId());
            Edge aToBreak = edgeToBreak;
            Edge breakToB = this.edges.registerUniqueCopyOf(edgeToBreak);
            if (edgeToBreak.getVertexA() == null || edgeToBreak.getVertexB() == null) {
                LOGGER.severe(String.format("unable to break edge since edge to break %s (id:%d) is missing one or more vertices", edgeToBreak.getExternalId(), edgeToBreak.getId()));
                continue;
            }
            Vertex oldVertexB = edgeToBreak.getVertexB();
            Vertex oldVertexA = edgeToBreak.getVertexA();
            aToBreak.replace(oldVertexB, (Vertex)vertexToBreakAt);
            breakToB.replace(oldVertexA, (Vertex)vertexToBreakAt);
            oldVertexB.replace(edgeToBreak, breakToB, true);
            oldVertexA.replace(edgeToBreak, aToBreak, true);
            vertexToBreakAt.addEdge(aToBreak);
            vertexToBreakAt.addEdge(breakToB);
            affectedEdgesOfEdgeToBreak.add(aToBreak);
            affectedEdgesOfEdgeToBreak.add(breakToB);
        }
        return affectedEdges;
    }

    @Override
    public void recreateIds() {
        this.graphBuilder.recreateIds(this.getEdges());
        this.graphBuilder.recreateIds(this.getVertices());
    }
}

