/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.planit.graph.GraphBuilder;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;

public class VerticesImpl<V extends Vertex>
implements Vertices<V> {
    private final GraphBuilder<V, ?> graphBuilder;
    private Map<Long, V> vertexMap;

    protected void updateIdMapping() {
        HashMap updatedMap = new HashMap(this.vertexMap.size());
        this.vertexMap.forEach((? super K oldId, ? super V vertex) -> updatedMap.put(vertex.getId(), vertex));
        this.vertexMap = updatedMap;
    }

    public VerticesImpl(GraphBuilder<V, ?> graphBuilder) {
        this.graphBuilder = graphBuilder;
        this.vertexMap = new TreeMap<Long, V>();
    }

    @Override
    public void remove(V vertex) {
        this.vertexMap.remove(vertex.getId());
    }

    @Override
    public void remove(long vertexId) {
        this.vertexMap.remove(vertexId);
    }

    @Override
    public V createNew() {
        return this.graphBuilder.createVertex();
    }

    @Override
    public V register(V vertex) {
        return (V)((Vertex)this.vertexMap.put(vertex.getId(), vertex));
    }

    @Override
    public Iterator<V> iterator() {
        return this.vertexMap.values().iterator();
    }

    @Override
    public V registerNew() {
        V newVertex = this.createNew();
        this.register(newVertex);
        return newVertex;
    }

    @Override
    public int size() {
        return this.vertexMap.size();
    }

    @Override
    public V get(long id) {
        return (V)((Vertex)this.vertexMap.get(id));
    }
}

