/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.demands;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.planit.demands.Demands;
import org.planit.io.demands.PlanitDemandsReaderSettings;
import org.planit.io.xml.util.PlanitXmlReader;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.time.TimePeriod;
import org.planit.userclass.TravelerType;
import org.planit.userclass.UserClass;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.mode.Mode;
import org.planit.utils.zoning.Zone;
import org.planit.utils.zoning.Zones;
import org.planit.xml.generated.Durationunit;
import org.planit.xml.generated.XMLElementDemandConfiguration;
import org.planit.xml.generated.XMLElementMacroscopicDemand;
import org.planit.xml.generated.XMLElementOdCellByCellMatrix;
import org.planit.xml.generated.XMLElementOdMatrix;
import org.planit.xml.generated.XMLElementOdRawMatrix;
import org.planit.xml.generated.XMLElementOdRowMatrix;
import org.planit.xml.generated.XMLElementTimePeriods;
import org.planit.xml.generated.XMLElementTravellerTypes;
import org.planit.xml.generated.XMLElementUserClasses;
import org.planit.zoning.Zoning;

public class PlanitDemandsReader
extends PlanitXmlReader<XMLElementMacroscopicDemand> {
    private static final Logger LOGGER = Logger.getLogger(PlanitDemandsReader.class.getCanonicalName());
    private static final List<String> RESERVED_CHARACTERS = Arrays.asList("+", "*", "^");
    protected final PlanitDemandsReaderSettings settings = new PlanitDemandsReaderSettings();
    protected Demands demands;

    private static XMLElementTravellerTypes.Travellertype generateDefaultXMLTravellerType() {
        XMLElementTravellerTypes.Travellertype xmlTravellerType = new XMLElementTravellerTypes.Travellertype();
        xmlTravellerType.setId("1");
        xmlTravellerType.setName("Default");
        return xmlTravellerType;
    }

    private static XMLElementUserClasses.Userclass generateDefaultUserClass() {
        XMLElementUserClasses.Userclass xmlUserclass = new XMLElementUserClasses.Userclass();
        xmlUserclass.setName("Default");
        xmlUserclass.setId("1");
        xmlUserclass.setModeref("1");
        xmlUserclass.setTravellertyperef("1");
        return xmlUserclass;
    }

    private static String escapeSeparator(String separator) {
        if (RESERVED_CHARACTERS.contains(separator)) {
            return "\\" + separator;
        }
        return separator;
    }

    private static void populateDemandMatrixRawForEqualSeparators(XMLElementOdRawMatrix.Values values, String separator, double pcu, ODDemandMatrix odDemandMatrix, Zones<?> zones) throws PlanItException {
        String[] allValuesAsString = values.getValue().split(separator);
        int size = allValuesAsString.length;
        int noRows = (int)Math.round(Math.sqrt(size));
        if (noRows * noRows != size) {
            throw new PlanItException("Element <odrawmatrix> contains a string of " + size + " values, which is not an exact square");
        }
        int noCols = noRows;
        for (int i = 0; i < noRows; ++i) {
            int rowOffset = i * noRows;
            Zone originZone = zones.get(i);
            for (int col = 0; col < noCols; ++col) {
                Zone destinationZone = zones.get(col);
                double rawDemand = Double.parseDouble(allValuesAsString[rowOffset + col]);
                double demand = rawDemand * pcu;
                odDemandMatrix.setValue(originZone, destinationZone, demand);
            }
        }
    }

    private static void populateDemandMatrixRawDifferentSeparators(XMLElementOdRawMatrix.Values values, String originSeparator, String destinationSeparator, double pcu, ODDemandMatrix odDemandMatrix, Zones zones) throws PlanItException {
        String[] originRows = values.getValue().split(originSeparator);
        int noRows = originRows.length;
        for (int i = 0; i < noRows; ++i) {
            Zone originZone = zones.get(i);
            String[] destinationValuesByOrigin = originRows[i].split(destinationSeparator);
            int noCols = destinationValuesByOrigin.length;
            if (noRows != noCols) {
                throw new PlanItException("Element <odrawmatrix> does not parse to a square matrix: Row " + (i + 1) + " has " + noCols + " values.");
            }
            for (int col = 0; col < noCols; ++col) {
                Zone destinationZone = zones.get(col);
                double rawDemand = Double.parseDouble(destinationValuesByOrigin[col]);
                double demand = rawDemand * pcu;
                odDemandMatrix.setValue(originZone, destinationZone, demand);
            }
        }
    }

    private void generateAndStoreTravelerTypes(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLElementTravellerTypes xmlTravellertypes;
        XMLElementTravellerTypes xMLElementTravellerTypes = xmlTravellertypes = demandconfiguration.getTravellertypes() == null ? new XMLElementTravellerTypes() : demandconfiguration.getTravellertypes();
        if (xmlTravellertypes.getTravellertype().isEmpty()) {
            xmlTravellertypes.getTravellertype().add(PlanitDemandsReader.generateDefaultXMLTravellerType());
        }
        for (XMLElementTravellerTypes.Travellertype xmlTravellertype : xmlTravellertypes.getTravellertype()) {
            TravelerType duplicateTravelerType;
            TravelerType travelerType = this.demands.travelerTypes.createAndRegisterNewTravelerType(xmlTravellertype.getName());
            if (xmlTravellertype.getId() != null && !xmlTravellertype.getId().isBlank()) {
                travelerType.setXmlId(xmlTravellertype.getId());
            }
            if (xmlTravellertype.getExternalid() != null && !xmlTravellertype.getExternalid().isBlank()) {
                travelerType.setExternalId(xmlTravellertype.getExternalid());
            }
            PlanItException.throwIf((duplicateTravelerType = this.settings.getMapToIndexTravelerTypeByXmlIds().put(travelerType.getXmlId(), travelerType)) != null, "duplicate traveler type xml id " + travelerType.getXmlId() + " found in demands");
        }
    }

    private int generateAndStoreUserClasses(XMLElementDemandConfiguration demandconfiguration, MacroscopicNetwork network, Map<String, Mode> sourceIdModeMap) throws PlanItException {
        XMLElementUserClasses xmlUserclasses;
        XMLElementUserClasses xMLElementUserClasses = xmlUserclasses = demandconfiguration.getUserclasses() == null ? new XMLElementUserClasses() : demandconfiguration.getUserclasses();
        if (xmlUserclasses.getUserclass().isEmpty()) {
            PlanItException.throwIf(network.modes.size() > 1, "user classes must be explicitly defined when more than one mode is defined");
            PlanItException.throwIf(this.demands.travelerTypes.getNumberOfTravelerTypes() > 1, "user classes must be explicitly defined when more than one traveller type is defined");
            XMLElementUserClasses.Userclass xmlUserClass = PlanitDemandsReader.generateDefaultUserClass();
            xmlUserClass.setTravellertyperef(this.demands.travelerTypes.getFirst().getXmlId());
            xmlUserclasses.getUserclass().add(xmlUserClass);
        }
        for (XMLElementUserClasses.Userclass xmlUserclass : xmlUserclasses.getUserclass()) {
            UserClass duplicateUserClass;
            String xmlModeIdRef;
            Mode userClassMode;
            if (xmlUserclass.getTravellertyperef() == null) {
                PlanItException.throwIf(this.demands.travelerTypes.getNumberOfTravelerTypes() > 1, String.format("User class %s has no traveller type specified, but more than one traveller type possible", xmlUserclass.getId()));
            } else {
                PlanItException.throwIf(this.settings.getMapToIndexTravelerTypeByXmlIds().get(xmlUserclass.getTravellertyperef()) == null, "travellertyperef value of " + xmlUserclass.getTravellertyperef() + " referenced by user class " + xmlUserclass.getName() + " but not defined");
            }
            PlanItException.throwIf(xmlUserclass.getModeref() == null, "User class " + xmlUserclass.getId() + " has no mode specified, but more than one mode possible");
            if (xmlUserclass.getModeref() == null) {
                PlanItException.throwIf(network.modes.size() > 1, "User class " + xmlUserclass.getId() + " has no mode specified, but more than one mode possible");
                xmlUserclass.setModeref(sourceIdModeMap.keySet().iterator().next());
            }
            PlanItException.throwIf((userClassMode = sourceIdModeMap.get(xmlModeIdRef = xmlUserclass.getModeref())) == null, "User class " + xmlUserclass.getId() + " refers to mode " + xmlModeIdRef + " which has not been defined");
            String travellerTypeXmlIdRef = xmlUserclass.getTravellertyperef() == null ? "1" : xmlUserclass.getTravellertyperef();
            xmlUserclass.setTravellertyperef(travellerTypeXmlIdRef);
            TravelerType travellerType = this.settings.getMapToIndexTravelerTypeByXmlIds().get(travellerTypeXmlIdRef);
            UserClass userClass = this.demands.userClasses.createAndRegisterNewUserClass(xmlUserclass.getName(), userClassMode, travellerType);
            if (xmlUserclass.getId() != null && !xmlUserclass.getId().isBlank()) {
                userClass.setXmlId(xmlUserclass.getId());
            }
            if (xmlUserclass.getExternalid() != null && !xmlUserclass.getExternalid().isBlank()) {
                userClass.setExternalId(xmlUserclass.getExternalid());
            }
            PlanItException.throwIf((duplicateUserClass = this.settings.getMapToIndexUserClassByXmlIds().put(userClass.getXmlId(), userClass)) != null, "duplicate user class xml id " + userClass.getXmlId() + " found in demands");
        }
        return xmlUserclasses.getUserclass().size();
    }

    private void generateTimePeriodMap(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLGregorianCalendar defaultStartTime;
        XMLElementTimePeriods xmlTimeperiods = demandconfiguration.getTimeperiods();
        try {
            LocalDateTime localDateTime = LocalDate.now().atStartOfDay();
            defaultStartTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(localDateTime.format(DateTimeFormatter.ISO_DATE_TIME));
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when generating time period map when processing demand configuration", e);
        }
        for (XMLElementTimePeriods.Timeperiod xmlTimePeriod : xmlTimeperiods.getTimeperiod()) {
            TimePeriod duplicateTimePeriod;
            XMLGregorianCalendar time = xmlTimePeriod.getStarttime() == null ? defaultStartTime : xmlTimePeriod.getStarttime();
            int startTimeSeconds = 3600 * time.getHour() + 60 * time.getMinute() + time.getSecond();
            int duration = xmlTimePeriod.getDuration().getValue().intValue();
            Durationunit durationUnit = xmlTimePeriod.getDuration().getUnit();
            if (xmlTimePeriod.getName() == null) {
                xmlTimePeriod.setName("");
            }
            switch (durationUnit) {
                case H: {
                    duration *= 3600;
                    break;
                }
                case M: {
                    duration *= 60;
                    break;
                }
            }
            TimePeriod timePeriod = this.demands.timePeriods.createAndRegisterNewTimePeriod(xmlTimePeriod.getName(), startTimeSeconds, duration);
            if (xmlTimePeriod.getId() != null && !xmlTimePeriod.getId().isBlank()) {
                timePeriod.setXmlId(xmlTimePeriod.getId());
            }
            if (xmlTimePeriod.getExternalid() != null && !xmlTimePeriod.getExternalid().isBlank()) {
                timePeriod.setExternalId(xmlTimePeriod.getExternalid());
            }
            PlanItException.throwIf((duplicateTimePeriod = this.settings.getMapToIndexTimePeriodByXmlIds().put(timePeriod.getXmlId(), timePeriod)) != null, "duplicate time period xml id " + timePeriod.getXmlId() + " found in demands");
        }
    }

    private static void populateDemandMatrix(XMLElementOdMatrix xmlOdMatrix, double pcu, ODDemandMatrix odDemandMatrix, Zones zones, Map<String, Zone> xmlIdZoneMap) throws PlanItException {
        if (xmlOdMatrix instanceof XMLElementOdCellByCellMatrix) {
            List<XMLElementOdCellByCellMatrix.O> o = ((XMLElementOdCellByCellMatrix)xmlOdMatrix).getO();
            for (XMLElementOdCellByCellMatrix.O xmlOriginZone : o) {
                Zone originZone = xmlIdZoneMap.get(xmlOriginZone.getRef());
                for (XMLElementOdCellByCellMatrix.O.D xmlDestinationZone : xmlOriginZone.getD()) {
                    Zone destinationZone = xmlIdZoneMap.get(xmlDestinationZone.getRef());
                    double demand = (double)xmlDestinationZone.getValue() * pcu;
                    odDemandMatrix.setValue(originZone, destinationZone, demand);
                }
            }
        } else if (xmlOdMatrix instanceof XMLElementOdRowMatrix) {
            XMLElementOdRowMatrix xmlOdRowMatrix = (XMLElementOdRowMatrix)xmlOdMatrix;
            String separator = xmlOdRowMatrix.getDs() == null ? "," : xmlOdRowMatrix.getDs();
            separator = PlanitDemandsReader.escapeSeparator(separator);
            List<XMLElementOdRowMatrix.Odrow> xmlOdRow = xmlOdRowMatrix.getOdrow();
            for (XMLElementOdRowMatrix.Odrow xmlOriginZone : xmlOdRow) {
                Zone originZone = xmlIdZoneMap.get(xmlOriginZone.getRef());
                String[] rowValuesAsString = xmlOriginZone.getValue().split(separator);
                for (int i = 0; i < rowValuesAsString.length; ++i) {
                    Zone destinationZone = zones.get(i);
                    double demand = Double.parseDouble(rowValuesAsString[i]) * pcu;
                    odDemandMatrix.setValue(originZone, destinationZone, demand);
                }
            }
        } else if (xmlOdMatrix instanceof XMLElementOdRawMatrix) {
            XMLElementOdRawMatrix.Values xmlValues = ((XMLElementOdRawMatrix)xmlOdMatrix).getValues();
            String originSeparator = xmlValues.getOs() == null ? "," : xmlValues.getOs();
            originSeparator = PlanitDemandsReader.escapeSeparator(originSeparator);
            String destinationSeparator = xmlValues.getDs() == null ? "," : xmlValues.getDs();
            if (originSeparator.equals(destinationSeparator = PlanitDemandsReader.escapeSeparator(destinationSeparator))) {
                PlanitDemandsReader.populateDemandMatrixRawForEqualSeparators(xmlValues, originSeparator, pcu, odDemandMatrix, zones);
            } else {
                PlanitDemandsReader.populateDemandMatrixRawDifferentSeparators(xmlValues, originSeparator, destinationSeparator, pcu, odDemandMatrix, zones);
            }
        }
    }

    protected void setDemands(Demands demands) {
        this.demands = demands;
    }

    protected void populateDemandConfiguration(MacroscopicNetwork network, Map<String, Mode> sourceIdModeMap) throws PlanItException {
        XMLElementDemandConfiguration demandconfiguration = ((XMLElementMacroscopicDemand)this.getXmlRootElement()).getDemandconfiguration();
        this.generateAndStoreTravelerTypes(demandconfiguration);
        this.generateAndStoreUserClasses(demandconfiguration, network, sourceIdModeMap);
        this.generateTimePeriodMap(demandconfiguration);
    }

    protected void populateDemandContents(Zoning zoning, Map<String, Zone> xmlIdZoneMap) throws PlanItException {
        List<XMLElementOdMatrix> oddemands = ((XMLElementMacroscopicDemand)this.getXmlRootElement()).getOddemands().getOdcellbycellmatrixOrOdrowmatrixOrOdrawmatrix();
        for (XMLElementOdMatrix xmlOdMatrix : oddemands) {
            UserClass userClass = null;
            if (xmlOdMatrix.getUserclassref() == null) {
                PlanItException.throwIf(this.demands.userClasses.size() > 1, "user class must be explicitly set on od matrix when more than one user class exists");
                userClass = this.demands.userClasses.getFirst();
            } else {
                String userClassXmlIdRef = xmlOdMatrix.getUserclassref();
                userClass = this.settings.getMapToIndexUserClassByXmlIds().get(userClassXmlIdRef);
            }
            PlanItException.throwIf(userClass == null, "referenced user class on od matrix not available");
            Mode mode = userClass.getMode();
            String timePeriodXmlIdRef = xmlOdMatrix.getTimeperiodref();
            PlanItException.throwIf(timePeriodXmlIdRef == null, "time period must always be referenced on od matrix");
            TimePeriod timePeriod = this.settings.getMapToIndexTimePeriodByXmlIds().get(timePeriodXmlIdRef);
            PlanItException.throwIf(timePeriod == null, "referenced time period on od matrix not available");
            ODDemandMatrix odDemandMatrix = new ODDemandMatrix(zoning.odZones);
            PlanitDemandsReader.populateDemandMatrix(xmlOdMatrix, mode.getPcu(), odDemandMatrix, zoning.odZones, xmlIdZoneMap);
            ODDemandMatrix duplicate = this.demands.registerODDemand(timePeriod, mode, odDemandMatrix);
            if (duplicate == null) continue;
            throw new PlanItException(String.format("multiple OD demand matrix encountered for mode-time period combination %s:%s this is not allowed", mode.getXmlId(), timePeriod.getXmlId()));
        }
    }

    public PlanitDemandsReader(String pathDirectory, String xmlFileExtension, Demands demands) throws PlanItException {
        super(XMLElementMacroscopicDemand.class, pathDirectory, xmlFileExtension);
        this.setDemands(demands);
    }

    public PlanitDemandsReader(XMLElementMacroscopicDemand xmlMacroscopicDemands, Demands demands) throws PlanItException {
        super(xmlMacroscopicDemands);
        this.setDemands(demands);
    }

    public void read(MacroscopicNetwork network, Zoning zoning, Map<String, Mode> xmlIdModeMap, Map<String, Zone> xmlIdZoneMap) throws PlanItException {
        try {
            this.initialiseAndParseXmlRootElement();
            this.populateDemandConfiguration(network, xmlIdModeMap);
            this.populateDemandContents(zoning, xmlIdZoneMap);
            this.clearXmlContent();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating demands in PLANitIO", e);
        }
    }

    public PlanitDemandsReaderSettings getSettings() {
        return this.settings;
    }
}

