/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.input;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.djutils.event.EventInterface;
import org.planit.assignment.TrafficAssignmentComponentFactory;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.io.demands.PlanitDemandsReader;
import org.planit.io.network.converter.PlanitNetworkReader;
import org.planit.io.network.converter.PlanitNetworkReaderFactory;
import org.planit.io.xml.util.JAXBUtils;
import org.planit.io.zoning.PlanitZoningReader;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.misc.FileUtils;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.xml.generated.XMLElementMacroscopicDemand;
import org.planit.xml.generated.XMLElementMacroscopicNetwork;
import org.planit.xml.generated.XMLElementMacroscopicZoning;
import org.planit.xml.generated.XMLElementPLANit;
import org.planit.zoning.Zoning;

public class PlanItInputBuilder
extends InputBuilderListener {
    private static final long serialVersionUID = -8928911341112445424L;
    private static final Logger LOGGER = Logger.getLogger(PlanItInputBuilder.class.getCanonicalName());
    private XMLElementMacroscopicDemand xmlRawDemand;
    private XMLElementMacroscopicZoning xmlRawZoning;
    private XMLElementMacroscopicNetwork xmlRawNetwork;
    private final String projectPath;
    private final String xmlFileExtension;
    private static final String DEFAULT_XML_FILE_EXTENSION = ".xml";
    private static final String ZONING_XSD_FILE = "src\\main\\resources\\xsd\\macroscopiczoninginput.xsd";
    private static final String DEMAND_XSD_FILE = "src\\main\\resources\\xsd\\macroscopicdemandinput.xsd";
    public static final String DEFAULT_SEPARATOR = ",";

    private void createGeneratedClassesFromXmlLocations(File zoningXmlFileLocation, File demandXmlFileLocation, File networkXmlFileLocation) throws PlanItException {
        try {
            this.xmlRawZoning = (XMLElementMacroscopicZoning)JAXBUtils.generateObjectFromXml(XMLElementMacroscopicZoning.class, zoningXmlFileLocation);
            this.xmlRawDemand = (XMLElementMacroscopicDemand)JAXBUtils.generateObjectFromXml(XMLElementMacroscopicDemand.class, demandXmlFileLocation);
            this.xmlRawNetwork = (XMLElementMacroscopicNetwork)JAXBUtils.generateObjectFromXml(XMLElementMacroscopicNetwork.class, networkXmlFileLocation);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error while generating classes from XML locations in PLANitIO", e);
        }
    }

    private void parseXmlRawInputs() throws PlanItException {
        File[] xmlFileNames = FileUtils.getFilesWithExtensionFromDir(this.projectPath, this.xmlFileExtension);
        boolean success = this.parseXmlRawInputsFromSingleFile(xmlFileNames);
        if (!success) {
            success = this.parseXmlRawInputSeparateFiles(xmlFileNames);
        }
        PlanItException.throwIf(!success, String.format("The directory %s does not contain either one file with all the macroscopic inputs or a separate file for each of zoning, demand and network", this.projectPath));
    }

    private boolean parseXmlRawInputsFromSingleFile(File[] xmlFileNames) {
        XMLElementPLANit xmlRawPLANitAll = JAXBUtils.generateInstanceFromXml(XMLElementPLANit.class, xmlFileNames);
        if (xmlRawPLANitAll != null) {
            this.xmlRawZoning = xmlRawPLANitAll.getMacroscopiczoning();
            this.xmlRawNetwork = xmlRawPLANitAll.getMacroscopicnetwork();
            this.xmlRawDemand = xmlRawPLANitAll.getMacroscopicdemand();
            return true;
        }
        return false;
    }

    private boolean parseXmlRawInputSeparateFiles(File[] xmlFileNames) {
        this.xmlRawZoning = JAXBUtils.generateInstanceFromXml(XMLElementMacroscopicZoning.class, xmlFileNames);
        this.xmlRawNetwork = JAXBUtils.generateInstanceFromXml(XMLElementMacroscopicNetwork.class, xmlFileNames);
        this.xmlRawDemand = JAXBUtils.generateInstanceFromXml(XMLElementMacroscopicDemand.class, xmlFileNames);
        return this.xmlRawZoning != null && this.xmlRawNetwork != null && this.xmlRawDemand != null;
    }

    private void setInputFilesSeparateFilesWithValidation(String projectPath, File[] xmlFileNames) throws PlanItException {
        boolean foundZoningFile = false;
        File zoningFileName = null;
        boolean foundNetworkFile = false;
        File networkFileName = null;
        boolean foundDemandFile = false;
        File demandFileName = null;
        for (int i = 0; i < xmlFileNames.length; ++i) {
            if (zoningFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], ZONING_XSD_FILE)) {
                zoningFileName = xmlFileNames[i];
            }
            if (networkFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], "src\\main\\resources\\xsd\\macroscopicnetworkinput.xsd")) {
                networkFileName = xmlFileNames[i];
            }
            if (demandFileName != null || !PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], DEMAND_XSD_FILE)) continue;
            demandFileName = xmlFileNames[i];
        }
        PlanItException.throwIf(zoningFileName == null, "Failed to find a valid zoning input file in the project directory " + projectPath);
        PlanItException.throwIf(networkFileName == null, "Failed to find a valid network input file in the project directory " + projectPath);
        PlanItException.throwIf(demandFileName == null, "Failed to find a valid demand input file in the project directory " + projectPath);
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + zoningFileName + " provides the zoning input data.");
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + networkFileName + " provides the network input data.");
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + demandFileName + " provides the demand input data.");
        this.createGeneratedClassesFromXmlLocations(zoningFileName, demandFileName, networkFileName);
    }

    private OutputProperty getInitialCostLinkIdentificationMethod(Set<String> headers) throws PlanItException {
        boolean linkSegmentXmlIdPresent = false;
        boolean linkSegmentExternalIdPresent = false;
        boolean upstreamNodeXmlIdPresent = false;
        boolean downstreamNodeXmlIdPresent = false;
        boolean modeXmlIdPresent = false;
        boolean costPresent = false;
        for (String header : headers) {
            OutputProperty outputProperty = OutputProperty.fromHeaderName(header);
            switch (outputProperty) {
                case LINK_SEGMENT_XML_ID: {
                    linkSegmentXmlIdPresent = true;
                    break;
                }
                case LINK_SEGMENT_EXTERNAL_ID: {
                    linkSegmentExternalIdPresent = true;
                    break;
                }
                case MODE_XML_ID: {
                    modeXmlIdPresent = true;
                    break;
                }
                case UPSTREAM_NODE_XML_ID: {
                    upstreamNodeXmlIdPresent = true;
                    break;
                }
                case DOWNSTREAM_NODE_XML_ID: {
                    downstreamNodeXmlIdPresent = true;
                    break;
                }
                case LINK_COST: {
                    costPresent = true;
                }
            }
        }
        PlanItException.throwIf(!costPresent, "Cost column not present in initial link segment costs file");
        PlanItException.throwIf(!modeXmlIdPresent, "Mode xml Id not present in initial link segment costs file");
        if (linkSegmentXmlIdPresent) {
            return OutputProperty.LINK_SEGMENT_XML_ID;
        }
        if (linkSegmentExternalIdPresent) {
            return OutputProperty.LINK_SEGMENT_EXTERNAL_ID;
        }
        if (upstreamNodeXmlIdPresent && downstreamNodeXmlIdPresent) {
            return OutputProperty.UPSTREAM_NODE_XML_ID;
        }
        throw new PlanItException("Links not correctly identified in initial link segment costs file");
    }

    private void setInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost, CSVRecord record, MacroscopicLinkSegment linkSegment) throws PlanItException {
        String modeXmlId = record.get("Mode Xml Id");
        Mode mode = this.getModeBySourceId(modeXmlId);
        PlanItException.throwIf(mode == null, "mode xml id not available in configuration");
        double cost = Double.parseDouble(record.get("Cost"));
        initialLinkSegmentCost.setSegmentCost(mode, linkSegment, cost);
    }

    protected void populateMacroscopicNetwork(MacroscopicNetwork network) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating network");
        if (this.xmlRawNetwork == null) {
            this.parseXmlRawInputs();
        }
        PlanitNetworkReader reader = PlanitNetworkReaderFactory.createReader(this.xmlRawNetwork, network);
        reader.getSettings().setMapToIndexLinkSegmentByXmlIds(this.sourceIdLinkSegmentMap);
        reader.getSettings().setMapToIndexLinkSegmentTypeByXmlIds(this.sourceIdLinkSegmentTypeMap);
        reader.getSettings().setMapToIndexModeByXmlIds(this.sourceIdModeMap);
        reader.getSettings().setMapToIndexNodeByXmlIds(this.sourceIdNodeMap);
        network = (MacroscopicNetwork)reader.read();
    }

    protected void populateZoning(Zoning zoning, MacroscopicNetwork network) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Zoning");
        PlanitZoningReader zoningReader = new PlanitZoningReader(this.xmlRawZoning, zoning);
        zoningReader.getSettings().setMapToIndexZoneByXmlIds(this.sourceIdZoneMap);
        zoningReader.getSettings().setMapToIndexConnectoidsByXmlIds(this.sourceIdConnectoidMap);
        zoningReader.read(network, this.sourceIdNodeMap, this.sourceIdLinkSegmentMap);
    }

    protected void populateDemands(Demands demands, Object parameter1, Object parameter2) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Demands");
        PlanItException.throwIf(!(parameter1 instanceof Zoning), "Parameter 1 of call to populateDemands() is not of class Zoning");
        PlanItException.throwIf(!(parameter2 instanceof MacroscopicNetwork), "Parameter 2 of call to populateDemands() is not of class MacroscopicNetwork");
        Zoning zoning = (Zoning)parameter1;
        MacroscopicNetwork network = (MacroscopicNetwork)parameter2;
        PlanitDemandsReader demandsReader = new PlanitDemandsReader(this.xmlRawDemand, demands);
        demandsReader.getSettings().setMapToIndexTravelerTypeByXmlIds(this.sourceIdTravelerTypeMap);
        demandsReader.getSettings().setMapToIndexUserClassByXmlIds(this.sourceIdUserClassMap);
        demandsReader.getSettings().setMapToIndexTimePeriodByXmlIds(this.sourceIdTimePeriodMap);
        demandsReader.read(network, zoning, this.sourceIdModeMap, this.sourceIdZoneMap);
    }

    protected void populateInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost, Object parameter1, Object parameter2) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Initial Link Segment Costs");
        PlanItException.throwIf(!(parameter1 instanceof MacroscopicNetwork), "Parameter 1 of call to populateInitialLinkSegments() is not of class MacroscopicNetwork");
        PlanItException.throwIf(!(parameter2 instanceof String), "Parameter 2 of call to populateInitialLinkSegments() is not a file name");
        MacroscopicNetwork network = (MacroscopicNetwork)parameter1;
        String fileName = (String)parameter2;
        try {
            FileReader in = new FileReader(fileName);
            CSVParser parser = CSVParser.parse(in, CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreSurroundingSpaces());
            Set<String> headers = parser.getHeaderMap().keySet();
            OutputProperty linkIdentificationMethod = this.getInitialCostLinkIdentificationMethod(headers);
            for (CSVRecord record : parser) {
                MacroscopicLinkSegment linkSegment = null;
                switch (linkIdentificationMethod) {
                    case LINK_SEGMENT_EXTERNAL_ID: {
                        String externalId = record.get("Link Segment External Id");
                        linkSegment = this.getLinkSegmentByExternalId(network, externalId);
                        break;
                    }
                    case LINK_SEGMENT_XML_ID: {
                        String xmlId = record.get("Link Segment Xml Id");
                        linkSegment = this.getLinkSegmentByXmlId(xmlId);
                        break;
                    }
                    case UPSTREAM_NODE_XML_ID: {
                        Node startNode = this.getNodeByXmlId(record.get("Upstream Node Xml Id"));
                        Node endNode = this.getNodeByXmlId(record.get("Downstream Node Xml Id"));
                        linkSegment = (MacroscopicLinkSegment)startNode.getLinkSegment(endNode);
                        break;
                    }
                    default: {
                        throw new PlanItException("Invalid Output Property " + BaseOutputProperty.convertToBaseOutputProperty(linkIdentificationMethod).getName() + " found in header of Initial Link Segment Cost CSV file");
                    }
                }
                PlanItException.throwIf(linkSegment == null, String.format("failed to find link segment for record %d", record.getRecordNumber()));
                this.setInitialLinkSegmentCost(initialLinkSegmentCost, record, linkSegment);
            }
            ((Reader)in).close();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when initialising link segment costs in PLANitIO", e);
        }
    }

    public PlanItInputBuilder(String projectPath) throws PlanItException {
        this(projectPath, DEFAULT_XML_FILE_EXTENSION);
    }

    public PlanItInputBuilder(String projectPath, String xmlFileExtension) throws PlanItException {
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "project path is set to: " + projectPath);
        this.projectPath = projectPath;
        this.xmlFileExtension = xmlFileExtension;
    }

    public static boolean validateXmlInputFile(File xmlFileLocation, String schemaFileLocation) {
        try {
            JAXBUtils.validateXml(xmlFileLocation, schemaFileLocation);
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    @Override
    public void notify(EventInterface event) throws RemoteException {
        if (event.getType() == TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE) {
            Object[] content = (Object[])event.getContent();
            Object projectComponent = content[0];
            Object[] parameters = (Object[])content[1];
            try {
                if (projectComponent instanceof MacroscopicNetwork) {
                    this.populateMacroscopicNetwork((MacroscopicNetwork)projectComponent);
                } else if (projectComponent instanceof Zoning) {
                    PlanItException.throwIf(!(parameters[0] instanceof MacroscopicNetwork), "Parameter of call to populateZoning() is not of class PhysicalNetwork");
                    MacroscopicNetwork physicalNetwork = (MacroscopicNetwork)parameters[0];
                    this.populateZoning((Zoning)projectComponent, physicalNetwork);
                } else if (projectComponent instanceof Demands) {
                    this.populateDemands((Demands)projectComponent, parameters[0], parameters[1]);
                } else if (projectComponent instanceof InitialPhysicalCost) {
                    this.populateInitialLinkSegmentCost((InitialLinkSegmentCost)projectComponent, parameters[0], parameters[1]);
                } else {
                    LOGGER.fine("Event component is " + projectComponent.getClass().getCanonicalName() + " which is not handled by PlanItInputBuilder.");
                }
            }
            catch (PlanItException e) {
                LOGGER.severe(e.getMessage());
                throw new RemoteException("Rethrowing as remote exception in notify", e);
            }
        }
    }
}

