/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.network.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.geo.PlanitJtsUtils;
import org.planit.geo.PlanitOpenGisUtils;
import org.planit.io.network.converter.PlanitNetworkReaderSettings;
import org.planit.io.xml.network.XmlMacroscopicNetworkLayerHelper;
import org.planit.io.xml.util.EnumConversionUtil;
import org.planit.io.xml.util.PlanitXmlReader;
import org.planit.mode.ModeFeaturesFactory;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.converter.NetworkReader;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.misc.CharacterUtils;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.MotorisationModeType;
import org.planit.utils.mode.PhysicalModeFeatures;
import org.planit.utils.mode.PredefinedModeType;
import org.planit.utils.mode.TrackModeType;
import org.planit.utils.mode.UsabilityModeFeatures;
import org.planit.utils.mode.UseOfModeType;
import org.planit.utils.mode.VehicularModeType;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.xml.generated.XMLElementConfiguration;
import org.planit.xml.generated.XMLElementInfrastructureLayer;
import org.planit.xml.generated.XMLElementInfrastructureLayers;
import org.planit.xml.generated.XMLElementLayerConfiguration;
import org.planit.xml.generated.XMLElementMacroscopicNetwork;
import org.planit.xml.generated.XMLElementModes;

public class PlanitNetworkReader
extends PlanitXmlReader<XMLElementMacroscopicNetwork>
implements NetworkReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkReader.class.getCanonicalName());
    private final PlanitNetworkReaderSettings settings = new PlanitNetworkReaderSettings();
    public static final String NETWORK_XSD_FILE = "src\\main\\resources\\xsd\\macroscopicnetworkinput.xsd";
    private MacroscopicNetwork network;

    private void injectMissingDefaultsToRawXmlNetwork() {
        if (((XMLElementMacroscopicNetwork)this.getXmlRootElement()).getConfiguration() == null) {
            ((XMLElementMacroscopicNetwork)this.getXmlRootElement()).setConfiguration(new XMLElementConfiguration());
        }
        if (((XMLElementMacroscopicNetwork)this.getXmlRootElement()).getConfiguration().getModes() == null) {
            ((XMLElementMacroscopicNetwork)this.getXmlRootElement()).getConfiguration().setModes(new XMLElementModes());
            XMLElementModes.Mode xmlElementMode = new XMLElementModes.Mode();
            xmlElementMode.setPredefined(true);
            xmlElementMode.setName(PredefinedModeType.CAR.value());
            xmlElementMode.setId("1");
            ((XMLElementMacroscopicNetwork)this.getXmlRootElement()).getConfiguration().getModes().getMode().add(xmlElementMode);
        }
    }

    private UsabilityModeFeatures parseUsabilityModeFeatures(XMLElementModes.Mode generatedMode) throws PlanItException {
        if (generatedMode.getUsabilityfeatures() == null) {
            return ModeFeaturesFactory.createDefaultUsabilityFeatures();
        }
        UseOfModeType useOfModeType = EnumConversionUtil.xmlToPlanit(generatedMode.getUsabilityfeatures().getUsedtotype());
        return ModeFeaturesFactory.createUsabilityFeatures(useOfModeType);
    }

    private PhysicalModeFeatures parsePhysicalModeFeatures(XMLElementModes.Mode generatedMode) throws PlanItException {
        if (generatedMode.getPhysicalfeatures() == null) {
            return ModeFeaturesFactory.createDefaultPhysicalFeatures();
        }
        VehicularModeType vehicleType = EnumConversionUtil.xmlToPlanit(generatedMode.getPhysicalfeatures().getVehicletype());
        MotorisationModeType motorisationType = EnumConversionUtil.xmlToPlanit(generatedMode.getPhysicalfeatures().getMotorisationtype());
        TrackModeType trackType = EnumConversionUtil.xmlToPlanit(generatedMode.getPhysicalfeatures().getTracktype());
        return ModeFeaturesFactory.createPhysicalFeatures(vehicleType, motorisationType, trackType);
    }

    private Map<String, Mode> parseModes() throws PlanItException {
        if (this.settings.getMapToIndexModeByXmlIds() == null) {
            this.settings.setMapToIndexModeByXmlIds(new HashMap<String, Mode>());
        }
        Map<String, Mode> modesByXmlId = this.settings.getMapToIndexModeByXmlIds();
        XMLElementConfiguration xmlGeneralConfiguration = ((XMLElementMacroscopicNetwork)this.getXmlRootElement()).getConfiguration();
        for (XMLElementModes.Mode xmlMode : xmlGeneralConfiguration.getModes().getMode()) {
            String name;
            String potentialPredefinedModeType;
            String modeXmlId = null;
            if (xmlMode.getId() != null && !xmlMode.getId().isBlank()) {
                modeXmlId = xmlMode.getId();
            }
            if ((potentialPredefinedModeType = (name = xmlMode.getName())) == null) {
                potentialPredefinedModeType = modeXmlId;
            }
            PredefinedModeType modeType = PredefinedModeType.create(potentialPredefinedModeType);
            if (!xmlMode.isPredefined() && modeType != PredefinedModeType.CUSTOM) {
                LOGGER.warning(String.format("mode %s is not registered as predefined mode but name corresponds to PLANit predefined mode, reverting to PLANit predefined mode", xmlMode.getName()));
            }
            if (name == null && modeType == PredefinedModeType.CUSTOM) {
                name = PredefinedModeType.CUSTOM.value().concat(String.valueOf(this.network.modes.size()));
            }
            Mode mode = null;
            if (modeType != PredefinedModeType.CUSTOM) {
                mode = this.network.modes.registerNew(modeType);
            } else {
                double maxSpeed = xmlMode.getMaxspeed() == null ? 80.0 : xmlMode.getMaxspeed();
                double pcu = xmlMode.getPcu() == null ? 1.0 : xmlMode.getPcu();
                PhysicalModeFeatures physicalFeatures = this.parsePhysicalModeFeatures(xmlMode);
                UsabilityModeFeatures usabilityFeatures = this.parseUsabilityModeFeatures(xmlMode);
                mode = this.network.modes.registerNewCustomMode(name, maxSpeed, pcu, physicalFeatures, usabilityFeatures);
            }
            if (xmlMode.getExternalid() != null && !xmlMode.getExternalid().isBlank()) {
                mode.setExternalId(xmlMode.getExternalid());
            }
            mode.setXmlId(modeXmlId);
            Mode prevValue = modesByXmlId.put(mode.getXmlId(), mode);
            if (prevValue == null) continue;
            String errorMessage = "duplicate mode xml id " + mode.getXmlId() + " found in network file";
            throw new PlanItException(errorMessage);
        }
        return modesByXmlId;
    }

    private CoordinateReferenceSystem parseCoordinateRerefenceSystem(XMLElementInfrastructureLayers xmlLayers) {
        CoordinateReferenceSystem crs = null;
        if (xmlLayers.getSrsname() == null || xmlLayers.getSrsname().isBlank()) {
            crs = PlanitJtsUtils.DEFAULT_GEOGRAPHIC_CRS;
            LOGGER.warning(String.format("coordinate reference system not set for PLANit network, applying default %s", crs.getName().getCode()));
        } else {
            crs = PlanitOpenGisUtils.createCoordinateReferenceSystem(xmlLayers.getSrsname());
        }
        return crs;
    }

    private InfrastructureLayer parseNetworkLayer(XMLElementInfrastructureLayer xmlLayer, Map<String, Mode> modesByXmlId, PlanitJtsUtils jtsUtils) throws PlanItException {
        MacroscopicPhysicalNetwork networkLayer = this.network.infrastructureLayers.createNew();
        if (xmlLayer.getId() != null && !xmlLayer.getId().isBlank()) {
            networkLayer.setXmlId(xmlLayer.getId());
        } else {
            LOGGER.warning("infrastructure layer id missing in xml, use generated id instead");
            networkLayer.setXmlId(Long.toString(networkLayer.getId()));
        }
        if (xmlLayer.getExternalid() != null && !xmlLayer.getExternalid().isBlank()) {
            networkLayer.setExternalId(xmlLayer.getExternalid());
        }
        if (xmlLayer.getModes() != null && !xmlLayer.getModes().isBlank()) {
            String xmlSupportedModes = xmlLayer.getModes();
            String[] modeRefs = xmlSupportedModes.split(CharacterUtils.COMMA.toString());
            for (String mode : Arrays.asList(modeRefs)) {
                if (modesByXmlId.containsKey(mode)) {
                    networkLayer.registerSupportedMode(modesByXmlId.get(mode));
                    continue;
                }
                LOGGER.severe(String.format("mode %s is not present on the network, ignored on network layer", mode));
            }
        } else {
            networkLayer.registerSupportedModes(this.network.modes.setOf());
        }
        XMLElementLayerConfiguration xmlLayerconfiguration = xmlLayer.getLayerconfiguration();
        if (xmlLayerconfiguration == null) {
            xmlLayer.setLayerconfiguration(new XMLElementLayerConfiguration());
            xmlLayerconfiguration = xmlLayer.getLayerconfiguration();
        }
        Map<String, MacroscopicLinkSegmentType> linkSegmentTypesByXmlId = XmlMacroscopicNetworkLayerHelper.parseLinkSegmentTypes(xmlLayerconfiguration, networkLayer, this.settings, modesByXmlId);
        Map<String, Node> nodesByXmlId = XmlMacroscopicNetworkLayerHelper.parseNodes(xmlLayer, networkLayer, this.settings);
        XmlMacroscopicNetworkLayerHelper.parseLinkAndLinkSegments(xmlLayer, networkLayer, this.settings, nodesByXmlId, linkSegmentTypesByXmlId, jtsUtils);
        return networkLayer;
    }

    private void parseNetworkLayers(Map<String, Mode> modesByXmlId) throws PlanItException {
        XMLElementInfrastructureLayers xmlLayers = ((XMLElementMacroscopicNetwork)this.getXmlRootElement()).getInfrastructurelayers();
        PlanItException.throwIfNull(xmlLayers, "infrastructurelayers element not present in network file");
        CoordinateReferenceSystem crs = this.parseCoordinateRerefenceSystem(xmlLayers);
        this.network.setCoordinateReferenceSystem(crs);
        PlanitJtsUtils jtsUtils = new PlanitJtsUtils(this.network.getCoordinateReferenceSystem());
        List<XMLElementInfrastructureLayer> xmlLayerList = xmlLayers.getLayer();
        TreeSet<Mode> usedModes = new TreeSet<Mode>();
        for (XMLElementInfrastructureLayer xmlLayer : xmlLayerList) {
            InfrastructureLayer layer = this.parseNetworkLayer(xmlLayer, modesByXmlId, jtsUtils);
            int prevSize = usedModes.size();
            usedModes.addAll(layer.getSupportedModes());
            if (usedModes.size() == prevSize + layer.getSupportedModes().size()) continue;
            throw new PlanItException("modes are only allowed to be used in a single network layer, not multiple, please check your network inputs");
        }
    }

    protected void setNetwork(InfrastructureNetwork network) throws PlanItException {
        if (!(network instanceof MacroscopicNetwork)) {
            throw new PlanItException("currently the PLANit network reader only supports macroscopic infrastructure networks, the provided network is not of this type");
        }
        this.network = (MacroscopicNetwork)network;
    }

    public PlanitNetworkReader(String networkPathDirectory, String xmlFileExtension, InfrastructureNetwork network) throws PlanItException {
        super(XMLElementMacroscopicNetwork.class, networkPathDirectory, xmlFileExtension);
        this.setNetwork(network);
    }

    public PlanitNetworkReader(XMLElementMacroscopicNetwork externalXmlRawNetwork, InfrastructureNetwork network) throws PlanItException {
        super(externalXmlRawNetwork);
        this.setNetwork(network);
    }

    @Override
    public InfrastructureNetwork read() throws PlanItException {
        this.initialiseAndParseXmlRootElement();
        this.injectMissingDefaultsToRawXmlNetwork();
        try {
            Map<String, Mode> modesByXmlId = this.parseModes();
            this.parseNetworkLayers(modesByXmlId);
            this.clearXmlContent();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error while populating physical network in PLANitIO", e);
        }
        return this.network;
    }

    public PlanitNetworkReaderSettings getSettings() {
        return this.settings;
    }
}

