/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.network.converter;

import java.util.logging.Logger;
import org.planit.io.network.converter.PlanitNetworkReader;
import org.planit.network.InfrastructureNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.xml.generated.XMLElementMacroscopicNetwork;

public class PlanitNetworkReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkReaderFactory.class.getCanonicalName());

    public static PlanitNetworkReader createReader(String networkPath, String xmlFileExtension, InfrastructureNetwork network) {
        try {
            return new PlanitNetworkReader(networkPath, xmlFileExtension, network);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public static PlanitNetworkReader createReader(XMLElementMacroscopicNetwork xmlRawNetwork, InfrastructureNetwork network) {
        try {
            return new PlanitNetworkReader(xmlRawNetwork, network);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }
}

