/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.network.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import net.opengis.gml.CoordType;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.PointType;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.planit.geo.PlanitJtsUtils;
import org.planit.geo.PlanitOpenGisUtils;
import org.planit.io.network.converter.PlanitNetworkWriterSettings;
import org.planit.io.xml.util.EnumConversionUtil;
import org.planit.io.xml.util.JAXBUtils;
import org.planit.io.xml.util.PlanitSchema;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.converter.IdMapperFunctionFactory;
import org.planit.network.converter.IdMapperType;
import org.planit.network.converter.NetworkWriterImpl;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.Modes;
import org.planit.utils.mode.PhysicalModeFeatures;
import org.planit.utils.mode.UsabilityModeFeatures;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.Links;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.Nodes;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentTypes;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;
import org.planit.xml.generated.Accessmode;
import org.planit.xml.generated.Direction;
import org.planit.xml.generated.LengthUnit;
import org.planit.xml.generated.XMLElementConfiguration;
import org.planit.xml.generated.XMLElementInfrastructureLayer;
import org.planit.xml.generated.XMLElementInfrastructureLayers;
import org.planit.xml.generated.XMLElementLayerConfiguration;
import org.planit.xml.generated.XMLElementLinkLengthType;
import org.planit.xml.generated.XMLElementLinkSegment;
import org.planit.xml.generated.XMLElementLinkSegmentType;
import org.planit.xml.generated.XMLElementLinkSegmentTypes;
import org.planit.xml.generated.XMLElementLinks;
import org.planit.xml.generated.XMLElementMacroscopicNetwork;
import org.planit.xml.generated.XMLElementModes;
import org.planit.xml.generated.XMLElementNodes;
import org.planit.xml.generated.XMLElementPhysicalFeatures;
import org.planit.xml.generated.XMLElementUsabilityFeatures;

public class PlanitNetworkWriter
extends NetworkWriterImpl {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkWriter.class.getCanonicalName());
    protected final PlanitNetworkWriterSettings settings = new PlanitNetworkWriterSettings();
    private Function<Node, String> nodeIdMapper;
    private Function<Link, String> linkIdMapper;
    private Function<MacroscopicLinkSegment, String> linkSegmentIdMapper;
    private Function<MacroscopicLinkSegmentType, String> linkSegmentTypeIdMapper;
    private Function<Mode, String> modeIdMapper;
    private final String networkPath;
    private String networkFileName = "network.xml";
    private final XMLElementMacroscopicNetwork xmlRawNetwork;
    private MathTransform destinationCrsTransformer = null;
    public static final String DEFAULT_NETWORK_FILE_NAME = "network.xml";

    private String getXmlModeReference(Mode mode) {
        if (mode.isPredefinedModeType()) {
            return mode.getXmlId();
        }
        return this.modeIdMapper.apply(mode);
    }

    private void populateLinkSegment(XMLElementLinkSegment xmlLinkSegment, MacroscopicLinkSegment linkSegment) {
        xmlLinkSegment.setId(this.linkSegmentIdMapper.apply(linkSegment));
        xmlLinkSegment.setMaxspeed(linkSegment.getPhysicalSpeedLimitKmH());
        xmlLinkSegment.setNumberoflanes(BigInteger.valueOf(linkSegment.getNumberOfLanes()));
        if (!linkSegment.hasLinkSegmentType()) {
            LOGGER.severe(String.format("missing link segment type on link segment %s (id:%d)", linkSegment.getExternalId(), linkSegment.getId()));
        } else {
            xmlLinkSegment.setTyperef(this.linkSegmentTypeIdMapper.apply(linkSegment.getLinkSegmentType()));
        }
    }

    private void populateLinkSegments(XMLElementLinks.Link xmlLink, Link link) {
        XMLElementLinkSegment xmlLinkSegment;
        List<XMLElementLinkSegment> xmlLinkSegments = xmlLink.getLinksegment();
        if (link.hasLinkSegmentAb()) {
            xmlLinkSegment = new XMLElementLinkSegment();
            xmlLinkSegment.setDir(Direction.A_B);
            this.populateLinkSegment(xmlLinkSegment, (MacroscopicLinkSegment)link.getLinkSegmentAb());
            xmlLinkSegments.add(xmlLinkSegment);
        }
        if (link.hasLinkSegmentBa()) {
            xmlLinkSegment = new XMLElementLinkSegment();
            xmlLinkSegment.setDir(Direction.B_A);
            this.populateLinkSegment(xmlLinkSegment, (MacroscopicLinkSegment)link.getLinkSegmentBa());
            xmlLinkSegments.add(xmlLinkSegment);
        }
        if (xmlLinkSegments == null && (link.hasLinkSegmentAb() || link.hasLinkSegmentBa())) {
            LOGGER.severe(String.format("link %s (id:%d) has no xm Link segment element, but does have link segments", link.getExternalId(), link.getId()));
        }
    }

    private void populateXmlLink(List<XMLElementLinks.Link> xmlLinkList, Link link) {
        XMLElementLinks.Link xmlLink = new XMLElementLinks.Link();
        xmlLink.setId(this.linkIdMapper.apply(link));
        if (link.hasExternalId()) {
            xmlLink.setExternalid(link.getExternalId());
        }
        XMLElementLinkLengthType xmlLinkLength = new XMLElementLinkLengthType();
        xmlLinkLength.setUnit(LengthUnit.KM);
        xmlLinkLength.setValue(link.getLengthKm());
        xmlLink.setLength(xmlLinkLength);
        if (link.hasName()) {
            xmlLink.setName(link.getName());
        }
        xmlLink.setNodearef(this.nodeIdMapper.apply((Node)link.getNodeA()));
        xmlLink.setNodebref(this.nodeIdMapper.apply((Node)link.getNodeB()));
        LineString destinationLineString = link.getGeometry();
        try {
            if (this.destinationCrsTransformer != null) {
                destinationLineString = (LineString)JTS.transform(destinationLineString, this.destinationCrsTransformer);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("unable to construct Planit Xml link geometry for link %d (id:%d)", link.getExternalId(), link.getId()));
        }
        String coordinateCsvValue = PlanitJtsUtils.createCsvStringFromLineString(destinationLineString, this.settings.getTupleSeparator(), this.settings.getCommaSeparator(), this.settings.getDecimalFormat());
        CoordinatesType xmlCoordinates = new CoordinatesType();
        xmlCoordinates.setValue(coordinateCsvValue);
        xmlCoordinates.setCs(this.settings.getCommaSeparator().toString());
        xmlCoordinates.setTs(this.settings.getTupleSeparator().toString());
        xmlCoordinates.setDecimal(this.settings.getDecimalSeparator().toString());
        LineStringType xmlLineString = new LineStringType();
        xmlLineString.setCoordinates(xmlCoordinates);
        this.populateLinkSegments(xmlLink, link);
        xmlLinkList.add(xmlLink);
    }

    private void populateXmlLinks(XMLElementInfrastructureLayer xmlNetworkLayer, Links<Link> links) {
        XMLElementLinks xmlLinks = xmlNetworkLayer.getLinks();
        if (xmlLinks == null) {
            xmlLinks = new XMLElementLinks();
            xmlNetworkLayer.setLinks(xmlLinks);
        }
        List<XMLElementLinks.Link> xmlLinkList = xmlLinks.getLink();
        links.forEach(link -> this.populateXmlLink(xmlLinkList, (Link)link));
    }

    private void populateXmlNode(List<XMLElementNodes.Node> xmlNodeList, Node node) {
        XMLElementNodes.Node xmlNode = new XMLElementNodes.Node();
        xmlNodeList.add(xmlNode);
        xmlNode.setId(this.nodeIdMapper.apply(node));
        if (node.hasExternalId()) {
            xmlNode.setExternalid(node.getExternalId());
        }
        xmlNode.setName(node.getName());
        CoordType xmlCoord = new CoordType();
        Coordinate nodeCoordinate = null;
        try {
            nodeCoordinate = this.destinationCrsTransformer != null ? ((Point)JTS.transform(node.getPosition(), this.destinationCrsTransformer)).getCoordinate() : node.getPosition().getCoordinate();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("unable to construct Planit Xml node coordinates for node %d (id:%d)", node.getExternalId(), node.getId()));
        }
        xmlCoord.setX(BigDecimal.valueOf(nodeCoordinate.x));
        xmlCoord.setY(BigDecimal.valueOf(nodeCoordinate.y));
        PointType xmlPointType = new PointType();
        xmlPointType.setCoord(xmlCoord);
        xmlNode.setPoint(xmlPointType);
    }

    private void populateXmlNodes(XMLElementInfrastructureLayer xmlNetworkLayer, Nodes<Node> nodes) {
        XMLElementNodes xmlNodes = xmlNetworkLayer.getNodes();
        if (xmlNodes == null) {
            xmlNodes = new XMLElementNodes();
            xmlNetworkLayer.setNodes(xmlNodes);
        }
        List<XMLElementNodes.Node> xmlNodeList = xmlNodes.getNode();
        nodes.forEach(node -> this.populateXmlNode(xmlNodeList, (Node)node));
    }

    private void populateLinkSegmentTypeModeProperties(List<Accessmode> xmlModeAccessList, Mode mode, MacroscopicModeProperties modeProperties) {
        Accessmode xmlModeAccess = new Accessmode();
        xmlModeAccess.setRef(this.getXmlModeReference(mode));
        xmlModeAccess.setCritspeed(modeProperties.getCriticalSpeedKmH());
        xmlModeAccess.setMaxspeed(modeProperties.getMaximumSpeedKmH());
        xmlModeAccessList.add(xmlModeAccess);
    }

    private void populateXmlLinkSegmentType(List<XMLElementLinkSegmentType> xmlLinkSegmentTypeList, MacroscopicLinkSegmentType linkSegmentType) {
        XMLElementLinkSegmentType xmlLinkSegmentType = new XMLElementLinkSegmentType();
        xmlLinkSegmentType.setId(this.linkSegmentTypeIdMapper.apply(linkSegmentType));
        if (linkSegmentType.hasExternalId()) {
            xmlLinkSegmentType.setExternalid(linkSegmentType.getExternalId());
        }
        xmlLinkSegmentType.setCapacitylane(linkSegmentType.getCapacityPerLane());
        xmlLinkSegmentType.setMaxdensitylane(linkSegmentType.getMaximumDensityPerLane());
        xmlLinkSegmentType.setName(linkSegmentType.getName());
        XMLElementLinkSegmentType.Access xmlAccessModes = xmlLinkSegmentType.getAccess();
        if (xmlAccessModes == null) {
            xmlAccessModes = new XMLElementLinkSegmentType.Access();
            xmlLinkSegmentType.setAccess(xmlAccessModes);
        }
        List<Accessmode> xmlModeAccessList = xmlAccessModes.getMode();
        linkSegmentType.getAvailableModes().forEach(mode -> this.populateLinkSegmentTypeModeProperties(xmlModeAccessList, (Mode)mode, linkSegmentType.getModeProperties((Mode)mode)));
        xmlLinkSegmentTypeList.add(xmlLinkSegmentType);
    }

    private void populateXmlLinkSegmentTypes(XMLElementLayerConfiguration xmlLayerConfiguration, MacroscopicLinkSegmentTypes linkSegmentTypes) {
        XMLElementLinkSegmentTypes xmlLinkSegmentTypes = xmlLayerConfiguration.getLinksegmenttypes();
        if (xmlLinkSegmentTypes == null) {
            xmlLinkSegmentTypes = new XMLElementLinkSegmentTypes();
            xmlLayerConfiguration.setLinksegmenttypes(xmlLinkSegmentTypes);
        }
        List<XMLElementLinkSegmentType> xmlLinkSegmentTypeList = xmlLinkSegmentTypes.getLinksegmenttype();
        linkSegmentTypes.forEach(linkSegmentType -> this.populateXmlLinkSegmentType(xmlLinkSegmentTypeList, (MacroscopicLinkSegmentType)linkSegmentType));
    }

    private void populateModePhysicalFeatures(XMLElementModes.Mode xmlMode, PhysicalModeFeatures physicalModeFeatures) {
        XMLElementPhysicalFeatures xmlPhysicalFeatures = xmlMode.getPhysicalfeatures();
        if (xmlPhysicalFeatures == null) {
            xmlPhysicalFeatures = new XMLElementPhysicalFeatures();
            xmlMode.setPhysicalfeatures(xmlPhysicalFeatures);
        }
        try {
            xmlPhysicalFeatures.setMotorisationtype(EnumConversionUtil.planitToXml(physicalModeFeatures.getMotorisationType()));
            xmlPhysicalFeatures.setTracktype(EnumConversionUtil.planitToXml(physicalModeFeatures.getTrackType()));
            xmlPhysicalFeatures.setVehicletype(EnumConversionUtil.planitToXml(physicalModeFeatures.getVehicularType()));
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to set physical features on mode properties");
        }
    }

    private void populateModeUsabilityFeatures(XMLElementModes.Mode xmlMode, UsabilityModeFeatures usabilityModeFeatures) {
        XMLElementUsabilityFeatures xmlUseFeatures = xmlMode.getUsabilityfeatures();
        if (xmlUseFeatures == null) {
            xmlUseFeatures = new XMLElementUsabilityFeatures();
            xmlMode.setUsabilityfeatures(xmlUseFeatures);
        }
        try {
            xmlUseFeatures.setUsedtotype(EnumConversionUtil.planitToXml(usabilityModeFeatures.getUseOfType()));
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to set physical features on mode properties");
        }
    }

    private void populateXmlMode(List<XMLElementModes.Mode> xmlModesList, Mode mode) {
        XMLElementModes.Mode xmlMode = new XMLElementModes.Mode();
        xmlMode.setId(this.getXmlModeReference(mode));
        if (mode.hasExternalId()) {
            xmlMode.setExternalid(mode.getExternalId());
        }
        xmlMode.setMaxspeed(mode.getMaximumSpeedKmH());
        if (mode.hasName()) {
            xmlMode.setName(mode.getName());
        }
        xmlMode.setPcu(mode.getPcu());
        xmlMode.setPredefined(mode.isPredefinedModeType());
        if (mode.hasPhysicalFeatures()) {
            this.populateModePhysicalFeatures(xmlMode, mode.getPhysicalFeatures());
        }
        if (mode.hasUseFeatures()) {
            this.populateModeUsabilityFeatures(xmlMode, mode.getUseFeatures());
        }
        xmlModesList.add(xmlMode);
    }

    private void populateXmlModes(Modes modes) {
        XMLElementModes xmlModes = this.xmlRawNetwork.getConfiguration().getModes();
        if (xmlModes == null) {
            xmlModes = new XMLElementModes();
            this.xmlRawNetwork.getConfiguration().setModes(xmlModes);
        }
        List<XMLElementModes.Mode> xmlModesList = xmlModes.getMode();
        modes.forEach(mode -> this.populateXmlMode(xmlModesList, (Mode)mode));
    }

    protected void populateXmlConfiguration(Modes modes) {
        XMLElementConfiguration xmlConfiguration = this.xmlRawNetwork.getConfiguration();
        if (xmlConfiguration == null) {
            xmlConfiguration = new XMLElementConfiguration();
            this.xmlRawNetwork.setConfiguration(xmlConfiguration);
        }
        this.populateXmlModes(modes);
    }

    protected void populateXmlLayerConfiguration(XMLElementInfrastructureLayer xmlNetworkLayer, MacroscopicLinkSegmentTypes linkSegmentTypes) {
        XMLElementLayerConfiguration xmlLayerConfiguration = xmlNetworkLayer.getLayerconfiguration();
        if (xmlLayerConfiguration == null) {
            xmlLayerConfiguration = new XMLElementLayerConfiguration();
            xmlNetworkLayer.setLayerconfiguration(xmlLayerConfiguration);
        }
        this.populateXmlLinkSegmentTypes(xmlLayerConfiguration, linkSegmentTypes);
    }

    protected void initialiseIdMappingFunctions() throws PlanItException {
        this.nodeIdMapper = IdMapperFunctionFactory.createNodeIdMappingFunction(this.getIdMapperType());
        this.linkIdMapper = IdMapperFunctionFactory.createLinkIdMappingFunction(this.getIdMapperType());
        this.linkSegmentIdMapper = IdMapperFunctionFactory.createLinkSegmentIdMappingFunction(this.getIdMapperType());
        this.linkSegmentTypeIdMapper = IdMapperFunctionFactory.createLinkSegmentTypeIdMappingFunction(this.getIdMapperType());
        this.modeIdMapper = IdMapperFunctionFactory.createModeIdMappingFunction(this.getIdMapperType());
    }

    protected void persist() throws PlanItException {
        try {
            JAXBUtils.generateXmlFileFromObject(this.xmlRawNetwork, XMLElementMacroscopicNetwork.class, Paths.get(this.networkPath, this.networkFileName), PlanitSchema.createPlanitSchemaUri("macroscopicnetworkinput.xsd"));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("unable to persist PLANit network in native format");
        }
    }

    protected void prepareCoordinateReferenceSystem(MacroscopicNetwork network) throws PlanItException {
        CoordinateReferenceSystem destinationCrs = this.identifyDestinationCoordinateReferenceSystem(this.settings.getDestinationCoordinateReferenceSystem(), this.settings.getCountryName(), network.getCoordinateReferenceSystem());
        PlanItException.throwIfNull(destinationCrs, "destination Coordinate Reference System is null, this is not allowed");
        this.settings.setDestinationCoordinateReferenceSystem(destinationCrs);
        if (!destinationCrs.equals(network.getCoordinateReferenceSystem())) {
            this.destinationCrsTransformer = PlanitOpenGisUtils.findMathTransform(network.getCoordinateReferenceSystem(), this.settings.getDestinationCoordinateReferenceSystem());
        }
    }

    protected void populateXmlNetworkLayer(XMLElementInfrastructureLayers xmlInfrastructureLayers, MacroscopicPhysicalNetwork physicalNetworkLayer) {
        XMLElementInfrastructureLayer xmlNetworkLayer = new XMLElementInfrastructureLayer();
        xmlInfrastructureLayers.getLayer().add(xmlNetworkLayer);
        this.populateXmlLayerConfiguration(xmlNetworkLayer, physicalNetworkLayer.linkSegmentTypes);
        this.populateXmlLinks(xmlNetworkLayer, physicalNetworkLayer.links);
        this.populateXmlNodes(xmlNetworkLayer, physicalNetworkLayer.nodes);
    }

    protected void populateXmlNetworkLayers(MacroscopicNetwork network) {
        XMLElementInfrastructureLayers xmlInfrastructureLayers = this.xmlRawNetwork.getInfrastructurelayers();
        if (xmlInfrastructureLayers == null) {
            this.xmlRawNetwork.setInfrastructurelayers(new XMLElementInfrastructureLayers());
            xmlInfrastructureLayers = this.xmlRawNetwork.getInfrastructurelayers();
        }
        xmlInfrastructureLayers.setSrsname(this.settings.getDestinationCoordinateReferenceSystem().getName().getCode());
        for (InfrastructureLayer networkLayer : network.infrastructureLayers) {
            if (networkLayer instanceof MacroscopicPhysicalNetwork) {
                MacroscopicPhysicalNetwork physicalNetworkLayer = (MacroscopicPhysicalNetwork)networkLayer;
                this.populateXmlNetworkLayer(xmlInfrastructureLayers, physicalNetworkLayer);
                continue;
            }
            LOGGER.severe(String.format("unsupported macroscopic infrastructure layer %s encountered", networkLayer.getXmlId()));
        }
    }

    public PlanitNetworkWriter(String networkPath, XMLElementMacroscopicNetwork xmlRawNetwork) {
        this(networkPath, null, xmlRawNetwork);
    }

    public PlanitNetworkWriter(String networkPath, String countryName, XMLElementMacroscopicNetwork xmlRawNetwork) {
        super(IdMapperType.DEFAULT);
        this.networkPath = networkPath;
        this.xmlRawNetwork = xmlRawNetwork;
        if (countryName != null && !countryName.isBlank()) {
            this.settings.setCountryName(countryName);
        } else {
            this.settings.setCountryName("global");
        }
    }

    @Override
    public void write(InfrastructureNetwork network) throws PlanItException {
        if (!(network instanceof MacroscopicNetwork)) {
            throw new PlanItException("currently the PLANit network reader only supports macroscopic infrastructure networks, the provided network is not of this type");
        }
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        this.initialiseIdMappingFunctions();
        this.prepareCoordinateReferenceSystem(macroscopicNetwork);
        this.settings.logSettings();
        this.populateXmlConfiguration(network.modes);
        this.populateXmlNetworkLayers(macroscopicNetwork);
        this.persist();
    }
}

