/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.converter;

import java.util.logging.Logger;
import org.planit.output.enums.Type;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.unit.Units;
import org.planit.xml.generated.Typevalues;
import org.planit.xml.generated.Unitsvalues;

public interface EnumConverter {
    public static final Logger LOGGER = Logger.getLogger(EnumConverter.class.getCanonicalName());

    public static Typevalues convertFromPlanItToXmlGeneratedType(Type type) throws PlanItException {
        switch (type) {
            case DOUBLE: {
                return Typevalues.DOUBLE;
            }
            case FLOAT: {
                return Typevalues.FLOAT;
            }
            case INTEGER: {
                return Typevalues.INTEGER;
            }
            case LONG: {
                return Typevalues.INTEGER;
            }
            case BOOLEAN: {
                return Typevalues.BOOLEAN;
            }
            case SRSNAME: {
                return Typevalues.SRSNAME;
            }
            case STRING: {
                return Typevalues.STRING;
            }
        }
        throw new PlanItException("Data type " + type.value() + " has not been defined in the typevalues simple type in the output XSD file");
    }

    public static Unitsvalues convertFromPlanItToXmlGeneratedUnits(Units units) throws PlanItException {
        switch (units) {
            case VEH_KM: {
                return Unitsvalues.VEH_KM;
            }
            case NONE: {
                return Unitsvalues.NONE;
            }
            case VEH_HOUR: {
                return Unitsvalues.VEH_H;
            }
            case KM_HOUR: {
                return Unitsvalues.KM_H;
            }
            case HOUR: {
                return Unitsvalues.H;
            }
            case KM: {
                return Unitsvalues.KM;
            }
            case SRS: {
                return Unitsvalues.SRS;
            }
        }
        throw new PlanItException("Units type " + units.value() + " has not been defined in the unitsvalues simple type in the output XSD file.");
    }
}

