/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.network.physical.macroscopic;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.network.macroscopic.physical.MacroscopicModePropertiesFactory;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicLinkSegmentTypeXmlHelper {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentTypeXmlHelper.class.getCanonicalName());
    private static Map<Object, MacroscopicLinkSegmentTypeXmlHelper> existingLinkTypeHelpers;
    private String externalId;
    private String xmlId;
    private String name;
    private double capacityPerLane;
    private double maximumDensityPerLane;
    private Map<Mode, MacroscopicModeProperties> macroscopicLinkSegmentTypeModeProperties;

    protected void setCapacityPerLane(double capacityPerLane) {
        this.capacityPerLane = capacityPerLane;
    }

    protected void setMaximumDensityPerLane(double maximumDensityPerLane) {
        this.maximumDensityPerLane = maximumDensityPerLane;
    }

    public void updateLinkSegmentTypeModeProperties(Object linkTypeExternalId, Mode mode, double maxSpeed, double critSpeed) {
        if (maxSpeed < 0.0) {
            LOGGER.warning("a negative maximum speed has been defined for Link Type " + this.getName() + " and Mode " + mode.getName() + ".  Setting the speed to zero instead (which means vehicles of this type are forbidden in links of this type.)");
            maxSpeed = 0.0;
        }
        MacroscopicModeProperties macroscopicModeProperties = MacroscopicModePropertiesFactory.create(maxSpeed, critSpeed);
        this.macroscopicLinkSegmentTypeModeProperties.put(mode, macroscopicModeProperties);
    }

    public static void reset() {
        existingLinkTypeHelpers = new HashMap<Object, MacroscopicLinkSegmentTypeXmlHelper>();
    }

    public MacroscopicLinkSegmentTypeXmlHelper(String name, double capacityPerLane, double maximumDensityPerLane, String externalId, String xmlId) {
        this.name = name;
        if (capacityPerLane == 0.0) {
            LOGGER.warning("link Type " + name + " initially defined without a capacity, being given a capacity of zero.");
        }
        this.capacityPerLane = capacityPerLane;
        this.maximumDensityPerLane = maximumDensityPerLane;
        this.externalId = externalId;
        this.xmlId = xmlId;
        this.macroscopicLinkSegmentTypeModeProperties = new HashMap<Mode, MacroscopicModeProperties>();
        if (existingLinkTypeHelpers.containsKey(xmlId)) {
            MacroscopicLinkSegmentTypeXmlHelper other = existingLinkTypeHelpers.get(xmlId);
            if (capacityPerLane != other.getCapacityPerLane()) {
                LOGGER.warning("different capacity per lane values for Link Type " + other.getName() + ".  Will use the highest one.");
            }
            if (capacityPerLane > other.getCapacityPerLane()) {
                this.setCapacityPerLane(capacityPerLane);
            }
            if (maximumDensityPerLane != other.getMaximumDensityPerLane()) {
                LOGGER.warning("different maximum density per lane values for link type " + other.getName() + ".  Will use the highest one.");
            }
            if (maximumDensityPerLane > other.getMaximumDensityPerLane()) {
                this.setMaximumDensityPerLane(maximumDensityPerLane);
            }
        }
        existingLinkTypeHelpers.put(xmlId, this);
    }

    public String getName() {
        return this.name;
    }

    public double getCapacityPerLane() {
        return this.capacityPerLane;
    }

    public double getMaximumDensityPerLane() {
        return this.maximumDensityPerLane;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Map<Mode, MacroscopicModeProperties> getModePropertiesMap() {
        return this.macroscopicLinkSegmentTypeModeProperties;
    }

    public String getXmlId() {
        return this.xmlId;
    }
}

