/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.zoning;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.PolygonType;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.planit.geo.PlanitJtsUtils;
import org.planit.io.xml.util.PlanitXmlReader;
import org.planit.io.zoning.PlanitZoningReaderSettings;
import org.planit.network.InfrastructureNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.ExternalIdable;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.Modes;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.zoning.Centroid;
import org.planit.utils.zoning.Connectoid;
import org.planit.utils.zoning.ConnectoidType;
import org.planit.utils.zoning.DirectedConnectoid;
import org.planit.utils.zoning.OdZone;
import org.planit.utils.zoning.TransferZone;
import org.planit.utils.zoning.TransferZoneType;
import org.planit.utils.zoning.UndirectedConnectoid;
import org.planit.utils.zoning.Zone;
import org.planit.utils.zoning.Zones;
import org.planit.xml.generated.Connectoidnodelocationtype;
import org.planit.xml.generated.Connectoidtype;
import org.planit.xml.generated.Connectoidtypetype;
import org.planit.xml.generated.Intermodaltype;
import org.planit.xml.generated.Odconnectoid;
import org.planit.xml.generated.Transferzonetype;
import org.planit.xml.generated.XMLElementCentroid;
import org.planit.xml.generated.XMLElementConnectoid;
import org.planit.xml.generated.XMLElementMacroscopicZoning;
import org.planit.xml.generated.XMLElementTransferZoneAccess;
import org.planit.xml.generated.XMLElementTransferZones;
import org.planit.xml.generated.XMLElementZones;
import org.planit.zoning.Zoning;

public class PlanitZoningReader
extends PlanitXmlReader<XMLElementMacroscopicZoning> {
    private static final Logger LOGGER = Logger.getLogger(PlanitZoningReader.class.getCanonicalName());
    private PlanitJtsUtils jtsUtils = null;
    protected final PlanitZoningReaderSettings settings = new PlanitZoningReaderSettings();
    protected Zoning zoning;

    private static TransferZoneType parseTransferZoneType(Transferzonetype xmlTransferZone) {
        if (xmlTransferZone == null) {
            return TransferZoneType.NONE;
        }
        switch (xmlTransferZone) {
            case PLATFORM: {
                return TransferZoneType.PLATFORM;
            }
            case STOP_POLE: {
                return TransferZoneType.POLE;
            }
        }
        LOGGER.warning(String.format("unknown transfer stop type %s found, changed to `unknown`", xmlTransferZone.value()));
        return TransferZoneType.UNKNOWN;
    }

    private static ConnectoidType parseConnectoidType(Connectoidtypetype xmlConnectoidType) {
        if (xmlConnectoidType == null) {
            return ConnectoidType.NONE;
        }
        switch (xmlConnectoidType) {
            case PT_VEH_STOP: {
                return ConnectoidType.PT_VEHICLE_STOP;
            }
            case TRAVELLER_ACCESS: {
                return ConnectoidType.TRAVELLER_ACCESS;
            }
        }
        LOGGER.warning(String.format("unknown connectoid type %s found, changed to `unknown`", xmlConnectoidType.value()));
        return ConnectoidType.UNKNOWN;
    }

    private static void populateZoneGeometry(Zone zone, PolygonType xmlPolygon) {
        if (xmlPolygon != null) {
            if (xmlPolygon.getExterior() == null) {
                LOGGER.warning(String.format("zones only support polygon geometries with an outer exterior, however this is missing for zone %s", zone.getXmlId()));
            } else if (xmlPolygon.getExterior().getValue().getRing() == null) {
                LOGGER.warning(String.format("expected ring element missing within polygon exterior element for zone %s", zone.getXmlId()));
            } else if (xmlPolygon.getExterior().getValue().getRing().getValue() instanceof LinearRingType) {
                LinearRingType xmlLinearRing = (LinearRingType)xmlPolygon.getExterior().getValue().getRing().getValue();
                Polygon geometry = PlanitJtsUtils.create2DPolygon(xmlLinearRing.getPosList().getValue());
                zone.setGeometry(geometry);
            } else {
                LOGGER.warning(String.format("expected linear ring within polygon exterior element for zone %s, but different ring type was encountered", zone.getXmlId()));
            }
        }
    }

    private static void populateConnectoidToZoneLengths(Connectoid connectoid, Connectoidtype xmlConnectoid, Point position, PlanitJtsUtils jtsUtils) throws PlanItException {
        block5: {
            Double connectoidLength;
            block4: {
                connectoidLength = null;
                if (xmlConnectoid.getLength() == null) break block4;
                connectoidLength = xmlConnectoid.getLength().floatValue();
                if (connectoid.getNumberOfAccessZones() > 1L) {
                    LOGGER.fine(String.format("connectoid %s has explicitly set length, yet has multiple access zones that now all receive equal lengths", connectoid.getXmlId()));
                }
                for (Zone accessZone : connectoid) {
                    connectoid.setLength(accessZone, connectoidLength);
                }
                break block5;
            }
            if (position == null) break block5;
            for (Zone accessZone : connectoid) {
                if (accessZone.getCentroid() == null || accessZone.getCentroid().getPosition() != null) {
                    LOGGER.warning(String.format("access zone of connectoid %s is null", connectoid.getXmlId()));
                    continue;
                }
                if (accessZone.getCentroid().getPosition() == null) continue;
                connectoidLength = jtsUtils.getDistanceInKilometres(accessZone.getCentroid().getPosition(), position);
                connectoid.setLength(accessZone, connectoidLength);
            }
        }
    }

    private <T extends Zone> T parseBaseZone(Zones<T> zones, String xmlId, String externalId, XMLElementCentroid xmlCentroid) throws PlanItException {
        T zone = zones.registerNew();
        if (xmlId == null || xmlId.isBlank()) {
            throw new PlanItException("zone cannot be parsed, its (XML) id is not set");
        }
        zone.setXmlId(xmlId);
        Zone duplicatezone = this.settings.getMapToIndexZoneByXmlIds().put(xmlId, (Zone)zone);
        if (duplicatezone != null) {
            throw new PlanItException(String.format("zone with duplicate (XML) id %s found, this is not allowed", xmlId));
        }
        if (externalId != null && !externalId.isBlank()) {
            zone.setExternalId(externalId);
        }
        Centroid centroid = zone.getCentroid();
        if (xmlCentroid != null && xmlCentroid.getPoint() != null) {
            List<Double> value = xmlCentroid.getPoint().getPos().getValue();
            centroid.setPosition(PlanitJtsUtils.createPoint(value.get(0), value.get(1)));
        }
        return zone;
    }

    private Connectoid parseBaseConnectoid(Connectoidtype xmlConnectoid, Map<String, Node> nodesByXmlIds, Map<String, MacroscopicLinkSegment> linkSegmentsByXmlId) throws PlanItException {
        ExternalIdable theConnectoid = null;
        Node accessNode = null;
        if (xmlConnectoid instanceof Odconnectoid) {
            if (nodesByXmlIds == null) {
                throw new PlanItException("provided nodes by XML id is null when parsing XML OD connectoid");
            }
            accessNode = nodesByXmlIds.get(((Odconnectoid)xmlConnectoid).getNoderef());
            if (accessNode == null) {
                throw new PlanItException(String.format("provided accessNode XML id %s is invalid given available nodes in network when parsing transfer connectoid %s", ((Odconnectoid)xmlConnectoid).getNoderef(), xmlConnectoid.getId()));
            }
            theConnectoid = this.zoning.connectoids.registerNew(accessNode);
        } else if (xmlConnectoid instanceof XMLElementTransferZoneAccess.XMLElementTransferConnectoid) {
            XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid = (XMLElementTransferZoneAccess.XMLElementTransferConnectoid)xmlConnectoid;
            if (linkSegmentsByXmlId == null) {
                throw new PlanItException(String.format("provided link segments by XML id is null when parsing XML transfer connectoid %s", xmlConnectoid.getId()));
            }
            String xmlLinkSegmentRef = xmlTransferConnectoid.getLsref();
            MacroscopicLinkSegment linkSegment = linkSegmentsByXmlId.get(xmlLinkSegmentRef);
            if (linkSegment == null) {
                throw new PlanItException(String.format("provided link segment XML id %s is invalid given available link segments in network when parsing transfer connectoid %s", xmlLinkSegmentRef, xmlConnectoid.getId()));
            }
            theConnectoid = this.zoning.connectoids.registerNew(linkSegment);
            if (xmlTransferConnectoid.getLoc() == Connectoidnodelocationtype.UPSTREAM) {
                ((DirectedConnectoid)theConnectoid).setNodeAccessDownstream(false);
            }
        }
        if (xmlConnectoid.getId() != null && !xmlConnectoid.getId().isBlank()) {
            theConnectoid.setXmlId(xmlConnectoid.getId());
        }
        if (xmlConnectoid.getExternalid() != null && !xmlConnectoid.getExternalid().isBlank()) {
            theConnectoid.setExternalId(xmlConnectoid.getExternalid());
        }
        if (xmlConnectoid.getName() != null && !xmlConnectoid.getName().isBlank()) {
            theConnectoid.setName(xmlConnectoid.getName());
        }
        theConnectoid.setType(PlanitZoningReader.parseConnectoidType(xmlConnectoid.getType()));
        return theConnectoid;
    }

    private void populateTransferZones(Intermodaltype xmlInterModal) throws PlanItException {
        if (xmlInterModal.getTransferzones() == null) {
            return;
        }
        List<XMLElementTransferZones.XMLElementTransferZone> xmlTransferZones = xmlInterModal.getTransferzones().getZone();
        for (XMLElementTransferZones.XMLElementTransferZone xmlTransferzone : xmlTransferZones) {
            TransferZone transferZone = this.parseBaseZone(this.zoning.transferZones, xmlTransferzone.getId(), xmlTransferzone.getExternalid(), xmlTransferzone.getCentroid());
            transferZone.setTransferZoneType(PlanitZoningReader.parseTransferZoneType(xmlTransferzone.getType()));
            PlanitZoningReader.populateZoneGeometry(transferZone, xmlTransferzone.getPolygon());
        }
    }

    private void populateTransferZoneAccess(Modes modes, Intermodaltype xmlInterModal, Map<String, MacroscopicLinkSegment> linkSegmentsByXmlId) throws PlanItException {
        if (xmlInterModal.getTransferzoneaccess() == null) {
            return;
        }
        HashMap modesByXmlId = new HashMap();
        modes.forEach(mode -> modesByXmlId.put(mode.getXmlId(), mode));
        List<XMLElementTransferZoneAccess.XMLElementTransferConnectoid> xmlTransferConnectoids = xmlInterModal.getTransferzoneaccess().getConnectoid();
        for (XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid : xmlTransferConnectoids) {
            DirectedConnectoid connectoid = (DirectedConnectoid)this.parseBaseConnectoid(xmlTransferConnectoid, null, linkSegmentsByXmlId);
            String modesRef = xmlTransferConnectoid.getModes();
            HashSet<Mode> allowedModes = null;
            boolean implicitAllModesAllowed = true;
            if (modesRef != null && !modesRef.isBlank()) {
                implicitAllModesAllowed = false;
                allowedModes = new HashSet<Mode>();
                for (String string : List.of(modesRef.split(","))) {
                    Mode mode2 = (Mode)modesByXmlId.get(string);
                    if (mode2 == null) {
                        LOGGER.warning(String.format("invalid mode %s referenced by transfer connectoid %s", string, connectoid.getXmlId()));
                        continue;
                    }
                    allowedModes.add(mode2);
                }
            }
            String TransferzoneRefs = xmlTransferConnectoid.getTzrefs();
            for (String xmlTransferZoneRef : List.of(TransferzoneRefs.split(","))) {
                Zone accessZone = this.settings.getMapToIndexZoneByXmlIds().get(xmlTransferZoneRef);
                if (accessZone == null) {
                    LOGGER.warning(String.format("invalid transfer zone %s referenced by transfer connectoid %s", xmlTransferZoneRef, connectoid.getXmlId()));
                    continue;
                }
                connectoid.addAccessZone(accessZone);
                if (implicitAllModesAllowed) continue;
                allowedModes.forEach(allowedMode -> connectoid.addAllowedMode(accessZone, (Mode)allowedMode));
            }
            PlanitZoningReader.populateConnectoidToZoneLengths(connectoid, xmlTransferConnectoid, connectoid.getAccessNode().getPosition(), this.jtsUtils);
            Connectoid connectoid2 = this.settings.getMapToIndexConnectoidsByXmlIds().put(connectoid.getXmlId(), connectoid);
            if (connectoid2 == null) continue;
            throw new PlanItException(String.format("(od/transfer) connectoid id %s used not unique across project, thsi is not allowed", connectoid.getXmlId()));
        }
    }

    protected void setZoning(Zoning zoning) {
        this.zoning = zoning;
    }

    protected void populateODZones(Map<String, Node> nodesByXmlIds) throws PlanItException {
        for (XMLElementZones.Zone xmlZone : ((XMLElementMacroscopicZoning)this.getXmlRootElement()).getZones().getZone()) {
            OdZone zone = this.parseBaseZone(this.zoning.odZones, xmlZone.getId(), xmlZone.getExternalid(), xmlZone.getCentroid());
            PlanitZoningReader.populateZoneGeometry(zone, xmlZone.getPolygon());
            List<XMLElementConnectoid> xmlConnectoids = xmlZone.getConnectoids().getConnectoid();
            for (XMLElementConnectoid xmlConnectoid : xmlConnectoids) {
                Odconnectoid xmlOdConnectoid = (Odconnectoid)xmlConnectoid.getValue();
                UndirectedConnectoid connectoid = (UndirectedConnectoid)this.parseBaseConnectoid(xmlOdConnectoid, nodesByXmlIds, null);
                connectoid.addAccessZone(zone);
                PlanitZoningReader.populateConnectoidToZoneLengths(connectoid, xmlOdConnectoid, connectoid.getAccessNode().getPosition(), this.jtsUtils);
            }
        }
    }

    protected void populateIntermodal(Modes modes, Map<String, MacroscopicLinkSegment> linkSegmentsByXmlId) throws PlanItException {
        if (((XMLElementMacroscopicZoning)this.getXmlRootElement()).getIntermodal() == null) {
            return;
        }
        Intermodaltype xmlInterModal = ((XMLElementMacroscopicZoning)this.getXmlRootElement()).getIntermodal();
        this.populateTransferZones(xmlInterModal);
        this.populateTransferZoneAccess(modes, xmlInterModal, linkSegmentsByXmlId);
    }

    public PlanitZoningReader(String pathDirectory, String xmlFileExtension, Zoning zoning) throws PlanItException {
        super(XMLElementMacroscopicZoning.class, pathDirectory, xmlFileExtension);
        this.setZoning(zoning);
    }

    public PlanitZoningReader(XMLElementMacroscopicZoning xmlMacroscopicZoning, Zoning zoning) throws PlanItException {
        super(xmlMacroscopicZoning);
        this.setZoning(zoning);
    }

    public Zoning read(InfrastructureNetwork network, Map<String, Node> nodesByXmlId, Map<String, MacroscopicLinkSegment> linkSegmentsByXmlId) throws PlanItException {
        try {
            this.initialiseAndParseXmlRootElement();
            this.jtsUtils = new PlanitJtsUtils(network.getCoordinateReferenceSystem());
            this.populateODZones(nodesByXmlId);
            this.populateIntermodal(network.modes, linkSegmentsByXmlId);
            this.clearXmlContent();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating zoning in PLANitIO", e);
        }
        return this.zoning;
    }

    public PlanitZoningReaderSettings getSettings() {
        return this.settings;
    }
}

