/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.converter;

import java.util.function.Function;
import java.util.logging.Logger;
import org.planit.network.converter.IdMapperType;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.ExternalIdable;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;

public class IdMapperFunctionFactory {
    private static final Logger LOGGER = Logger.getLogger(IdMapperFunctionFactory.class.getCanonicalName());

    protected static <T extends ExternalIdable> Function<T, String> createIdMappingFunction(Class<T> clazz, IdMapperType idMapper) throws PlanItException {
        switch (idMapper) {
            case ID: {
                return instance -> Long.toString(instance.getId());
            }
            case EXTERNAL_ID: {
                return instance -> {
                    if (instance.hasExternalId()) {
                        return instance.getExternalId();
                    }
                    if (instance.hasXmlId()) {
                        return instance.getXmlId();
                    }
                    return String.format("%s", instance.getId());
                };
            }
            case DEFAULT: {
                return instance -> {
                    if (instance.hasXmlId()) {
                        return instance.getXmlId();
                    }
                    if (instance.hasExternalId()) {
                        return instance.getExternalId();
                    }
                    return String.format("%s", instance.getId());
                };
            }
        }
        throw new PlanItException(String.format("unknown id mapping type found for %s %s", clazz.getName(), idMapper.toString()));
    }

    public static Function<Node, String> createNodeIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Node.class, idMapper);
    }

    public static Function<Link, String> createLinkIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Link.class, idMapper);
    }

    public static Function<MacroscopicLinkSegmentType, String> createLinkSegmentTypeIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicLinkSegmentType.class, idMapper);
    }

    public static Function<MacroscopicLinkSegment, String> createLinkSegmentIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        switch (idMapper) {
            case EXTERNAL_ID: {
                return macroscopicLinkSegment -> {
                    if (macroscopicLinkSegment.getExternalId() != null) {
                        return String.format("%s", macroscopicLinkSegment.getExternalId());
                    }
                    if (macroscopicLinkSegment.getParentLink() != null && macroscopicLinkSegment.getParentLink().getExternalId() != null) {
                        return String.format("%s_%s", macroscopicLinkSegment.getParentLink().getExternalId(), macroscopicLinkSegment.isDirectionAb() ? "ab" : "ba");
                    }
                    LOGGER.severe(String.format("unable to map id for link, PLANit link segment external id not available or parent link missing (id:%d)", macroscopicLinkSegment.getId()));
                    return "-1";
                };
            }
        }
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicLinkSegment.class, idMapper);
    }

    public static Function<Mode, String> createModeIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Mode.class, idMapper);
    }
}

