/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.macroscopic.physical;

import java.util.Set;
import java.util.logging.Logger;
import org.planit.network.physical.LinkSegmentImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;

public class MacroscopicLinkSegmentImpl
extends LinkSegmentImpl
implements MacroscopicLinkSegment {
    private static final long serialVersionUID = 4574164258794764853L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    protected MacroscopicLinkSegmentType linkSegmentType = null;

    protected MacroscopicLinkSegmentImpl(IdGroupingToken groupId, Link parentLink, boolean directionAB) throws PlanItException {
        super(groupId, parentLink, directionAB);
    }

    protected MacroscopicLinkSegmentImpl(MacroscopicLinkSegmentImpl macroscopicLinkSegmentImpl) {
        super(macroscopicLinkSegmentImpl);
        this.setLinkSegmentType(macroscopicLinkSegmentImpl.getLinkSegmentType());
    }

    @Override
    public int hashCode() {
        return this.idHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.idEquals(obj);
    }

    @Override
    public double computeCapacityPcuH() {
        return this.getLinkSegmentType().getCapacityPerLane() * (double)this.getNumberOfLanes();
    }

    @Override
    public double computeFreeFlowTravelTime(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getParentLink().getLengthKm() / this.getModelledSpeedLimitKmH(mode);
    }

    @Override
    public double getModelledSpeedLimitKmH(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return 0.0;
        }
        double modeSpeedLimit = mode.getMaximumSpeedKmH();
        double segmentTypeMaximumSpeed = this.getLinkSegmentType().getModeProperties(mode).getMaximumSpeedKmH();
        return Math.min(this.getPhysicalSpeedLimitKmH(), Math.min(modeSpeedLimit, segmentTypeMaximumSpeed));
    }

    @Override
    public boolean isModeAllowed(Mode mode) {
        return this.linkSegmentType.isModeAvailable(mode);
    }

    @Override
    public Set<Mode> getAllowedModes() {
        return this.linkSegmentType.getAvailableModes();
    }

    @Override
    public void setLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType) {
        this.linkSegmentType = linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentType getLinkSegmentType() {
        return this.linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentImpl clone() {
        return new MacroscopicLinkSegmentImpl(this);
    }
}

