/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.macroscopic.physical;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicLinkSegmentTypeImpl
implements MacroscopicLinkSegmentType {
    protected long id;
    private String externalId;
    private String xmlId;
    protected String name;
    protected final double capacityPerLane;
    protected final double maximumDensityPerLane;
    protected Map<Mode, MacroscopicModeProperties> modeProperties;

    protected void setId(long id) {
        this.id = id;
    }

    protected static long generateMacroscopicLinkSegmentTypeId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, MacroscopicLinkSegmentType.class);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, double capacityPerLane, double maximumDensityPerLane) {
        this.setId(MacroscopicLinkSegmentTypeImpl.generateMacroscopicLinkSegmentTypeId(groupId));
        this.setName(name);
        this.capacityPerLane = capacityPerLane;
        this.maximumDensityPerLane = maximumDensityPerLane;
        this.modeProperties = new HashMap<Mode, MacroscopicModeProperties>();
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, double capacityPerLane, double maximumDensityPerLane, Map<Mode, MacroscopicModeProperties> modeProperties) {
        this(groupId, name, capacityPerLane, maximumDensityPerLane);
        if (modeProperties != null) {
            this.setModeProperties(modeProperties);
        }
    }

    protected MacroscopicLinkSegmentTypeImpl(MacroscopicLinkSegmentTypeImpl other) {
        this.setId(other.getId());
        this.setXmlId(other.getXmlId());
        this.setExternalId(other.getExternalId());
        this.setName(other.getName());
        this.capacityPerLane = other.getCapacityPerLane();
        this.maximumDensityPerLane = other.getMaximumDensityPerLane();
        this.modeProperties = new HashMap<Mode, MacroscopicModeProperties>();
        other.modeProperties.forEach((mode, properties) -> this.modeProperties.put((Mode)mode, properties.clone()));
    }

    public int hashCode() {
        return this.idHashCode();
    }

    public boolean equals(Object obj) {
        return this.idEquals(obj);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getCapacityPerLane() {
        return this.capacityPerLane;
    }

    @Override
    public double getMaximumDensityPerLane() {
        return this.maximumDensityPerLane;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    @Override
    public MacroscopicModeProperties getModeProperties(Mode mode) {
        if (this.modeProperties.containsKey(mode)) {
            return this.modeProperties.get(mode);
        }
        return null;
    }

    @Override
    public void setModeProperties(Map<Mode, MacroscopicModeProperties> modeProperties) {
        this.modeProperties = modeProperties;
    }

    @Override
    public MacroscopicModeProperties addModeProperties(Mode mode, MacroscopicModeProperties properties) {
        return this.modeProperties.put(mode, properties);
    }

    @Override
    public boolean isModeAvailable(Mode mode) {
        return this.modeProperties.containsKey(mode);
    }

    @Override
    public Set<Mode> getAvailableModes() {
        return this.modeProperties.keySet();
    }

    @Override
    public MacroscopicLinkSegmentType clone() {
        return new MacroscopicLinkSegmentTypeImpl(this);
    }

    @Override
    public MacroscopicModeProperties removeModeProperties(Mode toBeRemovedMode) {
        return this.modeProperties.remove(toBeRemovedMode);
    }
}

