/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.macroscopic.physical;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetworkBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentTypes;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicLinkSegmentTypesImpl
implements MacroscopicLinkSegmentTypes {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentTypesImpl.class.getCanonicalName());
    protected final MacroscopicPhysicalNetworkBuilder<?, ?, MacroscopicLinkSegment> networkBuilder;
    protected Map<Long, MacroscopicLinkSegmentType> macroscopicLinkSegmentTypeByIdMap = new TreeMap<Long, MacroscopicLinkSegmentType>();

    public MacroscopicLinkSegmentTypesImpl(MacroscopicPhysicalNetworkBuilder<?, ?, MacroscopicLinkSegment> networkBuilder) {
        this.networkBuilder = networkBuilder;
    }

    @Override
    public MacroscopicLinkSegmentType createAndRegisterNew(String name, double capacityPcuPerHour, double maximumDensityPcuPerKm, Map<Mode, MacroscopicModeProperties> modeProperties) throws PlanItException {
        MacroscopicLinkSegmentType linkSegmentType = this.networkBuilder.createLinkSegmentType(name, capacityPcuPerHour, maximumDensityPcuPerKm, modeProperties);
        this.register(linkSegmentType);
        return linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentType createAndRegisterNew(String name, double capacityPcuPerHour, double maximumDensityPcuPerKm) throws PlanItException {
        MacroscopicLinkSegmentType linkSegmentType = this.networkBuilder.createLinkSegmentType(name, capacityPcuPerHour, maximumDensityPcuPerKm);
        this.register(linkSegmentType);
        return linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentType register(MacroscopicLinkSegmentType linkSegmentType) {
        return this.macroscopicLinkSegmentTypeByIdMap.put(linkSegmentType.getId(), linkSegmentType);
    }

    @Override
    public MacroscopicLinkSegmentType registerUniqueCopyOf(MacroscopicLinkSegmentType linkSegmentTypeToCopy) {
        MacroscopicLinkSegmentType linkSegmentType = this.networkBuilder.createUniqueCopyOf(linkSegmentTypeToCopy);
        this.register(linkSegmentType);
        return linkSegmentType;
    }

    @Override
    public int size() {
        return this.macroscopicLinkSegmentTypeByIdMap.size();
    }

    @Override
    public MacroscopicLinkSegmentType get(long id) {
        return this.macroscopicLinkSegmentTypeByIdMap.get(id);
    }

    @Override
    public MacroscopicLinkSegmentType getByXmlId(String xmlId) {
        for (MacroscopicLinkSegmentType macroscopicLinkSegmentType : this.macroscopicLinkSegmentTypeByIdMap.values()) {
            if (!xmlId.equals(macroscopicLinkSegmentType.getXmlId())) continue;
            return macroscopicLinkSegmentType;
        }
        return null;
    }

    @Override
    public Set<MacroscopicLinkSegmentType> setOf() {
        return Set.copyOf(this.macroscopicLinkSegmentTypeByIdMap.values());
    }

    @Override
    public Iterator<MacroscopicLinkSegmentType> iterator() {
        return this.macroscopicLinkSegmentTypeByIdMap.values().iterator();
    }

    @Override
    public MacroscopicLinkSegmentType getFirst() {
        return this.iterator().next();
    }
}

