/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.macroscopic.physical;

import java.util.Map;
import java.util.logging.Logger;
import org.planit.network.macroscopic.physical.MacroscopicLinkSegmentImpl;
import org.planit.network.macroscopic.physical.MacroscopicLinkSegmentTypeImpl;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetworkBuilder;
import org.planit.network.physical.PhysicalNetworkBuilderImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.EdgeSegments;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicPhysicalNetworkBuilderImpl
implements MacroscopicPhysicalNetworkBuilder<Node, Link, MacroscopicLinkSegment> {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicPhysicalNetworkBuilderImpl.class.getCanonicalName());
    protected final PhysicalNetworkBuilderImpl physicalNetworkBuilder;

    public MacroscopicPhysicalNetworkBuilderImpl(IdGroupingToken groupId) {
        this.physicalNetworkBuilder = new PhysicalNetworkBuilderImpl(groupId);
    }

    @Override
    public MacroscopicLinkSegmentType createLinkSegmentType(String name, double capacity, double maximumDensity, Map<Mode, MacroscopicModeProperties> modeProperties) {
        return new MacroscopicLinkSegmentTypeImpl(this.getIdGroupingToken(), name, capacity, maximumDensity, modeProperties);
    }

    @Override
    public MacroscopicLinkSegmentType createLinkSegmentType(String name, double capacity, double maximumDensity) {
        return new MacroscopicLinkSegmentTypeImpl(this.getIdGroupingToken(), name, capacity, maximumDensity);
    }

    @Override
    public MacroscopicLinkSegment createEdgeSegment(DirectedEdge parentLink, boolean directionAB) throws PlanItException {
        if (parentLink instanceof Link) {
            return new MacroscopicLinkSegmentImpl(this.getIdGroupingToken(), (Link)parentLink, directionAB);
        }
        throw new PlanItException("passed in parent edge is not of type Link, incompatible with Macroscopic network builder");
    }

    @Override
    public Node createVertex() {
        return this.physicalNetworkBuilder.createVertex();
    }

    @Override
    public Link createEdge(Vertex nodeA, Vertex nodeB, double length) throws PlanItException {
        return this.physicalNetworkBuilder.createEdge(nodeA, nodeB, length);
    }

    @Override
    public void setIdGroupingToken(IdGroupingToken groupId) {
        this.physicalNetworkBuilder.setIdGroupingToken(groupId);
    }

    @Override
    public IdGroupingToken getIdGroupingToken() {
        return this.physicalNetworkBuilder.getIdGroupingToken();
    }

    @Override
    public void recreateIds(EdgeSegments<? extends MacroscopicLinkSegment> macroscopicinkSegments) {
        this.physicalNetworkBuilder.recreateIds((EdgeSegments<? extends LinkSegment>)macroscopicinkSegments);
    }

    @Override
    public void recreateIds(Edges<? extends Link> links) {
        this.physicalNetworkBuilder.recreateIds(links);
    }

    @Override
    public void recreateIds(Vertices<? extends Node> nodes) {
        this.physicalNetworkBuilder.recreateIds(nodes);
    }

    @Override
    public Link createUniqueCopyOf(Link linkToCopy) {
        return this.physicalNetworkBuilder.createUniqueCopyOf(linkToCopy);
    }

    @Override
    public MacroscopicLinkSegment createUniqueCopyOf(MacroscopicLinkSegment linkSegmentToCopy, DirectedEdge parentEdge) {
        return (MacroscopicLinkSegmentImpl)this.physicalNetworkBuilder.createUniqueCopyOf(linkSegmentToCopy, parentEdge);
    }

    @Override
    public MacroscopicLinkSegmentType createUniqueCopyOf(MacroscopicLinkSegmentType linkSegmentTypeToCopy) {
        if (linkSegmentTypeToCopy instanceof MacroscopicLinkSegmentTypeImpl) {
            MacroscopicLinkSegmentTypeImpl copy = (MacroscopicLinkSegmentTypeImpl)linkSegmentTypeToCopy.clone();
            copy.setId(MacroscopicLinkSegmentTypeImpl.generateMacroscopicLinkSegmentTypeId(this.getIdGroupingToken()));
            return copy;
        }
        LOGGER.severe("passed in link segment type is not an instance created by this builder, incompatible for creating a copy");
        return null;
    }
}

