/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.geo.PlanitJtsUtils;
import org.planit.geo.PlanitOpenGisUtils;
import org.planit.graph.DirectedGraphImpl;
import org.planit.graph.GraphModifier;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureLayerImpl;
import org.planit.network.physical.LinkSegmentsImpl;
import org.planit.network.physical.LinksImpl;
import org.planit.network.physical.NodesImpl;
import org.planit.network.physical.PhysicalNetworkBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedGraph;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.LinkSegments;
import org.planit.utils.network.physical.Links;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.Nodes;

public class PhysicalNetwork<N extends Node, L extends Link, LS extends LinkSegment>
extends InfrastructureLayerImpl
implements InfrastructureLayer {
    private static final long serialVersionUID = -2794450367185361960L;
    private static final Logger LOGGER = Logger.getLogger(PhysicalNetwork.class.getCanonicalName());
    private final PhysicalNetworkBuilder<N, L, LS> networkBuilder;
    private final DirectedGraph<N, L, LS> graph;
    public final Links<L> links;
    public final LinkSegments<LS> linkSegments;
    public final Nodes<N> nodes;

    protected DirectedGraph<N, L, LS> getGraph() {
        return this.graph;
    }

    protected PhysicalNetworkBuilder<N, L, LS> getNetworkBuilder() {
        return this.networkBuilder;
    }

    public final Links<L> getLinks() {
        return this.links;
    }

    public final LinkSegments<LS> getLinkSegments() {
        return this.linkSegments;
    }

    public final Nodes<N> getNodes() {
        return this.nodes;
    }

    public PhysicalNetwork(IdGroupingToken tokenId, PhysicalNetworkBuilder<N, L, LS> networkBuilder) {
        super(tokenId);
        this.networkBuilder = networkBuilder;
        this.graph = new DirectedGraphImpl<N, L, LS>(tokenId, networkBuilder);
        this.nodes = new NodesImpl(this.getGraph().getVertices());
        this.links = new LinksImpl(this.getGraph().getEdges());
        this.linkSegments = new LinkSegmentsImpl<LS>(this.getGraph().getEdgeSegments());
    }

    public IdGroupingToken getNetworkIdGroupingToken() {
        return ((DirectedGraphImpl)this.graph).getGraphIdGroupingToken();
    }

    @Override
    public void transform(CoordinateReferenceSystem fromCoordinateReferenceSystem, CoordinateReferenceSystem toCoordinateReferenceSystem) throws PlanItException {
        try {
            this.getGraph().transformGeometries(PlanitOpenGisUtils.findMathTransform(fromCoordinateReferenceSystem, toCoordinateReferenceSystem));
        }
        catch (Exception e) {
            PlanitOpenGisUtils.findMathTransform(fromCoordinateReferenceSystem, toCoordinateReferenceSystem);
            throw new PlanItException(String.format("%s error during transformation of network %s CRS", InfrastructureLayer.createLayerLogPrefix(this), this.getXmlId()), e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty() && this.links.isEmpty() && this.linkSegments.isEmpty();
    }

    @Override
    public void removeDanglingSubnetworks() throws PlanItException {
        this.removeDanglingSubnetworks(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    @Override
    public void removeDanglingSubnetworks(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) throws PlanItException {
        LOGGER.info(String.format("%s Removing dangling subnetworks with less than %s vertices", InfrastructureLayer.createLayerLogPrefix(this), belowSize != Integer.MAX_VALUE ? String.valueOf(belowSize) : "infinite"));
        if (aboveSize != Integer.MAX_VALUE) {
            LOGGER.info(String.format("%s Removing dangling subnetworks with more than %s vertices", InfrastructureLayer.createLayerLogPrefix(this), String.valueOf(aboveSize)));
        }
        LOGGER.info(String.format("%s Original number of nodes %d, links %d, link segments %d", InfrastructureLayer.createLayerLogPrefix(this), this.nodes.size(), this.links.size(), this.linkSegments.size()));
        if (this.getGraph() instanceof GraphModifier) {
            ((GraphModifier)((Object)this.getGraph())).removeDanglingSubGraphs(belowSize, aboveSize, alwaysKeepLargest);
        } else {
            LOGGER.severe(String.format("%s Dangling subnetworks can only be removed when network supports graph modifications, this is not the case, call ignored", InfrastructureLayer.createLayerLogPrefix(this)));
        }
        LOGGER.info(String.format("%s remaining number of nodes %d, links %d, link segments %d", InfrastructureLayer.createLayerLogPrefix(this), this.nodes.size(), this.links.size(), this.linkSegments.size()));
    }

    public Map<Long, Set<L>> breakLinkAt(L linkToBreak, N nodeToBreakAt, CoordinateReferenceSystem crs) throws PlanItException {
        return this.breakLinksAt(List.of(linkToBreak), nodeToBreakAt, crs);
    }

    public Map<Long, Set<L>> breakLinksAt(List<? extends L> linksToBreak, N nodeToBreakAt, CoordinateReferenceSystem crs) throws PlanItException {
        if (this.getGraph() instanceof GraphModifier) {
            Map<Long, Set<L>> affectedLinks = ((GraphModifier)((Object)this.getGraph())).breakEdgesAt(linksToBreak, nodeToBreakAt);
            PlanitJtsUtils geoUtils = new PlanitJtsUtils(crs);
            for (Map.Entry<Long, Set<L>> brokenLinks : affectedLinks.entrySet()) {
                for (Link brokenLink : brokenLinks.getValue()) {
                    LineString updatedGeometry = null;
                    if (brokenLink.getNodeA().equals(nodeToBreakAt)) {
                        updatedGeometry = PlanitJtsUtils.createCopyWithoutCoordinatesBefore(nodeToBreakAt.getPosition(), brokenLink.getGeometry());
                    } else if (brokenLink.getNodeB().equals(nodeToBreakAt)) {
                        updatedGeometry = PlanitJtsUtils.createCopyWithoutCoordinatesAfter(nodeToBreakAt.getPosition(), brokenLink.getGeometry());
                    } else {
                        LOGGER.warning(String.format("%s unable to locate node to break at (%s) for broken link %s (id:%d)", InfrastructureLayer.createLayerLogPrefix(this), nodeToBreakAt.getPosition().toString(), brokenLink.getExternalId(), brokenLink.getId()));
                    }
                    brokenLink.setGeometry(updatedGeometry);
                    brokenLink.setLengthKm(geoUtils.getDistanceInKilometres(updatedGeometry));
                }
            }
            return affectedLinks;
        }
        LOGGER.severe(String.format("%s Dangling subnetworks can only be removed when network supports graph modifications, this is not the case, call ignored", InfrastructureLayer.createLayerLogPrefix(this)));
        return null;
    }

    @Override
    public boolean validate() {
        boolean isValid = this.graph.validate();
        for (Link link : this.links) {
            isValid = isValid && link.validate();
        }
        for (LinkSegment linkSegment : this.linkSegments) {
            isValid = isValid && linkSegment.validate();
        }
        for (Node node : this.nodes) {
            isValid = isValid && node.validate();
        }
        return isValid;
    }

    @Override
    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s#supported modes: %s", prefix, this.getSupportedModes().stream().map(mode -> mode.getXmlId()).collect(Collectors.joining(", "))));
        LOGGER.info(String.format("%s#links: %d", prefix, this.links.size()));
        LOGGER.info(String.format("%s#link segments: %d", prefix, this.linkSegments.size()));
        LOGGER.info(String.format("%s#nodes: %d", prefix, this.nodes.size()));
    }
}

