/*
 * Decompiled with CFR 0.152.
 */
package org.planit.od;

import org.planit.od.ODDataIterator;
import org.planit.utils.zoning.Zone;
import org.planit.utils.zoning.Zones;

public abstract class ODDataIteratorImpl<T>
implements ODDataIterator<T> {
    protected int originId;
    protected int destinationId;
    protected int currentLocation;
    protected Zones<?> zones;

    protected void updateCurrentLocation() {
        this.originId = this.currentLocation / this.zones.size();
        this.destinationId = this.currentLocation % this.zones.size();
        ++this.currentLocation;
    }

    public ODDataIteratorImpl(Zones<?> zones) {
        this.zones = zones;
        this.currentLocation = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentLocation < this.zones.size() * this.zones.size();
    }

    @Override
    public Zone getCurrentOrigin() {
        return this.zones.get(this.originId);
    }

    @Override
    public Zone getCurrentDestination() {
        return this.zones.get(this.destinationId);
    }
}

