/*
 * Decompiled with CFR 0.152.
 */
package org.planit.od.odpath;

import org.planit.od.ODDataImpl;
import org.planit.od.odpath.ODPathIterator;
import org.planit.path.Path;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.zoning.Zone;
import org.planit.utils.zoning.Zones;

public class ODPathMatrix
extends ODDataImpl<Path> {
    private final Path[][] matrixContents;
    protected final long id;

    public ODPathMatrix(IdGroupingToken groupId, Zones<?> zones) {
        super(zones);
        this.id = IdGenerator.generateId(groupId, ODPathMatrix.class);
        int numberOfTravelAnalysisZones = zones.size();
        this.matrixContents = new Path[numberOfTravelAnalysisZones][numberOfTravelAnalysisZones];
    }

    @Override
    public Path getValue(Zone origin, Zone destination) {
        int originId = (int)origin.getId();
        int destinationId = (int)destination.getId();
        return this.matrixContents[originId][destinationId];
    }

    @Override
    public void setValue(Zone origin, Zone destination, Path path) {
        int originId = (int)origin.getId();
        int destinationId = (int)destination.getId();
        this.matrixContents[originId][destinationId] = path;
    }

    public ODPathIterator iterator() {
        return new ODPathIterator(this.matrixContents, this.zones);
    }

    public long getId() {
        return this.id;
    }
}

