/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import java.util.logging.Logger;
import org.locationtech.jts.geom.Point;
import org.planit.assignment.TrafficAssignment;
import org.planit.network.InfrastructureLayer;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.output.adapter.LinkOutputTypeAdapter;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.enums.OutputType;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.Vertex;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.LinkSegments;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;

public abstract class LinkOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements LinkOutputTypeAdapter {
    private static final Logger LOGGER = Logger.getLogger(LinkOutputTypeAdapterImpl.class.getCanonicalName());

    private String getVertexLocationAsString(Vertex vertex) {
        Point position = vertex.getPosition();
        if (position == null) {
            return "Not Specified";
        }
        return position.getCoordinate().x + "-" + position.getCoordinate().y;
    }

    protected double getCapacityPerLane(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to calculate capacity per link across an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        return macroscopicLinkSegment.getLinkSegmentType().getCapacityPerLane();
    }

    protected String getLinkType(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to find the Link Type of an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        return macroscopicLinkSegment.getLinkSegmentType().getName();
    }

    protected double getMaximumDensity(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to density per lane across an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        return macroscopicLinkSegment.getLinkSegmentType().getMaximumDensityPerLane();
    }

    protected String getDownstreamNodeExternalId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getDownstreamVertex()).getExternalId();
    }

    protected String getDownstreamNodeXmlId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getDownstreamVertex()).getXmlId();
    }

    protected long getDownstreamNodeId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getDownstreamVertex()).getId();
    }

    protected Object getDownstreamNodeLocation(LinkSegment linkSegment) throws PlanItException {
        DirectedVertex downstreamVertex = linkSegment.getDownstreamVertex();
        return this.getVertexLocationAsString(downstreamVertex);
    }

    protected double getLength(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getParentLink().getLengthKm();
    }

    protected String getLinkSegmentExternalId(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getExternalId();
    }

    protected String getLinkSegmentXmlId(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getXmlId();
    }

    protected long getLinkSegmentId(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getId();
    }

    protected double getMaximumSpeed(LinkSegment linkSegment, Mode mode) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to read maximum speed of an object which is not a MacroscopicLinkSegment");
        return ((MacroscopicLinkSegment)linkSegment).getModelledSpeedLimitKmH(mode);
    }

    protected int getNumberOfLanes(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getNumberOfLanes();
    }

    protected String getUpstreamNodeExternalId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getUpstreamVertex()).getExternalId();
    }

    protected String getUpstreamNodeXmlId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getUpstreamVertex()).getXmlId();
    }

    protected Object getUpstreamNodeLocation(LinkSegment linkSegment) throws PlanItException {
        DirectedVertex upstreamVertex = linkSegment.getUpstreamVertex();
        return this.getVertexLocationAsString(upstreamVertex);
    }

    protected long getUpstreamNodeId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getUpstreamVertex()).getId();
    }

    public LinkOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Long getInfrastructureLayerIdForMode(Mode mode) {
        InfrastructureLayer networkLayer = this.trafficAssignment.getTransportNetwork().getInfrastructureNetwork().getInfrastructureLayerByMode(mode);
        return networkLayer != null ? Long.valueOf(networkLayer.getId()) : null;
    }

    @Override
    public LinkSegments<? extends LinkSegment> getPhysicalLinkSegments(long infrastructureLayerId) {
        InfrastructureLayer networkLayer = this.trafficAssignment.getTransportNetwork().getInfrastructureNetwork().infrastructureLayers.get(infrastructureLayerId);
        if (networkLayer instanceof MacroscopicPhysicalNetwork) {
            return ((MacroscopicPhysicalNetwork)networkLayer).linkSegments;
        }
        LOGGER.warning(String.format("cannot collect physical link segments from infrastructure layer %s, as it is not a macroscopic physical network layer", networkLayer.getXmlId()));
        return null;
    }

    @Override
    public Object getLinkOutputPropertyValue(OutputProperty outputProperty, LinkSegment linkSegment, Mode mode, TimePeriod timePeriod, double timeUnitMultiplier) {
        try {
            Object obj = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case CAPACITY_PER_LANE: {
                    return this.getCapacityPerLane(linkSegment);
                }
                case DOWNSTREAM_NODE_EXTERNAL_ID: {
                    return this.getDownstreamNodeExternalId(linkSegment);
                }
                case DOWNSTREAM_NODE_XML_ID: {
                    return this.getDownstreamNodeXmlId(linkSegment);
                }
                case DOWNSTREAM_NODE_ID: {
                    return this.getDownstreamNodeId(linkSegment);
                }
                case DOWNSTREAM_NODE_LOCATION: {
                    return this.getDownstreamNodeLocation(linkSegment);
                }
                case LENGTH: {
                    return this.getLength(linkSegment);
                }
                case LINK_SEGMENT_EXTERNAL_ID: {
                    return this.getLinkSegmentExternalId(linkSegment);
                }
                case LINK_SEGMENT_XML_ID: {
                    return this.getLinkSegmentXmlId(linkSegment);
                }
                case LINK_SEGMENT_ID: {
                    return this.getLinkSegmentId(linkSegment);
                }
                case MAXIMUM_DENSITY: {
                    return this.getMaximumDensity(linkSegment);
                }
                case MAXIMUM_SPEED: {
                    return this.getMaximumSpeed(linkSegment, mode);
                }
                case NUMBER_OF_LANES: {
                    return this.getNumberOfLanes(linkSegment);
                }
                case UPSTREAM_NODE_EXTERNAL_ID: {
                    return this.getUpstreamNodeExternalId(linkSegment);
                }
                case UPSTREAM_NODE_XML_ID: {
                    return this.getUpstreamNodeXmlId(linkSegment);
                }
                case UPSTREAM_NODE_ID: {
                    return this.getUpstreamNodeId(linkSegment);
                }
                case UPSTREAM_NODE_LOCATION: {
                    return this.getUpstreamNodeLocation(linkSegment);
                }
                case LINK_TYPE: {
                    return this.getLinkType(linkSegment);
                }
            }
            return null;
        }
        catch (PlanItException e) {
            return e;
        }
    }
}

