/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.planit.output.configuration.LinkOutputTypeConfiguration;
import org.planit.output.configuration.ODOutputTypeConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.configuration.PathOutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.utils.exceptions.PlanItException;

public class OutputConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OutputConfiguration.class.getCanonicalName());
    protected boolean persistOnlyFinalIteration = true;
    protected boolean persistZeroFlow = false;
    protected final Map<OutputType, OutputTypeConfiguration> outputTypeConfigurations = new HashMap<OutputType, OutputTypeConfiguration>();
    public static final boolean PERSIST_ONLY_FINAL_ITERATION = true;
    public static final boolean PERSIST_ZERO_FLOW = false;

    public Set<OutputType> getActivatedOutputTypes() {
        return this.outputTypeConfigurations.keySet();
    }

    public Collection<OutputTypeConfiguration> getActivatedOutputTypeConfigurations() {
        return this.outputTypeConfigurations.values();
    }

    public OutputTypeConfiguration getOutputTypeConfiguration(OutputType outputType) {
        return this.outputTypeConfigurations.get(outputType);
    }

    public void deregisterOutputTypeConfiguration(OutputType outputType) {
        this.outputTypeConfigurations.remove(outputType);
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.outputTypeConfigurations.containsKey(outputType);
    }

    public OutputTypeConfiguration createAndRegisterOutputTypeConfiguration(OutputType outputType) throws PlanItException {
        OutputTypeConfiguration createdOutputTypeConfiguration = null;
        switch (outputType) {
            case LINK: {
                createdOutputTypeConfiguration = new LinkOutputTypeConfiguration();
                break;
            }
            case OD: {
                createdOutputTypeConfiguration = new ODOutputTypeConfiguration();
                break;
            }
            case PATH: {
                createdOutputTypeConfiguration = new PathOutputTypeConfiguration();
                break;
            }
            default: {
                LOGGER.warning(outputType.value() + " has not been defined yet.");
            }
        }
        if (createdOutputTypeConfiguration != null) {
            this.outputTypeConfigurations.put(outputType, createdOutputTypeConfiguration);
        }
        return createdOutputTypeConfiguration;
    }

    public void setPersistOnlyFinalIteration(boolean persistOnlyFinalIteration) {
        this.persistOnlyFinalIteration = persistOnlyFinalIteration;
    }

    public boolean isPersistOnlyFinalIteration() {
        return this.persistOnlyFinalIteration;
    }

    public void setPersistZeroFlow(boolean persistZeroFlow) {
        this.persistZeroFlow = persistZeroFlow;
    }

    public boolean isPersistZeroFlow() {
        return this.persistZeroFlow;
    }
}

