/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.property;

import java.util.logging.Logger;
import org.planit.output.property.BaseOutputProperty;
import org.planit.utils.exceptions.PlanItException;

public enum OutputProperty {
    DENSITY("org.planit.output.property.DensityOutputProperty"),
    LINK_SEGMENT_ID("org.planit.output.property.LinkSegmentIdOutputProperty"),
    LINK_SEGMENT_XML_ID("org.planit.output.property.LinkSegmentXmlIdOutputProperty"),
    LINK_SEGMENT_EXTERNAL_ID("org.planit.output.property.LinkSegmentExternalIdOutputProperty"),
    MODE_ID("org.planit.output.property.ModeIdOutputProperty"),
    MODE_EXTERNAL_ID("org.planit.output.property.ModeExternalIdOutputProperty"),
    MODE_XML_ID("org.planit.output.property.ModeXmlIdOutputProperty"),
    MAXIMUM_DENSITY("org.planit.output.property.MaximumDensityOutputProperty"),
    MAXIMUM_SPEED("org.planit.output.property.MaximumSpeedOutputProperty"),
    CALCULATED_SPEED("org.planit.output.property.CalculatedSpeedOutputProperty"),
    FLOW("org.planit.output.property.FlowOutputProperty"),
    LENGTH("org.planit.output.property.LengthOutputProperty"),
    UPSTREAM_NODE_ID("org.planit.output.property.UpstreamNodeIdOutputProperty"),
    UPSTREAM_NODE_EXTERNAL_ID("org.planit.output.property.UpstreamNodeExternalIdOutputProperty"),
    UPSTREAM_NODE_XML_ID("org.planit.output.property.UpstreamNodeXmlIdOutputProperty"),
    DOWNSTREAM_NODE_ID("org.planit.output.property.DownstreamNodeIdOutputProperty"),
    DOWNSTREAM_NODE_EXTERNAL_ID("org.planit.output.property.DownstreamNodeExternalIdOutputProperty"),
    DOWNSTREAM_NODE_XML_ID("org.planit.output.property.DownstreamNodeXmlIdOutputProperty"),
    CAPACITY_PER_LANE("org.planit.output.property.CapacityPerLaneOutputProperty"),
    NUMBER_OF_LANES("org.planit.output.property.NumberOfLanesOutputProperty"),
    LINK_COST("org.planit.output.property.LinkCostOutputProperty"),
    OD_COST("org.planit.output.property.ODCostOutputProperty"),
    DOWNSTREAM_NODE_LOCATION("org.planit.output.property.DownstreamNodeLocationOutputProperty"),
    UPSTREAM_NODE_LOCATION("org.planit.output.property.UpstreamNodeLocationOutputProperty"),
    ITERATION_INDEX("org.planit.output.property.IterationIndexOutputProperty"),
    ORIGIN_ZONE_ID("org.planit.output.property.OriginZoneIdOutputProperty"),
    ORIGIN_ZONE_EXTERNAL_ID("org.planit.output.property.OriginZoneExternalIdOutputProperty"),
    ORIGIN_ZONE_XML_ID("org.planit.output.property.OriginZoneXmlIdOutputProperty"),
    DESTINATION_ZONE_ID("org.planit.output.property.DestinationZoneIdOutputProperty"),
    DESTINATION_ZONE_XML_ID("org.planit.output.property.DestinationZoneXmlIdOutputProperty"),
    DESTINATION_ZONE_EXTERNAL_ID("org.planit.output.property.DestinationZoneExternalIdOutputProperty"),
    TIME_PERIOD_ID("org.planit.output.property.TimePeriodIdOutputProperty"),
    TIME_PERIOD_XML_ID("org.planit.output.property.TimePeriodXmlIdOutputProperty"),
    TIME_PERIOD_EXTERNAL_ID("org.planit.output.property.TimePeriodExternalIdOutputProperty"),
    RUN_ID("org.planit.output.property.RunIdOutputProperty"),
    PATH_STRING("org.planit.output.property.PathOutputStringProperty"),
    PATH_ID("org.planit.output.property.PathIdOutputProperty"),
    VC_RATIO("org.planit.output.property.VCRatioOutputProperty"),
    COST_TIMES_FLOW("org.planit.output.property.CostTimesFlowOutputProperty"),
    LINK_TYPE("org.planit.output.property.LinkTypeOutputProperty");

    private static final Logger LOGGER;
    private final String value;

    private OutputProperty(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static OutputProperty fromValue(String value) {
        for (OutputProperty outputProperty : OutputProperty.values()) {
            if (!outputProperty.value.equals(value)) continue;
            return outputProperty;
        }
        throw new IllegalArgumentException(value);
    }

    public static OutputProperty fromHeaderName(String name) throws PlanItException {
        String strippedName = name.stripLeading().stripTrailing();
        try {
            for (OutputProperty outputProperty : OutputProperty.values()) {
                Class<?> entityClass = Class.forName(outputProperty.value);
                BaseOutputProperty baseOutputProperty = (BaseOutputProperty)entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!baseOutputProperty.getName().equals(strippedName)) continue;
                return outputProperty;
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(e);
        }
        throw new PlanItException("The header name " + strippedName + " is not associated with any output property");
    }

    static {
        LOGGER = Logger.getLogger(OutputProperty.class.getCanonicalName());
    }
}

