/*
 * Decompiled with CFR 0.152.
 */
package org.planit.path;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.logging.Logger;
import org.planit.output.enums.PathOutputIdentificationType;
import org.planit.path.Path;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.ExternalIdable;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.id.Idable;
import org.planit.utils.network.physical.Node;

public class PathImpl
implements Path {
    private static final Logger LOGGER = Logger.getLogger(PathImpl.class.getCanonicalName());
    private long id;
    private final Deque<EdgeSegment> path;

    private String getNodePathString(Function<Node, Object> idMapper) {
        StringBuilder builder = new StringBuilder("[");
        for (EdgeSegment edgeSegment : this.path) {
            DirectedVertex vertex = edgeSegment.getUpstreamVertex();
            if (!(vertex instanceof Node)) continue;
            Node node = (Node)vertex;
            builder.append(idMapper.apply(node));
            if (!(edgeSegment.getDownstreamVertex() instanceof Node)) continue;
            builder.append(",");
        }
        builder.append("]");
        return new String(builder);
    }

    private String getEdgeSegmentPathString(Function<EdgeSegment, Object> idGetter) {
        StringBuilder builder = new StringBuilder("[");
        for (EdgeSegment edgeSegment : this.path) {
            builder.append(idGetter.apply(edgeSegment));
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return new String(builder);
    }

    public PathImpl(IdGroupingToken groupId) {
        this.id = IdGenerator.generateId(groupId, Path.class);
        this.path = new LinkedList<EdgeSegment>();
    }

    public PathImpl(IdGroupingToken groupId, Deque<EdgeSegment> pathEdgeSegments) {
        this.id = IdGenerator.generateId(groupId, Path.class);
        this.path = pathEdgeSegments;
    }

    @Override
    public Boolean addEdgeSegment(EdgeSegment edgeSegment) {
        return this.path.add(edgeSegment);
    }

    @Override
    public Iterator<EdgeSegment> iterator() {
        return this.path.iterator();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String toString(PathOutputIdentificationType pathOutputType) {
        switch (pathOutputType) {
            case LINK_SEGMENT_EXTERNAL_ID: {
                return this.getEdgeSegmentPathString(ExternalIdable::getExternalId);
            }
            case LINK_SEGMENT_XML_ID: {
                return this.getEdgeSegmentPathString(ExternalIdable::getXmlId);
            }
            case LINK_SEGMENT_ID: {
                return this.getEdgeSegmentPathString(Idable::getId);
            }
            case NODE_EXTERNAL_ID: {
                return this.getNodePathString(ExternalIdable::getExternalId);
            }
            case NODE_XML_ID: {
                return this.getNodePathString(ExternalIdable::getXmlId);
            }
            case NODE_ID: {
                return this.getNodePathString(Idable::getId);
            }
        }
        return "";
    }
}

