/*
 * Decompiled with CFR 0.152.
 */
package org.planit.path.choice;

import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignmentComponentFactory;
import org.planit.assignment.TrafficComponentBuilder;
import org.planit.input.InputBuilderListener;
import org.planit.path.choice.PathChoice;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;

public abstract class PathChoiceBuilder<T extends PathChoice>
extends TrafficComponentBuilder<T> {
    protected static final Logger LOGGER = Logger.getLogger(PathChoiceBuilder.class.getCanonicalName());

    protected T createPathChoiceInstance() throws PlanItException {
        String pathChoiceClassName = this.getClassToBuild().getClass().getCanonicalName();
        TrafficAssignmentComponentFactory pathChoiceFactory = new TrafficAssignmentComponentFactory(pathChoiceClassName);
        PathChoice pathChoice = (PathChoice)pathChoiceFactory.create(pathChoiceClassName, new Object[]{this.getGroupIdToken()});
        PlanItException.throwIf(!(pathChoice instanceof PathChoice), "not a valid path choice type");
        return (T)pathChoice;
    }

    protected abstract void buildSubComponents(T var1) throws PlanItException;

    protected PathChoiceBuilder(Class<T> pathChoiceClass, IdGroupingToken projectToken, InputBuilderListener inputBuilderListener) throws PlanItException {
        super(pathChoiceClass, projectToken, inputBuilderListener);
    }

    @Override
    public T build() throws PlanItException {
        T pathChoice = this.createPathChoiceInstance();
        this.buildSubComponents(pathChoice);
        this.getConfigurator().configure(pathChoice);
        return pathChoice;
    }
}

