/*
 * Decompiled with CFR 0.152.
 */
package org.planit.project;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignment;
import org.planit.assignment.TrafficAssignmentBuilder;
import org.planit.assignment.TrafficAssignmentBuilderFactory;
import org.planit.assignment.TrafficAssignmentComponent;
import org.planit.assignment.TrafficAssignmentComponentFactory;
import org.planit.assignment.TrafficAssignmentConfigurator;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.output.formatter.OutputFormatter;
import org.planit.output.formatter.OutputFormatterFactory;
import org.planit.path.ODPathSets;
import org.planit.project.PlanItProjectInput;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.zoning.Zoning;

public class CustomPlanItProject {
    private static final Logger LOGGER = Logger.getLogger(CustomPlanItProject.class.getCanonicalName());
    protected final long id;
    protected IdGroupingToken projectToken;
    protected final PlanItProjectInput inputs;
    protected final InputBuilderListener inputBuilderListener;
    protected final TreeMap<Long, OutputFormatter> outputFormatters;
    public final PlanItProjectInput.ProjectNetworks physicalNetworks;
    public final PlanItProjectInput.ProjectDemands demands;
    public final PlanItProjectInput.ProjectZonings zonings;
    public final PlanItProjectInput.ProjectODPathSets odPathSets;
    public final ProjectAssignmentBuilders assignmentBuilders = new ProjectAssignmentBuilders();

    protected void executeTrafficAssignment(TrafficAssignment ta) {
        try {
            ta.execute();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    public CustomPlanItProject(InputBuilderListener inputBuilderListener) {
        this.id = IdGenerator.generateId(IdGroupingToken.collectGlobalToken(), CustomPlanItProject.class);
        this.projectToken = IdGenerator.createIdGroupingToken(this, this.id);
        this.inputBuilderListener = inputBuilderListener;
        LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.logActiveStateByClassName(inputBuilderListener, true));
        this.inputs = new PlanItProjectInput(this.id, this.projectToken, inputBuilderListener);
        this.physicalNetworks = this.inputs.physicalNetworks;
        this.demands = this.inputs.demands;
        this.zonings = this.inputs.zonings;
        this.odPathSets = this.inputs.odPathSets;
        this.outputFormatters = new TreeMap();
    }

    public void registerEligibleTrafficComponentClass(Class<? extends TrafficAssignmentComponent<?>> theClazz) throws PlanItException {
        TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(theClazz);
    }

    public InfrastructureNetwork createAndRegisterInfrastructureNetwork(String infrastructureNetworkType) throws PlanItException {
        return this.inputs.createAndRegisterInfrastructureNetwork(infrastructureNetworkType);
    }

    public Zoning createAndRegisterZoning(InfrastructureNetwork network) throws PlanItException {
        return this.inputs.createAndRegisterZoning(network);
    }

    public Demands createAndRegisterDemands(Zoning zoning, InfrastructureNetwork network) throws PlanItException {
        return this.inputs.createAndRegisterDemands(zoning, network);
    }

    public ODPathSets createAndRegisterOdPathSets(InfrastructureLayer networkLayer, Zoning zoning, String odPathSetInputPath) throws PlanItException {
        return this.inputs.createAndRegisterOdPathSets(networkLayer, zoning, odPathSetInputPath);
    }

    public TrafficAssignmentConfigurator<? extends TrafficAssignment> createAndRegisterTrafficAssignment(String trafficAssignmentType, Demands theDemands, Zoning theZoning, InfrastructureNetwork theNetwork) throws PlanItException {
        TrafficAssignmentBuilder<?> taBuilder = TrafficAssignmentBuilderFactory.createBuilder(trafficAssignmentType, this.projectToken, this.inputBuilderListener, theDemands, theZoning, theNetwork);
        this.assignmentBuilders.addTrafficAssignmentBuilder(taBuilder);
        return (TrafficAssignmentConfigurator)taBuilder.getConfigurator();
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(InfrastructureNetwork network, String fileName) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName);
    }

    public InitialLinkSegmentCostPeriod createAndRegisterInitialLinkSegmentCost(InfrastructureNetwork network, String fileName, TimePeriod timePeriod) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName, timePeriod);
    }

    public List<InitialLinkSegmentCostPeriod> createAndRegisterInitialLinkSegmentCost(InfrastructureNetwork network, String fileName, Demands demands) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName, demands);
    }

    public OutputFormatter createAndRegisterOutputFormatter(String outputFormatterType) throws PlanItException {
        OutputFormatter outputFormatter = OutputFormatterFactory.createOutputFormatter(outputFormatterType);
        PlanItException.throwIf(outputFormatter == null, "Output writer of type " + outputFormatterType + " could not be created");
        this.outputFormatters.put(outputFormatter.getId(), outputFormatter);
        return outputFormatter;
    }

    public List<InitialLinkSegmentCost> getInitialLinkSegmentCost(InfrastructureNetwork network) {
        return this.inputs.getInitialLinkSegmentCost(network);
    }

    public OutputFormatter getOutputFormatter(long id) {
        return this.outputFormatters.get(id);
    }

    public void executeAllTrafficAssignments() throws PlanItException {
        HashSet<Object> failedAssignments = new HashSet<Object>();
        for (TrafficAssignmentBuilder<?> tab : this.assignmentBuilders) {
            Object ta2 = null;
            try {
                ta2 = tab.build();
                LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.logActiveStateByClassName(ta2, true));
                LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.createRunIdPrefix(((TrafficAssignmentComponent)ta2).getId()) + "assignment created");
                ((TrafficAssignment)ta2).execute();
            }
            catch (PlanItException pe) {
                LOGGER.severe(pe.getMessage());
                if (ta2 == null) continue;
                failedAssignments.add(ta2);
            }
        }
        if (!failedAssignments.isEmpty()) {
            String failedAssignmentessage = "the following assignments failed:";
            failedAssignments.forEach(ta -> failedAssignmentessage.concat(" ").concat(String.valueOf(ta.getId())));
            throw new PlanItException(failedAssignmentessage);
        }
    }

    public class ProjectAssignmentBuilders
    implements Iterable<TrafficAssignmentBuilder<?>> {
        protected final Set<TrafficAssignmentBuilder<?>> builders = new HashSet();

        protected void addTrafficAssignmentBuilder(TrafficAssignmentBuilder<?> trafficAssignmentBuilder) {
            this.builders.add(trafficAssignmentBuilder);
        }

        public int getNumberOfTrafficAssignmentBuilders() {
            return this.builders.size();
        }

        public boolean hasRegisteredAssignmentBuilders() {
            return !this.builders.isEmpty();
        }

        public TrafficAssignmentBuilder<?> getFirstTrafficAssignmentBuilder() {
            return this.hasRegisteredAssignmentBuilders() ? this.builders.iterator().next() : null;
        }

        @Override
        public Iterator<TrafficAssignmentBuilder<?>> iterator() {
            return this.builders.iterator();
        }
    }
}

