/*
 * Decompiled with CFR 0.152.
 */
package org.planit.sdinteraction.smoothing;

import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.utils.id.IdGroupingToken;

public class MSASmoothing
extends Smoothing {
    private static final long serialVersionUID = -3016251188673804117L;
    protected double stepSize = 1.0;

    public MSASmoothing(IdGroupingToken groupId) {
        super(groupId);
    }

    @Override
    public void update(int iterationIndex) {
        this.stepSize = 1.0 / (double)(iterationIndex + 1);
    }

    @Override
    public double applySmoothing(double previousValue, double proposedValue) {
        return (1.0 - this.stepSize) * previousValue + this.stepSize * proposedValue;
    }

    @Override
    public double[] applySmoothing(double[] previousValues, double[] proposedValues, int numberOfValues) {
        double[] smoothedValues = new double[numberOfValues];
        for (int i = 0; i < numberOfValues; ++i) {
            smoothedValues[i] = (1.0 - this.stepSize) * previousValues[i] + this.stepSize * proposedValues[i];
        }
        return smoothedValues;
    }
}

