/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.builder;

import java.util.logging.Logger;
import org.planit.utils.builder.Configurator;
import org.planit.utils.exceptions.PlanItException;

public abstract class Builder<T> {
    private static final Logger LOGGER = Logger.getLogger(Builder.class.getCanonicalName());
    private final Class<T> classToBuild;
    private Configurator<T> configurator;

    protected abstract Configurator<T> createConfigurator() throws PlanItException;

    protected Class<T> getClassToBuild() {
        return this.classToBuild;
    }

    protected Builder(Class<T> classToBuild) {
        this.classToBuild = classToBuild;
    }

    public Configurator<T> getConfigurator() {
        if (this.configurator == null) {
            try {
                this.configurator = this.createConfigurator();
            }
            catch (PlanItException e) {
                LOGGER.severe(String.format("unable to create the appropriate configurator because: %s", e.getMessage()));
            }
        }
        return this.configurator;
    }

    public abstract T build() throws PlanItException;
}

