/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.graph;

import java.util.Set;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;

public interface DirectedVertex
extends Vertex {
    public boolean hasExitEdgeSegments();

    public boolean hasEntryEdgeSegments();

    public boolean addEdgeSegment(EdgeSegment var1);

    public boolean removeEdgeSegment(EdgeSegment var1);

    public Set<EdgeSegment> getEntryEdgeSegments();

    public Set<EdgeSegment> getExitEdgeSegments();

    public int getNumberOfEntryEdgeSegments();

    public int getNumberOfExitEdgeSegments();

    default public boolean replace(EdgeSegment edgeSegmentToReplace, EdgeSegment edgeSegmentToReplaceWith, boolean forceInsert) {
        if (this.removeEdgeSegment(edgeSegmentToReplace) || forceInsert) {
            return this.addEdgeSegment(edgeSegmentToReplaceWith);
        }
        return false;
    }

    default public EdgeSegment getEdgeSegment(DirectedVertex otherVertex) {
        for (EdgeSegment edgeSegment : this.getExitEdgeSegments()) {
            if (!edgeSegment.getDownstreamVertex().equals(otherVertex)) continue;
            return edgeSegment;
        }
        for (EdgeSegment edgeSegment : this.getEntryEdgeSegments()) {
            if (!edgeSegment.getUpstreamVertex().equals(otherVertex)) continue;
            return edgeSegment;
        }
        return null;
    }
}

