/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog;

import java.io.File;
import org.pmw.tinylog.runtime.AndroidRuntime;
import org.pmw.tinylog.runtime.LegacyJavaRuntime;
import org.pmw.tinylog.runtime.ModernJavaRuntime;
import org.pmw.tinylog.runtime.RuntimeDialect;

public final class EnvironmentHelper {
    private static final RuntimeDialect DIALECT = EnvironmentHelper.resolveDialect();
    private static final String NEW_LINE = System.getProperty("line.separator");

    private EnvironmentHelper() {
    }

    public static boolean isAtLeastJava9() {
        String string = System.getProperty("java.version");
        if (string == null) {
            return false;
        }
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string.matches("[0-9]{1,8}") && Integer.parseInt(string) >= 9;
    }

    public static boolean isAndroid() {
        return "Android Runtime".equalsIgnoreCase(System.getProperty("java.runtime.name"));
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Windows");
    }

    public static RuntimeDialect getRuntimeDialect() {
        return DIALECT;
    }

    public static String getNewLine() {
        return NEW_LINE;
    }

    public static void makeDirectories(File file) {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
    }

    private static RuntimeDialect resolveDialect() {
        if (EnvironmentHelper.isAtLeastJava9()) {
            return new ModernJavaRuntime();
        }
        if (EnvironmentHelper.isAndroid()) {
            return new AndroidRuntime();
        }
        return new LegacyJavaRuntime();
    }
}

