/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.seq;

import de.topobyte.osm4j.core.access.OsmHandler;
import de.topobyte.osm4j.core.access.OsmInputException;
import de.topobyte.osm4j.core.access.OsmReader;
import de.topobyte.osm4j.pbf.seq.PbfParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class PbfReader
implements OsmReader {
    private OsmHandler handler;
    private boolean parseMetadata;
    private InputStream input;

    public PbfReader(InputStream input, boolean parseMetadata) {
        this.input = input;
        this.parseMetadata = parseMetadata;
    }

    public PbfReader(File file, boolean parseMetadata) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        this.input = new BufferedInputStream(fis);
        this.parseMetadata = parseMetadata;
    }

    public PbfReader(String pathname, boolean parseMetadata) throws FileNotFoundException {
        this(new File(pathname), parseMetadata);
    }

    @Override
    public void setHandler(OsmHandler handler) {
        this.handler = handler;
    }

    @Override
    public void read() throws OsmInputException {
        PbfParser parser = new PbfParser(this.handler, this.parseMetadata);
        try {
            parser.parse(this.input);
        }
        catch (IOException e) {
            throw new OsmInputException("error while parsing data", e);
        }
        try {
            this.handler.complete();
        }
        catch (IOException e) {
            throw new OsmInputException("error while completing handler", e);
        }
    }
}

