/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.xml.dynsax;

import de.topobyte.osm4j.core.access.OsmHandler;
import de.topobyte.osm4j.core.access.OsmInputException;
import de.topobyte.osm4j.core.access.OsmReader;
import de.topobyte.osm4j.xml.dynsax.OsmSaxHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class OsmXmlReader
implements OsmReader {
    private OsmHandler handler;
    private boolean parseMetadata;
    private InputStream inputStream;

    public OsmXmlReader(InputStream inputStream, boolean parseMetadata) {
        this.inputStream = inputStream;
        this.parseMetadata = parseMetadata;
    }

    public OsmXmlReader(File file, boolean parseMetadata) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        this.inputStream = new BufferedInputStream(fis);
        this.parseMetadata = parseMetadata;
    }

    public OsmXmlReader(String pathname, boolean parseMetadata) throws FileNotFoundException {
        this(new File(pathname), parseMetadata);
    }

    @Override
    public void setHandler(OsmHandler handler) {
        this.handler = handler;
    }

    @Override
    public void read() throws OsmInputException {
        SAXParser parser;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            parser = saxParserFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new OsmInputException("error while creating xml parser", e);
        }
        OsmSaxHandler saxHandler = OsmSaxHandler.createInstance(this.handler, this.parseMetadata);
        try {
            parser.parse(this.inputStream, (DefaultHandler)saxHandler);
        }
        catch (Exception e) {
            throw new OsmInputException("error while parsing xml data", e);
        }
        try {
            this.handler.complete();
        }
        catch (IOException e) {
            throw new OsmInputException("error while completing handler", e);
        }
    }
}

