/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.geotools.geometry.iso.aggregate.MultiCurveImpl;
import org.geotools.geometry.iso.aggregate.MultiPointImpl;
import org.geotools.geometry.iso.aggregate.MultiPrimitiveImpl;
import org.geotools.geometry.iso.aggregate.MultiSurfaceImpl;
import org.geotools.geometry.iso.complex.CompositeCurveImpl;
import org.geotools.geometry.iso.complex.CompositePointImpl;
import org.geotools.geometry.iso.complex.CompositeSurfaceImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.PrimitiveImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.CoordinateList;
import org.geotools.geometry.iso.topograph2D.util.CoordinateArrays;
import org.geotools.geometry.iso.topograph2D.util.UniqueCoordinateArrayFilter;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ConvexHull {
    private CoordinateReferenceSystem crs;
    private Coordinate[] inputPts;

    public ConvexHull(GeometryImpl geometry) {
        this(ConvexHull.extractCoordinates(geometry), geometry.getCoordinateReferenceSystem());
    }

    public ConvexHull(Coordinate[] pts, CoordinateReferenceSystem crs) {
        this.inputPts = pts;
        this.crs = crs;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private static Coordinate[] extractCoordinates(GeometryImpl geom) {
        Collection<Object> positions = null;
        if (geom instanceof PointImpl) {
            positions = new ArrayList<DirectPositionImpl>();
            positions.add(((PointImpl)geom).getDirectPosition());
        } else if (geom instanceof CurveImpl) {
            positions = ((CurveImpl)geom).asDirectPositions();
        } else if (geom instanceof RingImpl) {
            positions = ((RingImplUnsafe)geom).asDirectPositions();
        } else if (geom instanceof SurfaceImpl) {
            positions = ((RingImplUnsafe)((SurfaceImpl)geom).getBoundary().getExterior()).asDirectPositions();
        } else if (geom instanceof MultiPointImpl) {
            positions = ((MultiPointImpl)geom).getElements();
        } else if (geom instanceof MultiCurveImpl) {
            positions = new HashSet();
            Iterator<OrientableCurve> curveIter = ((MultiCurveImpl)geom).getElements().iterator();
            while (curveIter.hasNext()) {
                positions.addAll(((CurveImpl)curveIter.next()).asDirectPositions());
            }
        } else if (geom instanceof MultiSurfaceImpl) {
            positions = new HashSet();
            Iterator<OrientableSurface> surfaceIter = ((MultiSurfaceImpl)geom).getElements().iterator();
            while (surfaceIter.hasNext()) {
                positions.addAll(((RingImplUnsafe)((SurfaceImpl)surfaceIter.next()).getBoundary().getExterior()).asDirectPositions());
            }
        } else if (geom instanceof MultiPrimitiveImpl) {
            positions = new HashSet();
            for (PrimitiveImpl primitiveImpl : ((MultiPrimitiveImpl)geom).getElements()) {
                if (primitiveImpl instanceof PointImpl) {
                    positions.add(primitiveImpl);
                    continue;
                }
                Geometry geometry = primitiveImpl.getConvexHull();
                if (geometry instanceof CurveImpl) {
                    CurveImpl curve = (CurveImpl)primitiveImpl.getConvexHull();
                    positions.addAll(curve.asDirectPositions());
                    continue;
                }
                if (!(geometry instanceof SurfaceImpl)) continue;
                SurfaceImpl surface = (SurfaceImpl)primitiveImpl.getConvexHull();
                positions.addAll(((RingImplUnsafe)surface.getBoundary().getExterior()).asDirectPositions());
            }
        } else if (geom instanceof CompositePointImpl) {
            positions = new ArrayList();
            positions.add(((CompositePointImpl)geom).getElements().iterator().next());
        } else if (geom instanceof CompositeCurveImpl) {
            Assert.isTrue(false, "not implemented yet");
        } else if (geom instanceof CompositeSurfaceImpl) {
            Assert.isTrue(false, "not implemented yet");
        } else if (geom instanceof CurveBoundaryImpl) {
            positions = new ArrayList();
            positions.add(((CurveBoundaryImpl)geom).getStartPoint());
            positions.add(((CurveBoundaryImpl)geom).getEndPoint());
        } else if (geom instanceof SurfaceBoundaryImpl) {
            positions = ((RingImplUnsafe)((SurfaceBoundaryImpl)geom).getExterior()).asDirectPositions();
        }
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        for (Object e : positions) {
            if (e instanceof DirectPositionImpl) {
                filter.filter(new Coordinate(((DirectPositionImpl)e).getCoordinate()));
                continue;
            }
            if (e instanceof PointImpl) {
                filter.filter(new Coordinate(((PointImpl)e).getDirectPosition().getCoordinate()));
                continue;
            }
            Assert.isTrue(false, "Invalid coordinate type");
        }
        return filter.getCoordinates();
    }

    public Geometry getConvexHull() {
        if (this.inputPts.length == 0) {
            return null;
        }
        if (this.inputPts.length == 1) {
            return new PointImpl(new DirectPositionImpl(this.crs, this.inputPts[0].getCoordinates()));
        }
        if (this.inputPts.length == 2) {
            List<Position> positions = CoordinateArrays.toPositionList(this.crs, this.inputPts);
            LineStringImpl lineString = new LineStringImpl(new PointArrayImpl(positions), 0.0);
            ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
            segments.add(lineString);
            return new CurveImpl(this.crs, segments);
        }
        Coordinate[] reducedPts = this.inputPts;
        if (this.inputPts.length > 50) {
            reducedPts = this.reduce(this.inputPts);
        }
        Coordinate[] sortedPts = this.preSort(reducedPts);
        Stack cHS = this.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinates = new Coordinate[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            Coordinate coordinate;
            coordinates[i] = coordinate = (Coordinate)stack.get(i);
        }
        return coordinates;
    }

    private Coordinate[] reduce(Coordinate[] inputPts) {
        int i;
        Coordinate[] polyPts = this.computeOctRing(inputPts);
        if (polyPts == null) {
            return inputPts;
        }
        HashSet<Coordinate> reducedSet = new HashSet<Coordinate>();
        for (i = 0; i < polyPts.length; ++i) {
            reducedSet.add(polyPts[i]);
        }
        for (i = 0; i < inputPts.length; ++i) {
            if (CGAlgorithms.isPointInRing(inputPts[i], polyPts)) continue;
            reducedSet.add(inputPts[i]);
        }
        Coordinate[] reducedPts = CoordinateArrays.toCoordinateArray(reducedSet);
        return reducedPts;
    }

    private Coordinate[] preSort(Coordinate[] pts) {
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].y < pts[0].y) && (pts[i].y != pts[0].y || !(pts[i].x < pts[0].x))) continue;
            Coordinate t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        Arrays.sort(pts, 1, pts.length, new RadialComparator(pts[0]));
        return pts;
    }

    private Stack grahamScan(Coordinate[] c) {
        Stack<Coordinate> ps = new Stack<Coordinate>();
        Coordinate p = ps.push(c[0]);
        p = ps.push(c[1]);
        p = ps.push(c[2]);
        for (int i = 3; i < c.length; ++i) {
            p = (Coordinate)ps.pop();
            while (CGAlgorithms.computeOrientation((Coordinate)ps.peek(), p, c[i]) > 0) {
                p = (Coordinate)ps.pop();
            }
            p = ps.push(p);
            p = ps.push(c[i]);
        }
        p = ps.push(c[0]);
        return ps;
    }

    private boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (CGAlgorithms.computeOrientation(c1, c2, c3) != 0) {
            return false;
        }
        if (c1.x != c3.x) {
            if (c1.x <= c2.x && c2.x <= c3.x) {
                return true;
            }
            if (c3.x <= c2.x && c2.x <= c1.x) {
                return true;
            }
        }
        if (c1.y != c3.y) {
            if (c1.y <= c2.y && c2.y <= c3.y) {
                return true;
            }
            if (c3.y <= c2.y && c2.y <= c1.y) {
                return true;
            }
        }
        return false;
    }

    private Coordinate[] computeOctRing(Coordinate[] inputPts) {
        Coordinate[] octPts = this.computeOctPts(inputPts);
        CoordinateList coordList = new CoordinateList();
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private Coordinate[] computeOctPts(Coordinate[] inputPts) {
        Coordinate[] pts = new Coordinate[8];
        for (int j = 0; j < pts.length; ++j) {
            pts[j] = inputPts[0];
        }
        for (int i = 1; i < inputPts.length; ++i) {
            if (inputPts[i].x < pts[0].x) {
                pts[0] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y < pts[1].x - pts[1].y) {
                pts[1] = inputPts[i];
            }
            if (inputPts[i].y > pts[2].y) {
                pts[2] = inputPts[i];
            }
            if (inputPts[i].x + inputPts[i].y > pts[3].x + pts[3].y) {
                pts[3] = inputPts[i];
            }
            if (inputPts[i].x > pts[4].x) {
                pts[4] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y > pts[5].x - pts[5].y) {
                pts[5] = inputPts[i];
            }
            if (inputPts[i].y < pts[6].y) {
                pts[6] = inputPts[i];
            }
            if (!(inputPts[i].x + inputPts[i].y < pts[7].x + pts[7].y)) continue;
            pts[7] = inputPts[i];
        }
        return pts;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinates) {
        coordinates = this.cleanRing(coordinates);
        List<Position> positions = CoordinateArrays.toPositionList(this.crs, coordinates);
        if (coordinates.length == 3) {
            positions.remove(2);
            LineStringImpl lineString = new LineStringImpl(new PointArrayImpl(positions), 0.0);
            ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
            segments.add(lineString);
            return new CurveImpl(this.crs, segments);
        }
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl(positions), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        CurveImpl curve = new CurveImpl(this.crs, segments);
        ArrayList<OrientableCurve> orientableCurves = new ArrayList<OrientableCurve>();
        orientableCurves.add(curve);
        RingImpl exterior = new RingImpl((List<OrientableCurve>)orientableCurves);
        ArrayList<Ring> interiorList = new ArrayList<Ring>();
        SurfaceBoundaryImpl sb = new SurfaceBoundaryImpl(this.crs, exterior, interiorList);
        return new SurfaceImpl(sb);
    }

    private Coordinate[] cleanRing(Coordinate[] original) {
        Assert.equals(original[0], original[original.length - 1]);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        for (int i = 0; i <= original.length - 2; ++i) {
            Coordinate currentCoordinate = original[i];
            Coordinate nextCoordinate = original[i + 1];
            if (currentCoordinate.equals(nextCoordinate) || previousDistinctCoordinate != null && this.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate)) continue;
            cleanedRing.add(currentCoordinate);
            previousDistinctCoordinate = currentCoordinate;
        }
        cleanedRing.add(original[original.length - 1]);
        Coordinate[] cleanedRingCoordinates = new Coordinate[cleanedRing.size()];
        return cleanedRing.toArray(cleanedRingCoordinates);
    }

    private static class RadialComparator
    implements Comparator {
        private Coordinate origin;

        public RadialComparator(Coordinate origin) {
            this.origin = origin;
        }

        public int compare(Object o1, Object o2) {
            Coordinate p1 = (Coordinate)o1;
            Coordinate p2 = (Coordinate)o2;
            return RadialComparator.polarCompare(this.origin, p1, p2);
        }

        private static int polarCompare(Coordinate o, Coordinate p, Coordinate q) {
            double dxp = p.x - o.x;
            double dyp = p.y - o.y;
            double dxq = q.x - o.x;
            double dyq = q.y - o.y;
            int orient = CGAlgorithms.computeOrientation(o, p, q);
            if (orient == 1) {
                return 1;
            }
            if (orient == -1) {
                return -1;
            }
            double op = dxp * dxp + dyp * dyp;
            double oq = dxq * dxq + dyq * dyq;
            if (op < oq) {
                return -1;
            }
            if (op > oq) {
                return 1;
            }
            return 0;
        }
    }
}

