/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.assignment.algorithmb.AlgorithmB;
import org.goplanit.assignment.ltm.eltm.EventBasedLtm;
import org.goplanit.assignment.ltm.sltm.StaticLtm;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.goplanit.component.PlanitComponent;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.initial.InitialModesLinkSegmentCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentImpl;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.output.OutputManager;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.supply.networkloading.NetworkLoading;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public abstract class TrafficAssignment
extends NetworkLoading
implements TrafficAssignmentComponentAccessee {
    private static final long serialVersionUID = 801775330292422910L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private OutputManager outputManager;
    private TransportLayerNetwork<?, ?> physicalNetwork = null;
    private TransportModelNetwork transportNetwork = null;
    private Zoning zoning = null;
    private Demands demands = null;
    private final Map<Class<? extends PlanitComponent<?>>, PlanitComponent<?>> trafficAssignmentComponents;
    protected Map<TimePeriod, InitialModesLinkSegmentCost> initialLinkSegmentCostByTimePeriod;
    protected InitialModesLinkSegmentCost initialLinkSegmentCostTimePeriodAgnostic;
    public static String TRADITIONAL_STATIC_ASSIGNMENT = TraditionalStaticAssignment.class.getCanonicalName();
    public static String ALGORITHM_B = AlgorithmB.class.getCanonicalName();
    public static String ELTM = EventBasedLtm.class.getCanonicalName();
    public static String SLTM = StaticLtm.class.getCanonicalName();

    protected String createLoggingPrefix(int iterationIndex) {
        return LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.createIterationPrefix(iterationIndex);
    }

    protected void checkForEmptyComponents() throws PlanItException {
        PlanItException.throwIf(this.demands == null, "Demand is null", new Object[0]);
        PlanItException.throwIf(this.physicalNetwork == null, "Network is null", new Object[0]);
        PlanItException.throwIf(this.zoning == null, "Zoning is null", new Object[0]);
        PlanItException.throwIf(this.getSmoothing() == null, "Smoothing is null", new Object[0]);
        PlanItException.throwIf(this.getGapFunction() == null, "GapFunction is null", new Object[0]);
        PlanItException.throwIf(this.getPhysicalCost() == null, "PhysicalCost is null", new Object[0]);
        PlanItException.throwIf(this.getVirtualCost() == null, "VirtualCost is null", new Object[0]);
    }

    protected abstract void verifyComponentCompatibility() throws PlanItException;

    protected abstract void verifyNetworkDemandZoningCompatibility() throws PlanItException;

    protected void createTransportNetwork() throws PlanItException {
        this.transportNetwork = new TransportModelNetwork(this.physicalNetwork, this.zoning);
        this.transportNetwork.integrateTransportNetworkViaConnectoids();
        if (this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers() > Integer.MAX_VALUE) {
            throw new PlanItException("currently assignment internals expect to be castable to int, but max value is exceeded for link segments");
        }
        if (this.getTransportNetwork().getNumberOfVerticesAllLayers() > Integer.MAX_VALUE) {
            throw new PlanItException("currently assignment internals expect to be castable to int, but max value is exceeded for vertices");
        }
    }

    protected int getTotalNumberOfNetworkSegments() {
        return this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers();
    }

    protected int getTotalNumberOfNetworkVertices() {
        return this.getTransportNetwork().getNumberOfVerticesAllLayers();
    }

    protected void disbandTransportNetwork() throws PlanItException {
        this.transportNetwork.removeVirtualNetworkFromPhysicalNetwork();
    }

    protected void initialiseBeforeExecution() throws PlanItException {
        this.checkForEmptyComponents();
        this.createTransportNetwork();
        this.verifyComponentCompatibility();
        this.outputManager.initialiseBeforeSimulation(this.getId());
        this.getPhysicalCost().initialiseBeforeSimulation(this.physicalNetwork);
        this.getVirtualCost().initialiseBeforeSimulation(this.zoning.getVirtualNetwork());
    }

    protected abstract void executeEquilibration() throws PlanItException;

    protected void finalizeAfterExecution() throws PlanItException {
        this.outputManager.finaliseAfterSimulation();
        this.disbandTransportNetwork();
    }

    protected OutputManager getOutputManager() {
        return this.outputManager;
    }

    protected void logRegisteredComponent(Object item, boolean register) {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.logActiveStateByClassName(item, register));
    }

    protected void registerComponent(Class<? extends PlanitComponent<?>> componentKey, PlanitComponent<?> component) {
        this.trafficAssignmentComponents.put(componentKey, component);
    }

    public TrafficAssignment(IdGroupingToken groupId) {
        super(groupId);
        this.trafficAssignmentComponents = new HashMap();
        this.initialLinkSegmentCostByTimePeriod = new HashMap<TimePeriod, InitialModesLinkSegmentCost>();
    }

    protected TrafficAssignment(TrafficAssignment trafficAssignment) {
        super(trafficAssignment);
        this.demands = trafficAssignment.demands;
        this.physicalNetwork = trafficAssignment.physicalNetwork;
        this.zoning = trafficAssignment.zoning;
        this.trafficAssignmentComponents = new HashMap(trafficAssignment.trafficAssignmentComponents);
        this.initialLinkSegmentCostTimePeriodAgnostic = trafficAssignment.initialLinkSegmentCostTimePeriodAgnostic;
        this.initialLinkSegmentCostByTimePeriod = new HashMap<TimePeriod, InitialModesLinkSegmentCost>(trafficAssignment.initialLinkSegmentCostByTimePeriod);
    }

    public abstract OutputTypeAdapter createOutputTypeAdapter(OutputType var1);

    public abstract int getIterationIndex();

    public void execute() throws PlanItException {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("----------------- %s -----------------", this.getClass().getSimpleName()));
        this.initialiseBeforeExecution();
        this.executeEquilibration();
        this.finalizeAfterExecution();
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("----------------- %s ----------------", this.getClass().getSimpleName()));
    }

    public TransportModelNetwork getTransportNetwork() {
        return this.transportNetwork;
    }

    public void setInfrastructureNetwork(TransportLayerNetwork<?, ?> physicalNetwork) {
        this.logRegisteredComponent(physicalNetwork, true);
        this.physicalNetwork = physicalNetwork;
    }

    public TransportLayerNetwork<?, ?> getInfrastructureNetwork() {
        return this.physicalNetwork;
    }

    public Demands getDemands() {
        return this.demands;
    }

    public void setDemands(Demands demands) {
        this.logRegisteredComponent(demands, true);
        this.demands = demands;
    }

    public Zoning getZoning() {
        return this.zoning;
    }

    public void setZoning(Zoning zoning) {
        this.logRegisteredComponent(zoning, true);
        this.zoning = zoning;
    }

    public void setSmoothing(Smoothing smoothing) {
        this.logRegisteredComponent(smoothing, true);
        this.registerComponent(Smoothing.class, smoothing);
    }

    public Smoothing getSmoothing() {
        return this.getTrafficAssignmentComponent(Smoothing.class);
    }

    public void setGapFunction(GapFunction gapfunction) {
        this.logRegisteredComponent(gapfunction, true);
        this.registerComponent(GapFunction.class, gapfunction);
    }

    public GapFunction getGapFunction() {
        return this.getTrafficAssignmentComponent(GapFunction.class);
    }

    public void setInitialLinkSegmentCost(InitialModesLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCostTimePeriodAgnostic = initialLinkSegmentCost;
    }

    public void setInitialLinkSegmentCost(TimePeriod timePeriod, InitialModesLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCostByTimePeriod.put(timePeriod, initialLinkSegmentCost);
    }

    public void setPhysicalCost(AbstractPhysicalCost physicalCost) throws PlanItException {
        this.logRegisteredComponent(physicalCost, true);
        this.registerComponent(AbstractPhysicalCost.class, physicalCost);
    }

    public AbstractPhysicalCost getPhysicalCost() {
        return this.getTrafficAssignmentComponent(AbstractPhysicalCost.class);
    }

    public AbstractVirtualCost getVirtualCost() {
        return this.getTrafficAssignmentComponent(AbstractVirtualCost.class);
    }

    public void setVirtualCost(AbstractVirtualCost virtualCost) throws PlanItException {
        this.logRegisteredComponent(virtualCost, true);
        this.registerComponent(AbstractVirtualCost.class, virtualCost);
    }

    @Override
    public <T> T getTrafficAssignmentComponent(Class<T> planitComponentClass) {
        PlanitComponent<?> component = this.trafficAssignmentComponents.get(planitComponentClass);
        if (component == null) {
            LOGGER.warning(String.format("Unable to access component supposed to be registered under %s, consider registering it first", planitComponentClass.getName()));
        }
        return (T)component;
    }

    public void setOutputManager(OutputManager outputManager) {
        this.outputManager = outputManager;
        outputManager.getOutputFormatters().forEach(of -> this.logRegisteredComponent(of, false));
        outputManager.getRegisteredOutputTypeConfigurations().forEach(oc -> LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + "activated: OutputType." + oc.getOutputType()));
    }

    @Override
    public void reset() {
        this.initialLinkSegmentCostByTimePeriod.clear();
        this.initialLinkSegmentCostTimePeriodAgnostic = null;
        try {
            this.disbandTransportNetwork();
        }
        catch (PlanItException e) {
            LOGGER.severe(String.format("Unable to reset assignment %s, transport network could not be disbanded", this.getXmlId()));
        }
        this.trafficAssignmentComponents.forEach((clazz, component) -> component.reset());
    }
}

