/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.assignment.TrafficAssignmentConfigurator;
import org.goplanit.component.PlanitComponentBuilder;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.StopCriterion;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.interactor.InteractorAccessor;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.output.OutputManager;
import org.goplanit.output.enums.OutputType;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.supply.networkloading.NetworkLoading;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public abstract class TrafficAssignmentBuilder<T extends TrafficAssignment>
extends PlanitComponentBuilder<T> {
    protected static final Logger LOGGER = Logger.getLogger(TrafficAssignmentBuilder.class.getCanonicalName());

    private void registerDemandZoningAndNetwork(Demands demands, Zoning zoning, TransportLayerNetwork<?, ?> network) throws PlanItException {
        if (zoning == null || demands == null || network == null) {
            PlanItException.throwIf(zoning == null, "zoning in registerDemandZoningAndNetwork is null", new Object[0]);
            PlanItException.throwIf(demands == null, "demands in registerDemandZoningAndNetwork is null", new Object[0]);
            PlanItException.throwIf(network == null, "network in registerDemandZoningAndNetwork is null", new Object[0]);
        }
        PlanItException.throwIf(!zoning.isCompatibleWithDemands(demands, network.getModes()), "Zoning structure is incompatible with one or more of the demands, likely the number of zones does not match the number of origins and/or destinations", new Object[0]);
        for (Mode mode : network.getModes()) {
            for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
                if (demands.get(mode, timePeriod) != null) continue;
                LOGGER.warning("No demand matrix defined for Mode " + mode.getExternalId() + " and Time Period " + timePeriod.getExternalId());
            }
        }
        ((TrafficAssignmentConfigurator)this.getConfigurator()).setInfrastructureNetwork(network);
        ((TrafficAssignmentConfigurator)this.getConfigurator()).setZoning(zoning);
        ((TrafficAssignmentConfigurator)this.getConfigurator()).setDemands(demands);
    }

    private void createOutputManager() {
        ((TrafficAssignmentConfigurator)this.getConfigurator()).setOutputManager(new OutputManager());
    }

    private void initialiseOutputAdapters(T trafficAssignment) {
        ((TrafficAssignmentConfigurator)this.getConfigurator()).getOutputManager().initialiseOutputAdapters((TrafficAssignment)trafficAssignment);
    }

    @Override
    protected abstract TrafficAssignmentConfigurator<T> createConfigurator() throws PlanItException;

    protected T createTrafficAssignmentInstance() throws PlanItException {
        String trafficAssignmentClassName = this.getClassToBuild().getCanonicalName();
        PlanitComponentFactory assignmentFactory = new PlanitComponentFactory(NetworkLoading.class.getCanonicalName());
        assignmentFactory.addListener(this.getInputBuilderListener());
        NetworkLoading networkLoadingAndAssignment = (NetworkLoading)assignmentFactory.create(trafficAssignmentClassName, new Object[]{this.groupId});
        PlanItException.throwIf(!(networkLoadingAndAssignment instanceof TrafficAssignment), "not a valid traffic assignment type", new Object[0]);
        return (T)((TrafficAssignment)networkLoadingAndAssignment);
    }

    protected Smoothing createSmoothingInstance() throws PlanItException {
        PlanitComponentFactory smoothingFactory = new PlanitComponentFactory(Smoothing.class);
        smoothingFactory.addListener(this.getInputBuilderListener());
        return (Smoothing)smoothingFactory.create(((TrafficAssignmentConfigurator)this.getConfigurator()).getSmoothing().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()});
    }

    protected AbstractPhysicalCost createPhysicalCostInstance() throws PlanItException {
        PlanitComponentFactory physicalCostFactory = new PlanitComponentFactory(AbstractPhysicalCost.class);
        physicalCostFactory.addListener(this.getInputBuilderListener());
        return (AbstractPhysicalCost)physicalCostFactory.create(((TrafficAssignmentConfigurator)this.getConfigurator()).getPhysicalCost().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()}, ((TrafficAssignmentConfigurator)this.getConfigurator()).getInfrastructureNetwork());
    }

    protected AbstractVirtualCost createVirtualCostInstance() throws PlanItException {
        PlanitComponentFactory virtualCostFactory = new PlanitComponentFactory(AbstractVirtualCost.class);
        virtualCostFactory.addListener(this.getInputBuilderListener());
        return (AbstractVirtualCost)virtualCostFactory.create(((TrafficAssignmentConfigurator)this.getConfigurator()).getVirtualCost().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()});
    }

    protected GapFunction createGapFunctionInstance(StopCriterion stopCriterion) throws PlanItException {
        PlanitComponentFactory gapFunctionFactory = new PlanitComponentFactory(GapFunction.class);
        gapFunctionFactory.addListener(this.getInputBuilderListener());
        return (GapFunction)gapFunctionFactory.create(((TrafficAssignmentConfigurator)this.getConfigurator()).getGapFunction().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken(), stopCriterion});
    }

    protected void buildSubComponents(T trafficAssignmentInstance) throws PlanItException {
        if (((TrafficAssignmentConfigurator)this.getConfigurator()).getSmoothing() != null) {
            Smoothing smoothing = this.createSmoothingInstance();
            ((TrafficAssignmentConfigurator)this.getConfigurator()).getSmoothing().configure(smoothing);
            ((TrafficAssignment)trafficAssignmentInstance).setSmoothing(smoothing);
        }
        if (((TrafficAssignmentConfigurator)this.getConfigurator()).getPhysicalCost() != null) {
            AbstractPhysicalCost physicalCost = this.createPhysicalCostInstance();
            ((TrafficAssignmentConfigurator)this.getConfigurator()).getPhysicalCost().configure(physicalCost);
            ((TrafficAssignment)trafficAssignmentInstance).setPhysicalCost(physicalCost);
            if (physicalCost instanceof InteractorAccessor) {
                ((InteractorAccessor)((Object)physicalCost)).setAccessee((Object)trafficAssignmentInstance);
            }
        }
        if (((TrafficAssignmentConfigurator)this.getConfigurator()).getVirtualCost() != null) {
            AbstractVirtualCost virtualCost = this.createVirtualCostInstance();
            ((TrafficAssignmentConfigurator)this.getConfigurator()).getVirtualCost().configure(virtualCost);
            ((TrafficAssignment)trafficAssignmentInstance).setVirtualCost(virtualCost);
            if (virtualCost instanceof InteractorAccessor) {
                ((InteractorAccessor)((Object)virtualCost)).setAccessee((Object)trafficAssignmentInstance);
            }
        }
        if (((TrafficAssignmentConfigurator)this.getConfigurator()).getGapFunction() != null) {
            StopCriterion stopCriterion = new StopCriterion();
            ((TrafficAssignmentConfigurator)this.getConfigurator()).getGapFunction().getStopCriterion().configure(stopCriterion);
            GapFunction gapFunction = this.createGapFunctionInstance(stopCriterion);
            ((TrafficAssignmentConfigurator)this.getConfigurator()).getGapFunction().configure(gapFunction);
            ((TrafficAssignment)trafficAssignmentInstance).setGapFunction(gapFunction);
        }
    }

    protected TrafficAssignmentBuilder(Class<T> trafficAssignmentClass, IdGroupingToken projectToken, InputBuilderListener inputBuilderListener, Demands demands, Zoning zoning, TransportLayerNetwork<?, ?> network) throws PlanItException {
        super(trafficAssignmentClass, projectToken, inputBuilderListener);
        this.registerDemandZoningAndNetwork(demands, zoning, network);
        this.createOutputManager();
        ((TrafficAssignmentConfigurator)this.getConfigurator()).activateOutput(OutputType.LINK);
    }

    @Override
    public TrafficAssignmentConfigurator<T> getConfigurator() {
        return (TrafficAssignmentConfigurator)super.getConfigurator();
    }

    @Override
    public T build() throws PlanItException {
        T trafficAssignment = this.createTrafficAssignmentInstance();
        this.getConfigurator().configure(trafficAssignment);
        ((TrafficAssignment)trafficAssignment).verifyNetworkDemandZoningCompatibility();
        this.buildSubComponents(trafficAssignment);
        this.initialiseOutputAdapters(trafficAssignment);
        return trafficAssignment;
    }
}

