/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.AcyclicMinMaxShortestPathAlgorithm;
import org.goplanit.algorithms.shortestpath.MinMaxPathResult;
import org.goplanit.assignment.ltm.sltm.BushTurnData;
import org.goplanit.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.graph.directed.acyclic.ACyclicSubGraphImpl;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.zoning.OdZone;

public class Bush
implements IdAble {
    private static final Logger LOGGER = Logger.getLogger(Bush.class.getCanonicalName());
    protected final OdZone origin;
    protected double originDemandPcuH;
    protected final ACyclicSubGraph dag;
    protected final BushTurnData bushData;
    boolean requireTopologicalSortUpdate = false;

    public Bush(IdGroupingToken idToken, OdZone origin, long numberOfEdgeSegments) {
        this.origin = origin;
        this.dag = new ACyclicSubGraphImpl(idToken, (int)numberOfEdgeSegments, origin.getCentroid());
        this.bushData = new BushTurnData();
    }

    public Bush(Bush bush) {
        this.origin = bush.getOrigin();
        this.dag = bush.dag.clone();
        this.bushData = bush.bushData.clone();
        this.requireTopologicalSortUpdate = bush.requireTopologicalSortUpdate;
    }

    public MinMaxPathResult computeMinMaxShortestPaths(double[] linkSegmentCosts, int totalTransportNetworkVertices) {
        Collection<DirectedVertex> topologicalOrder = this.getTopologicallySortedVertices();
        this.requireTopologicalSortUpdate = false;
        AcyclicMinMaxShortestPathAlgorithm minMaxBushPaths = new AcyclicMinMaxShortestPathAlgorithm(this.dag, topologicalOrder, linkSegmentCosts, totalTransportNetworkVertices);
        try {
            return minMaxBushPaths.executeOneToAll(this.dag.getRootVertex());
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to complete minmax path three for bush rooted at origin %s", this.dag.getRootVertex().getXmlId()));
            return null;
        }
    }

    public void addOriginDemandPcuH(double originDemandPcuH) {
        this.originDemandPcuH += originDemandPcuH;
    }

    public void addTurnSendingFlow(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment, double turnSendingflowPcuH) {
        if (!this.containsEdgeSegment(fromEdgeSegment)) {
            if (this.containsAnyEdgeSegmentOf(fromEdgeSegment.getParentEdge())) {
                LOGGER.warning(String.format("Trying to add turn flow (%s,%s) on bush where the opposite direction (of segment %s) already is part of the bush, this break acyclicity", fromEdgeSegment.getXmlId(), toEdgeSegment.getXmlId(), fromEdgeSegment.getXmlId()));
            }
            this.dag.addEdgeSegment(fromEdgeSegment);
            this.requireTopologicalSortUpdate = true;
        }
        if (!this.containsEdgeSegment(toEdgeSegment)) {
            if (this.containsAnyEdgeSegmentOf(toEdgeSegment.getParentEdge())) {
                LOGGER.warning(String.format("Trying to add turn flow (%s,%s) on bush where the opposite direction (of segment %s) already is part of the bush, this break acyclicity", fromEdgeSegment.getXmlId(), toEdgeSegment.getXmlId(), toEdgeSegment.getXmlId()));
            }
            this.dag.addEdgeSegment(toEdgeSegment);
            this.requireTopologicalSortUpdate = true;
        }
        this.bushData.addTurnSendingFlow(fromEdgeSegment, toEdgeSegment, turnSendingflowPcuH);
    }

    public double getTurnSendingFlow(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment) {
        return this.bushData.getTurnSendingFlowPcuH(fromEdgeSegment, toEdgeSegment);
    }

    public double getSendingFlowPcuH(EdgeSegment edgeSegment) {
        return this.bushData.getTotalSendingFlowPcuH(edgeSegment);
    }

    public boolean containsTurnSendingFlow(EdgeSegment entrySegment, EdgeSegment exitSegment) {
        return Precision.isPositive(this.bushData.getTurnSendingFlowPcuH(entrySegment, exitSegment));
    }

    public double getSplittingRate(EdgeSegment entrySegment, EdgeSegment exitSegment) {
        return this.bushData.getSplittingRate(entrySegment, exitSegment);
    }

    public double[] getSplittingRates(EdgeSegment entrySegment) {
        return this.bushData.getSplittingRates(entrySegment);
    }

    public double[] getRootVertexSplittingRates() {
        double[] splittingRates = new double[this.dag.getRootVertex().getExitEdgeSegments().size()];
        int index = 0;
        double foundRootDemandPcuH = 0.0;
        for (EdgeSegment exitSegment : this.dag.getRootVertex().getExitEdgeSegments()) {
            if (this.containsEdgeSegment(exitSegment)) {
                double rootExitDemandPcuH = this.bushData.getTotalSendingFlowPcuH(exitSegment);
                splittingRates[index] = rootExitDemandPcuH / this.originDemandPcuH;
                foundRootDemandPcuH += rootExitDemandPcuH;
            }
            ++index;
        }
        if (!Precision.isEqual(foundRootDemandPcuH, this.originDemandPcuH)) {
            LOGGER.severe(String.format("Combined flows (%.2f) on bush root for origin %s do not add up to the origin's travel demand (%.2f)", foundRootDemandPcuH, this.getOrigin().getXmlId(), this.originDemandPcuH));
        }
        return splittingRates;
    }

    public void removeTurn(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment) {
        this.dag.removeEdgeSegment(fromEdgeSegment);
        this.dag.removeEdgeSegment(toEdgeSegment);
        this.bushData.removeTurn(fromEdgeSegment, toEdgeSegment);
        this.requireTopologicalSortUpdate = true;
    }

    public boolean containsEdgeSegment(EdgeSegment edgeSegment) {
        return this.dag.containsEdgeSegment(edgeSegment);
    }

    public boolean containsAnyEdgeSegmentOf(DirectedEdge edge) {
        for (EdgeSegment edgeSegment : edge.getEdgeSegments()) {
            if (!this.dag.containsEdgeSegment(edgeSegment)) continue;
            return true;
        }
        return false;
    }

    public Iterator<DirectedVertex> getDirectedVertexIterator() {
        return this.dag.iterator();
    }

    public Pair<DirectedVertex, Map<DirectedVertex, EdgeSegment>> findBushAlternativeSubpath(DirectedVertex mergeVertex, short[] alternativeSubpathVertexLabels) {
        ArrayDeque<Pair<DirectedVertex, EdgeSegment>> openVertexQueue = new ArrayDeque<Pair<DirectedVertex, EdgeSegment>>(30);
        TreeMap<DirectedVertex, EdgeSegment> processedVertices = new TreeMap<DirectedVertex, EdgeSegment>();
        processedVertices.put(mergeVertex, null);
        for (EdgeSegment entrySegment : mergeVertex.getEntryEdgeSegments()) {
            if (!this.containsEdgeSegment(entrySegment) || alternativeSubpathVertexLabels[(int)mergeVertex.getId()] == -1) continue;
            openVertexQueue.add(Pair.of(entrySegment.getUpstreamVertex(), entrySegment));
        }
        while (!openVertexQueue.isEmpty()) {
            Pair current = (Pair)openVertexQueue.pop();
            DirectedVertex currentVertex = (DirectedVertex)current.first();
            if (processedVertices.containsKey(currentVertex)) continue;
            if (alternativeSubpathVertexLabels[(int)currentVertex.getId()] == -1) {
                processedVertices.put(currentVertex, (EdgeSegment)current.second());
                return Pair.of((DirectedVertex)current.first(), processedVertices);
            }
            for (EdgeSegment entrySegment : currentVertex.getEntryEdgeSegments()) {
                if (!this.containsEdgeSegment(entrySegment) || !this.bushData.containsTurnSendingFlow(entrySegment, (EdgeSegment)current.second()) || processedVertices.containsKey(entrySegment.getUpstreamVertex())) continue;
                openVertexQueue.add(Pair.of(entrySegment.getUpstreamVertex(), entrySegment));
            }
            processedVertices.put(currentVertex, (EdgeSegment)current.second());
        }
        LOGGER.warning(String.format("Cycle found when finding alternative subpath on bush for origin zone %s merging at vertex %s", this.getOrigin().getXmlId(), mergeVertex.getXmlId()));
        return null;
    }

    public double computeSubPathSendingFlow(DirectedVertex startVertex, DirectedVertex endVertex, Map<DirectedVertex, EdgeSegment> subPathMap) {
        EdgeSegment nextEdgeSegment = subPathMap.get(startVertex);
        double subPathSendingFlow = this.bushData.getTotalSendingFlowPcuH(nextEdgeSegment);
        if (Precision.isPositive(subPathSendingFlow)) {
            EdgeSegment currEdgeSegment = nextEdgeSegment;
            nextEdgeSegment = subPathMap.get(currEdgeSegment.getDownstreamVertex());
            while ((nextEdgeSegment = subPathMap.get((currEdgeSegment = nextEdgeSegment).getDownstreamVertex())) != null && Precision.isPositive(subPathSendingFlow *= this.bushData.getSplittingRate(currEdgeSegment, nextEdgeSegment))) {
            }
        }
        return subPathSendingFlow;
    }

    public double computeSubPathAcceptedFlow(DirectedVertex startVertex, DirectedVertex endVertex, EdgeSegment[] subPathArray, double[] linkSegmentAcceptanceFactors) {
        int index = 0;
        EdgeSegment currEdgeSegment = subPathArray[index++];
        double subPathAcceptedFlowPcuH = this.bushData.getTotalSendingFlowPcuH(currEdgeSegment);
        EdgeSegment nextEdgeSegment = currEdgeSegment;
        while (index < subPathArray.length && Precision.isPositive(subPathAcceptedFlowPcuH)) {
            currEdgeSegment = nextEdgeSegment;
            nextEdgeSegment = subPathArray[index++];
            subPathAcceptedFlowPcuH *= this.bushData.getSplittingRate(currEdgeSegment, nextEdgeSegment) * linkSegmentAcceptanceFactors[(int)currEdgeSegment.getId()];
        }
        return subPathAcceptedFlowPcuH *= linkSegmentAcceptanceFactors[(int)nextEdgeSegment.getId()];
    }

    public double computeSubPathSendingFlow(DirectedVertex startVertex, DirectedVertex endVertex, EdgeSegment[] subPathArray) {
        int index = 0;
        EdgeSegment currEdgeSegment = subPathArray[index++];
        double subPathSendingFlow = this.bushData.getTotalSendingFlowPcuH(currEdgeSegment);
        EdgeSegment nextEdgeSegment = currEdgeSegment;
        while (index < subPathArray.length && Precision.isPositive(subPathSendingFlow)) {
            currEdgeSegment = nextEdgeSegment;
            nextEdgeSegment = subPathArray[index++];
            subPathSendingFlow *= this.bushData.getSplittingRate(currEdgeSegment, nextEdgeSegment);
        }
        return subPathSendingFlow;
    }

    public Collection<DirectedVertex> getTopologicallySortedVertices() {
        return this.dag.topologicalSort(this.requireTopologicalSortUpdate);
    }

    public OdZone getOrigin() {
        return this.origin;
    }

    public double getTravelDemandPcuH() {
        return this.originDemandPcuH;
    }

    @Override
    public long getId() {
        return this.dag.getId();
    }

    @Override
    public Bush clone() {
        return new Bush(this);
    }
}

