/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.HashUtils;

public class BushTurnData
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(BushTurnData.class.getCanonicalName());
    private final Map<Integer, Double> turnSendingFlows;

    BushTurnData() {
        this.turnSendingFlows = new HashMap<Integer, Double>();
    }

    public BushTurnData(BushTurnData bushTurnData) {
        this.turnSendingFlows = new HashMap<Integer, Double>(bushTurnData.turnSendingFlows);
    }

    public void updateTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment, double turnSendingFlow) {
        this.turnSendingFlows.put(HashUtils.createCombinedHashCode(fromSegment, toSegment), turnSendingFlow);
    }

    public void addTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment, double turnSendingFlow) {
        int hashId = HashUtils.createCombinedHashCode(fromSegment, toSegment);
        double newSendingFlow = this.turnSendingFlows.getOrDefault(hashId, 0.0) + turnSendingFlow;
        if (!Precision.isPositive(newSendingFlow)) {
            LOGGER.warning(String.format("Turn (%s to %s) sending flow negative (%.2f) after adding %.2f flow, reset to 0.0", fromSegment.getXmlId(), toSegment.getXmlId(), newSendingFlow, turnSendingFlow));
            newSendingFlow = 0.0;
        }
        this.turnSendingFlows.put(hashId, newSendingFlow);
    }

    public void removeTurn(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment) {
        this.turnSendingFlows.remove(HashUtils.createCombinedHashCode(fromEdgeSegment, toEdgeSegment));
    }

    public double getTurnSendingFlowPcuH(EdgeSegment fromSegment, EdgeSegment toSegment) {
        return this.turnSendingFlows.getOrDefault(HashUtils.createCombinedHashCode(fromSegment, toSegment), 0.0);
    }

    public double getTotalSendingFlowPcuH(EdgeSegment fromSegment) {
        double totalSendingFlow = 0.0;
        for (EdgeSegment exitSegment : fromSegment.getDownstreamVertex().getExitEdgeSegments()) {
            double s_ab = this.getTurnSendingFlowPcuH(fromSegment, exitSegment);
            totalSendingFlow += s_ab;
        }
        return totalSendingFlow;
    }

    public boolean containsTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment) {
        return this.turnSendingFlows.containsKey(HashUtils.createCombinedHashCode(fromSegment, toSegment));
    }

    public double[] getSplittingRates(EdgeSegment fromSegment) {
        Set<EdgeSegment> exitEdgeSegments = fromSegment.getDownstreamVertex().getExitEdgeSegments();
        double[] splittingRates = new double[exitEdgeSegments.size()];
        double totalSendingFlow = 0.0;
        int index = 0;
        for (EdgeSegment exitSegment : exitEdgeSegments) {
            double s_ab = this.getTurnSendingFlowPcuH(fromSegment, exitSegment);
            splittingRates[index++] = s_ab;
            totalSendingFlow += s_ab;
        }
        index = 0;
        while (index < splittingRates.length) {
            int n = index++;
            splittingRates[n] = splittingRates[n] / totalSendingFlow;
        }
        return splittingRates;
    }

    public double getSplittingRate(EdgeSegment fromSegment, EdgeSegment toSegment) {
        double turnSendingFlow = this.getTurnSendingFlowPcuH(fromSegment, toSegment);
        if (Precision.isPositive(turnSendingFlow)) {
            return this.getTotalSendingFlowPcuH(fromSegment) / turnSendingFlow;
        }
        return 0.0;
    }

    public BushTurnData clone() {
        return new BushTurnData(this);
    }
}

