/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.math.Precision;

public class Pas {
    private static final Logger LOGGER = Logger.getLogger(Pas.class.getCanonicalName());
    private EdgeSegment[] s1;
    private EdgeSegment[] s2;
    private double s1Cost;
    private double s2Cost;
    private final Set<Bush> originBushes;

    private void removeOrigins(List<Bush> originsWithoutRemainingPasFlow) {
        originsWithoutRemainingPasFlow.forEach(bush -> this.originBushes.remove(bush));
    }

    private double executeBushFlowShift(Bush origin, double flowShiftPcuH, EdgeSegment[] pasSegment, double[] flowAcceptanceFactors, boolean potentialBushPruning) {
        int index = 0;
        EdgeSegment currentSegment = null;
        EdgeSegment nextSegment = pasSegment[index];
        while (++index < pasSegment.length) {
            currentSegment = nextSegment;
            nextSegment = pasSegment[index];
            if (potentialBushPruning && Precision.isSmallerEqual(origin.getTurnSendingFlow(currentSegment, nextSegment), flowShiftPcuH)) {
                origin.removeTurn(currentSegment, nextSegment);
            } else {
                origin.addTurnSendingFlow(currentSegment, nextSegment, flowShiftPcuH);
            }
            flowShiftPcuH *= flowAcceptanceFactors[(int)currentSegment.getId()];
        }
        return flowShiftPcuH;
    }

    private Pas(EdgeSegment[] s1, EdgeSegment[] s2) {
        this.s1 = s1;
        this.s2 = s2;
        this.originBushes = new HashSet<Bush>();
    }

    protected void updateCost(double[] edgeSegmentCosts, boolean updateS1) {
        EdgeSegment[] alternative = updateS1 ? this.s1 : this.s2;
        double cost = 0.0;
        for (int index = 0; index < alternative.length; ++index) {
            cost += edgeSegmentCosts[(int)alternative[index].getId()];
        }
        if (updateS1) {
            this.s1Cost = cost;
        } else {
            this.s2Cost = cost;
        }
    }

    protected boolean executeFlowShift(double networkS2FlowPcuH, double flowShiftPcuH, double[] flowAcceptanceFactors) {
        ArrayList<Bush> originsWithoutRemainingPasFlow = new ArrayList<Bush>();
        for (Bush origin : this.originBushes) {
            double bushS2Flow = 0.0;
            double[] bushEntryTurnFlows = null;
            double totalBushEntryTurnFlows = 0.0;
            int numberOfUsedEntrySegments = 0;
            bushS2Flow = origin.computeSubPathSendingFlow(this.getDivergeVertex(), this.getMergeVertex(), this.s2);
            if (this.getDivergeVertex().hasEntryEdgeSegments()) {
                bushEntryTurnFlows = new double[this.getDivergeVertex().getEntryEdgeSegments().size()];
                int index = 0;
                for (EdgeSegment entrySegment : this.getDivergeVertex().getEntryEdgeSegments()) {
                    if (origin.containsEdgeSegment(entrySegment)) {
                        double turnAcceptedFlow;
                        double turnSendingFlow = origin.getTurnSendingFlow(entrySegment, this.getFirstEdgeSegment(false));
                        bushEntryTurnFlows[index] = turnAcceptedFlow = turnSendingFlow * flowAcceptanceFactors[(int)entrySegment.getId()];
                        totalBushEntryTurnFlows += turnAcceptedFlow;
                        ++numberOfUsedEntrySegments;
                    }
                    ++index;
                }
                double pasPortionScalingFactor = bushS2Flow / totalBushEntryTurnFlows;
                index = 0;
                while (index < bushEntryTurnFlows.length) {
                    int n = index++;
                    bushEntryTurnFlows[n] = bushEntryTurnFlows[n] * pasPortionScalingFactor;
                }
            }
            boolean potentialBushPruning = false;
            double bushPortion = Math.min(bushS2Flow / networkS2FlowPcuH, 1.0);
            double bushFlowShift = flowShiftPcuH * bushPortion;
            if (Precision.isGreaterEqual(bushFlowShift, bushS2Flow)) {
                originsWithoutRemainingPasFlow.add(origin);
                bushFlowShift = bushS2Flow;
                potentialBushPruning = true;
            }
            if (numberOfUsedEntrySegments >= 1) {
                int index = 0;
                EdgeSegment firstS2EdgeSegment = this.getFirstEdgeSegment(false);
                EdgeSegment firstS1EdgeSegment = this.getFirstEdgeSegment(true);
                for (EdgeSegment entrySegment : this.getDivergeVertex().getEntryEdgeSegments()) {
                    double entryEdgeSegmentFlowPcuH;
                    if (!Precision.isPositive(entryEdgeSegmentFlowPcuH = bushEntryTurnFlows[index++])) continue;
                    double entryPortion = entryEdgeSegmentFlowPcuH / totalBushEntryTurnFlows;
                    double bushEntrySegmentFlowShift = bushFlowShift * entryPortion * (1.0 / flowAcceptanceFactors[(int)entrySegment.getId()]);
                    if (potentialBushPruning && Precision.isSmallerEqual(origin.getTurnSendingFlow(entrySegment, firstS2EdgeSegment), bushEntrySegmentFlowShift)) {
                        origin.removeTurn(entrySegment, firstS2EdgeSegment);
                    } else {
                        origin.addTurnSendingFlow(entrySegment, firstS2EdgeSegment, -bushEntrySegmentFlowShift);
                    }
                    origin.addTurnSendingFlow(entrySegment, firstS1EdgeSegment, bushEntrySegmentFlowShift);
                }
            }
            double s2FinalShiftedFlow = this.executeBushFlowShift(origin, -bushFlowShift, this.s2, flowAcceptanceFactors, potentialBushPruning);
            double s1FinalSendingFlow = this.executeBushFlowShift(origin, bushFlowShift, this.s1, flowAcceptanceFactors, false);
            EdgeSegment lastS1Segment = this.getLastEdgeSegment(true);
            EdgeSegment lastS2Segment = this.getLastEdgeSegment(false);
            if (!this.getMergeVertex().hasExitEdgeSegments()) continue;
            for (EdgeSegment exitSegment : this.getMergeVertex().getExitEdgeSegments()) {
                double splittingRate = origin.getSplittingRate(lastS2Segment, exitSegment);
                double s2FlowShift = s2FinalShiftedFlow * splittingRate;
                if (potentialBushPruning && Precision.isSmallerEqual(origin.getTurnSendingFlow(lastS2Segment, exitSegment), s2FlowShift)) {
                    origin.removeTurn(lastS2Segment, exitSegment);
                } else {
                    origin.addTurnSendingFlow(lastS2Segment, exitSegment, s2FlowShift);
                }
                origin.addTurnSendingFlow(lastS1Segment, exitSegment, s1FinalSendingFlow * splittingRate);
            }
        }
        this.removeOrigins(originsWithoutRemainingPasFlow);
        return true;
    }

    protected static Pas create(EdgeSegment[] s1, EdgeSegment[] s2) {
        return new Pas(s1, s2);
    }

    public DirectedVertex getMergeVertex() {
        return this.s2[this.s2.length - 1].getDownstreamVertex();
    }

    public DirectedVertex getDivergeVertex() {
        return this.s2[0].getUpstreamVertex();
    }

    public void registerOrigin(Bush origin) {
        this.originBushes.add(origin);
    }

    public boolean hasOrigins() {
        return !this.originBushes.isEmpty();
    }

    public double computeOverlappingAcceptedFlow(Bush bush, boolean lowCost, double[] linkSegmentFlowAcceptanceFactors) {
        EdgeSegment[] alternative = lowCost ? this.s1 : this.s2;
        return bush.computeSubPathAcceptedFlow(this.getDivergeVertex(), this.getMergeVertex(), alternative, linkSegmentFlowAcceptanceFactors);
    }

    public boolean isOverlappingWith(ShortestPathResult pathMatchForCheapPath, boolean lowCost) {
        EdgeSegment[] alternative = lowCost ? this.s1 : this.s2;
        EdgeSegment currEdgeSegment = null;
        EdgeSegment matchingEdgeSegment = null;
        for (int index = alternative.length - 1; index >= 0; --index) {
            currEdgeSegment = alternative[index];
            matchingEdgeSegment = pathMatchForCheapPath.getIncomingEdgeSegmentForVertex(currEdgeSegment.getDownstreamVertex());
            if (currEdgeSegment.idEquals(matchingEdgeSegment)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(BitSet linkSegments, boolean lowCost) {
        EdgeSegment[] alternative = lowCost ? this.s1 : this.s2;
        EdgeSegment currEdgeSegment = null;
        for (int index = alternative.length - 1; index >= 0; --index) {
            currEdgeSegment = alternative[index];
            if (!linkSegments.get((int)currEdgeSegment.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(BitSet linkSegments) {
        return this.containsAny(linkSegments, true) || this.containsAny(linkSegments, false);
    }

    public boolean updateCost(double[] edgeSegmentCosts) {
        this.updateCost(edgeSegmentCosts, true);
        this.updateCost(edgeSegmentCosts, false);
        if (this.s1Cost > this.s2Cost) {
            double tempCost = this.s1Cost;
            this.s1Cost = this.s2Cost;
            this.s2Cost = tempCost;
            EdgeSegment[] tempSegment = this.s1;
            this.s1 = this.s2;
            this.s2 = tempSegment;
            return true;
        }
        return false;
    }

    public void forEachVertex(boolean lowCostSegment, Consumer<DirectedVertex> vertexConsumer) {
        EdgeSegment[] alternative = this.getAlternative(lowCostSegment);
        for (int index = 0; index < alternative.length; ++index) {
            vertexConsumer.accept(alternative[index].getUpstreamVertex());
        }
        vertexConsumer.accept(alternative[alternative.length - 1].getDownstreamVertex());
    }

    public void forEachEdgeSegment(boolean lowCostSegment, Consumer<EdgeSegment> edgeSegmentConsumer) {
        EdgeSegment[] alternative = this.getAlternative(lowCostSegment);
        for (int index = 0; index < alternative.length; ++index) {
            edgeSegmentConsumer.accept(alternative[index]);
        }
    }

    public double getAlternativeHighCost() {
        return this.s2Cost;
    }

    public double getAlternativeLowCost() {
        return this.s1Cost;
    }

    public EdgeSegment getLastEdgeSegment(boolean lowCostSegment) {
        return lowCostSegment ? this.s1[this.s1.length - 1] : this.s2[this.s2.length - 1];
    }

    public EdgeSegment getFirstEdgeSegment(boolean lowCostSegment) {
        return lowCostSegment ? this.s1[0] : this.s2[0];
    }

    public EdgeSegment[] getAlternative(boolean lowCostSegment) {
        return lowCostSegment ? this.s1 : this.s2;
    }

    public double getReducedCost() {
        return this.s2Cost - this.s1Cost;
    }

    public EdgeSegment matchFirst(boolean lowCostSegment, Predicate<EdgeSegment> predicate) {
        EdgeSegment[] alternative = this.getAlternative(lowCostSegment);
        for (int index = 0; index < alternative.length; ++index) {
            if (!predicate.test(alternative[index])) continue;
            return alternative[index];
        }
        return null;
    }
}

