/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.goplanit.algorithms.shortestpath.MinMaxPathResult;
import org.goplanit.algorithms.shortestpath.OneToAllShortestPathAlgorithm;
import org.goplanit.algorithms.shortestpath.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasManager;
import org.goplanit.assignment.ltm.sltm.StaticLtmAssignmentStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.consumer.InitialiseBushEdgeSegmentDemandConsumer;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingBush;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingScheme;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.PhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.cost.virtual.VirtualCost;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.zoning.Zoning;
import org.ojalgo.array.Array1D;

public class StaticLtmBushStrategy
extends StaticLtmAssignmentStrategy {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmBushStrategy.class.getCanonicalName());
    private final Bush[] originBushes;
    private final PasManager pasManager;

    private void updateGap(LinkBasedRelativeDualityGapFunction gapFunction, Pas pas, double s1SendingFlow, double s2SendingFlow) {
        gapFunction.increaseConvexityBound(pas.getAlternativeLowCost() * (s1SendingFlow + s2SendingFlow));
        gapFunction.increaseMeasuredCost(s1SendingFlow * pas.getAlternativeLowCost());
        gapFunction.increaseMeasuredCost(s2SendingFlow * pas.getAlternativeHighCost());
    }

    private double determineSlackFlow(Pas pas, StaticLtmLoadingBush networkLoading) {
        EdgeSegment lastS2Segment = pas.getLastEdgeSegment(false);
        double slackFlow = Double.POSITIVE_INFINITY;
        if (networkLoading.getCurrentFlowAcceptanceFactors()[(int)lastS2Segment.getId()] < 1.0) {
            return 0.0;
        }
        Array1D<Double> splittingRates = networkLoading.getSplittingRateData().getSplittingRates(lastS2Segment);
        int index = 0;
        for (EdgeSegment exitSegment : lastS2Segment.getDownstreamVertex().getExitEdgeSegments()) {
            double splittingRate = (Double)splittingRates.get(index);
            if (splittingRate > 0.0) {
                double scaledSlackFlow = 1.0 / splittingRate * ((MacroscopicLinkSegment)exitSegment).getCapacityOrDefaultPcuH() - networkLoading.getCurrentOutflowsPcuH()[(int)exitSegment.getId()];
                slackFlow = Math.min(slackFlow, scaledSlackFlow);
            }
            ++index;
        }
        EdgeSegment[] s1 = pas.getAlternative(true);
        MacroscopicLinkSegment linkSegment = null;
        for (int index2 = 0; index2 < s1.length; ++index2) {
            linkSegment = (MacroscopicLinkSegment)s1[index2];
            double currSlackflow = linkSegment.getCapacityOrDefaultPcuH() - networkLoading.getCurrentOutflowsPcuH()[(int)linkSegment.getId()];
            if (!Precision.isSmaller(currSlackflow, slackFlow)) continue;
            slackFlow = currSlackflow;
        }
        return slackFlow;
    }

    private double determineFlowShift(Pas pas, double s2ShiftableFlow, Mode theMode, PhysicalCost physicalCost, VirtualCost virtualCost, StaticLtmLoadingBush networkLoading, Predicate<EdgeSegment> firstCongestedLinkSegment) {
        double flowShift = s2ShiftableFlow;
        double denominatorS2 = 0.0;
        double denominatorS1 = 0.0;
        EdgeSegment firstS2CongestedLinkSegment = pas.matchFirst(false, firstCongestedLinkSegment);
        EdgeSegment firstS1CongestedLinkSegment = pas.matchFirst(true, firstCongestedLinkSegment);
        if (firstS1CongestedLinkSegment == null) {
            denominatorS1 = 0.0;
        } else if (firstS1CongestedLinkSegment instanceof MacroscopicLinkSegment) {
            denominatorS1 = physicalCost.getDTravelTimeDFlow(false, theMode, (MacroscopicLinkSegment)firstS1CongestedLinkSegment);
        } else if (firstS1CongestedLinkSegment instanceof ConnectoidSegment) {
            denominatorS1 = virtualCost.getDTravelTimeDFlow(false, theMode, (ConnectoidSegment)firstS1CongestedLinkSegment);
        }
        if (firstS2CongestedLinkSegment == null) {
            denominatorS2 = 0.0;
        } else if (firstS2CongestedLinkSegment instanceof MacroscopicLinkSegment) {
            denominatorS2 = physicalCost.getDTravelTimeDFlow(false, theMode, (MacroscopicLinkSegment)firstS2CongestedLinkSegment);
        } else if (firstS2CongestedLinkSegment instanceof ConnectoidSegment) {
            denominatorS2 = virtualCost.getDTravelTimeDFlow(false, theMode, (ConnectoidSegment)firstS2CongestedLinkSegment);
        }
        double denominator = denominatorS2 + denominatorS1;
        if (!Precision.isPositive(denominator)) {
            double slackFlow = this.determineSlackFlow(pas, networkLoading);
            if (slackFlow < s2ShiftableFlow) {
                double assumedUncongestedShift = slackFlow;
                double assumedCongestedShift = s2ShiftableFlow - slackFlow;
                double appliedCongestedShiftPortion = 1.0 - pas.getAlternativeLowCost() / pas.getAlternativeHighCost();
                flowShift = assumedUncongestedShift + assumedCongestedShift * appliedCongestedShiftPortion;
            } else {
                flowShift = s2ShiftableFlow;
            }
        } else {
            double numerator = pas.getAlternativeHighCost() - pas.getAlternativeLowCost();
            flowShift = numerator / denominator;
            double diff = pas.getAlternativeLowCost() + denominatorS1 * flowShift - (pas.getAlternativeHighCost() + denominatorS2 * -flowShift);
            if (Precision.isNotEqual(diff, 0.0)) {
                LOGGER.severe("Computation of using derivatives to shift flows between PAS segments does not result in equal travel time after shift, this should not happen");
            }
        }
        return Math.min(s2ShiftableFlow, flowShift);
    }

    private boolean extendBushWithSuitableExistingPas(Bush originBush, DirectedVertex mergeVertex, double reducedCost) {
        boolean bushFlowThroughMergeVertex = false;
        for (EdgeSegment entrySegment : mergeVertex.getEntryEdgeSegments()) {
            for (EdgeSegment exitSegment : mergeVertex.getExitEdgeSegments()) {
                if (!originBush.containsTurnSendingFlow(entrySegment, exitSegment)) continue;
                bushFlowThroughMergeVertex = true;
                break;
            }
            if (!bushFlowThroughMergeVertex) continue;
            break;
        }
        if (!bushFlowThroughMergeVertex) {
            LOGGER.warning(String.format("Explored vertex %s for existing PAS match even though bush has not flow passing through it. This should not happen", mergeVertex.getXmlId()));
            return false;
        }
        double[] alphas = this.getLoading().getCurrentFlowAcceptanceFactors();
        Pas effectivePas = this.pasManager.findFirstSuitableExistingPas(originBush, mergeVertex, alphas, reducedCost);
        if (effectivePas == null) {
            return false;
        }
        effectivePas.registerOrigin(originBush);
        return true;
    }

    private Pas extendBushWithNewPas(Bush originBush, DirectedVertex mergeVertex, ShortestPathResult networkMinPaths) {
        Pas newPas = null;
        short[] alternativeSegmentVertexLabels = new short[this.getTransportNetwork().getNumberOfVerticesAllLayers()];
        alternativeSegmentVertexLabels[(int)mergeVertex.getId()] = 1;
        int shortestPathLength = networkMinPaths.forEachBackwardEdgeSegment(originBush.getOrigin().getCentroid(), mergeVertex, edgeSegment -> {
            alternativeSegmentVertexLabels[(int)edgeSegment.getUpstreamVertex().getId()] = -1;
        });
        Pair<DirectedVertex, Map<DirectedVertex, EdgeSegment>> highCostSegment = originBush.findBushAlternativeSubpath(mergeVertex, alternativeSegmentVertexLabels);
        if (highCostSegment == null) {
            LOGGER.info(String.format("Unable to create new PAS for origin zone %s, despite shorter path found on network to vertex %s", originBush.getOrigin().getXmlId(), mergeVertex.getXmlId()));
            return null;
        }
        boolean truncateSpareArrayCapacity = true;
        EdgeSegment[] s1 = PasManager.createSubpathArrayFrom(highCostSegment.first(), mergeVertex, networkMinPaths, shortestPathLength, truncateSpareArrayCapacity);
        EdgeSegment[] s2 = PasManager.createSubpathArrayFrom(highCostSegment.first(), mergeVertex, highCostSegment.second(), shortestPathLength, truncateSpareArrayCapacity);
        newPas = this.pasManager.createNewPas(originBush, s1, s2);
        this.getLoading().activateNodeTrackingFor(newPas);
        return newPas;
    }

    private OneToAllShortestPathAlgorithm createNetworkShortestPathAlgo(double[] linkSegmentCosts) {
        int numberOfEdgeSegments = this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers();
        int numberOfVertices = this.getTransportNetwork().getNumberOfVerticesAllLayers();
        return new DijkstraShortestPathAlgorithm(linkSegmentCosts, numberOfEdgeSegments, numberOfVertices);
    }

    private void initialiseBushes(double[] linkSegmentCosts) throws PlanItException {
        OneToAllShortestPathAlgorithm shortestPathAlgorithm = this.createNetworkShortestPathAlgo(linkSegmentCosts);
        Zoning zoning = this.getTransportNetwork().getZoning();
        OdDemands odDemands = this.getOdDemands();
        for (OdZone origin : zoning.getOdZones()) {
            ShortestPathResult oneToAllResult = null;
            InitialiseBushEdgeSegmentDemandConsumer initialiseBushConsumer = null;
            Bush originBush = null;
            for (OdZone destination : zoning.getOdZones()) {
                Double currOdDemand;
                if (destination.idEquals(origin) || (currOdDemand = (Double)odDemands.getValue(origin, destination)) == null || !(currOdDemand > 0.0)) continue;
                if (originBush == null) {
                    this.originBushes[(int)origin.getOdZoneId()] = originBush = new Bush(this.getIdGroupingToken(), origin, this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers());
                    initialiseBushConsumer = new InitialiseBushEdgeSegmentDemandConsumer(originBush);
                }
                initialiseBushConsumer.setDestination(destination.getCentroid(), currOdDemand);
                if (oneToAllResult == null) {
                    oneToAllResult = shortestPathAlgorithm.executeOneToAll(origin.getCentroid());
                }
                oneToAllResult.forEachBackwardEdgeSegment(origin.getCentroid(), destination.getCentroid(), initialiseBushConsumer);
            }
        }
    }

    private Collection<Pas> extendBushes(double[] linkSegmentCosts) throws PlanItException {
        ArrayList<Pas> newPass = new ArrayList<Pas>();
        OneToAllShortestPathAlgorithm networkShortestPathAlgo = this.createNetworkShortestPathAlgo(linkSegmentCosts);
        for (int index = 0; index < this.originBushes.length; ++index) {
            Bush originBush = this.originBushes[index];
            if (originBush == null) continue;
            MinMaxPathResult minMaxPaths = originBush.computeMinMaxShortestPaths(linkSegmentCosts, this.getTransportNetwork().getNumberOfVerticesAllLayers());
            ShortestPathResult networkMinPaths = networkShortestPathAlgo.executeOneToAll(originBush.getOrigin().getCentroid());
            Iterator<DirectedVertex> bushVertexIter = originBush.getDirectedVertexIterator();
            while (bushVertexIter.hasNext()) {
                Pas newPas;
                double reducedCost;
                boolean matchFound;
                DirectedVertex bushVertex = bushVertexIter.next();
                EdgeSegment reducedCostSegment = networkMinPaths.getIncomingEdgeSegmentForVertex(bushVertex);
                if (reducedCostSegment == null || originBush.containsAnyEdgeSegmentOf(reducedCostSegment.getParentEdge()) || (matchFound = this.extendBushWithSuitableExistingPas(originBush, bushVertex, reducedCost = minMaxPaths.getCostToReach(bushVertex) - networkMinPaths.getCostToReach(bushVertex))) || (newPas = this.extendBushWithNewPas(originBush, bushVertex, networkMinPaths)) == null) continue;
                newPass.add(newPas);
            }
        }
        return newPass;
    }

    private boolean shiftFlows(Mode theMode) {
        boolean flowShifted = false;
        ArrayList<Pas> passWithoutOrigins = new ArrayList<Pas>();
        StaticLtmLoadingBush networkLoading = this.getLoading();
        LinkBasedRelativeDualityGapFunction gapFunction = (LinkBasedRelativeDualityGapFunction)this.getTrafficAssignmentComponent(GapFunction.class);
        PhysicalCost physicalCost = this.getTrafficAssignmentComponent(AbstractPhysicalCost.class);
        VirtualCost virtualCost = this.getTrafficAssignmentComponent(AbstractVirtualCost.class);
        Predicate<EdgeSegment> firstCongestedLinkSegment = es -> this.getLoading().getCurrentFlowAcceptanceFactors()[(int)es.getId()] < 1.0;
        BitSet linkSegmentsUsed = new BitSet(networkLoading.getCurrentInflowsPcuH().length);
        PriorityQueue<Pas> sortedPass = this.pasManager.getPassSortedByReducedCost();
        for (Pas pas2 : sortedPass) {
            double s2ShiftableFlow = networkLoading.computeSubPathSendingFlow(pas2.getDivergeVertex(), pas2.getMergeVertex(), pas2.getAlternative(false));
            double s1SendingFlow = networkLoading.computeSubPathSendingFlow(pas2.getDivergeVertex(), pas2.getMergeVertex(), pas2.getAlternative(true));
            this.updateGap(gapFunction, pas2, s1SendingFlow, s2ShiftableFlow);
            if (pas2.containsAny(linkSegmentsUsed)) continue;
            double flowShift = this.determineFlowShift(pas2, s2ShiftableFlow, theMode, physicalCost, virtualCost, networkLoading, firstCongestedLinkSegment);
            boolean pasFlowShifted = pas2.executeFlowShift(s2ShiftableFlow, flowShift, networkLoading.getCurrentFlowAcceptanceFactors());
            if (!pas2.hasOrigins()) {
                passWithoutOrigins.add(pas2);
            }
            if (!pasFlowShifted) continue;
            pas2.forEachEdgeSegment(true, es -> linkSegmentsUsed.set((int)es.getId()));
            pas2.forEachEdgeSegment(false, es -> linkSegmentsUsed.set((int)es.getId()));
            flowShifted = true;
        }
        if (!passWithoutOrigins.isEmpty()) {
            passWithoutOrigins.forEach(pas -> this.pasManager.removePas((Pas)pas));
        }
        return flowShifted;
    }

    @Override
    protected StaticLtmLoadingBush createNetworkLoading() {
        return new StaticLtmLoadingBush(this.getIdGroupingToken(), this.getAssignmentId(), this.getSettings());
    }

    @Override
    protected StaticLtmLoadingBush getLoading() {
        return (StaticLtmLoadingBush)super.getLoading();
    }

    @Override
    public void createInitialSolution(double[] initialLinkSegmentCosts) {
        try {
            this.initialiseBushes(initialLinkSegmentCosts);
            this.getLoading().setBushes(this.originBushes);
            this.getLoading().setPasManager(this.pasManager);
        }
        catch (PlanItException e) {
            LOGGER.severe(String.format("Unable to create initial bushes for sLTM %d", this.getAssignmentId()));
        }
    }

    public StaticLtmBushStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
        this.originBushes = new Bush[transportModelNetwork.getZoning().getOdZones().size()];
        this.pasManager = new PasManager();
    }

    @Override
    public boolean performIteration(Mode theMode, double[] costsToUpdate, int iterationIndex) {
        try {
            this.executeNetworkLoading();
            boolean updateOnlyPotentiallyBlockingNodeCosts = this.getLoading().getActivatedSolutionScheme().equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC);
            this.executeNetworkCostsUpdate(theMode, updateOnlyPotentiallyBlockingNodeCosts, costsToUpdate);
            this.pasManager.updateCosts(costsToUpdate);
            Collection<Pas> newPass = this.extendBushes(costsToUpdate);
            this.pasManager.updateCosts(newPass, costsToUpdate);
            this.shiftFlows(theMode);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to complete sLTM iteration");
            if (this.getSettings().isDetailedLogging().booleanValue()) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "Bush-based";
    }
}

